/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.io.jvm.AudioPlayer;
import java.util.Random;
import javax.sound.sampled.LineUnavailableException;

public class AmplitudeModulatedNoise
implements AudioProcessor {
    Random rnd = new Random();
    float dry = 0.7f;

    @Override
    public boolean process(AudioEvent audioEvent) {
        int i;
        float[] audioBuffer = audioEvent.getFloatBuffer();
        float max = 0.0f;
        for (int i2 = 0; i2 < audioBuffer.length; ++i2) {
            max = Math.max(audioBuffer[i2], max);
        }
        float[] noiseBuffer = new float[audioBuffer.length];
        for (int i3 = 0; i3 < audioBuffer.length; ++i3) {
            noiseBuffer[i3] = this.rnd.nextBoolean() ? (float)(this.rnd.nextGaussian() * (double)max) : (float)(this.rnd.nextGaussian() * (double)max * -1.0);
        }
        float stdDevNoise = this.standardDeviation(noiseBuffer);
        float stdDevAudio = this.standardDeviation(audioBuffer);
        for (i = 0; i < audioBuffer.length; ++i) {
            audioBuffer[i] = audioBuffer[i] / stdDevNoise * stdDevAudio;
        }
        for (i = 0; i < audioBuffer.length; ++i) {
            audioBuffer[i] = audioBuffer[i] * this.dry + noiseBuffer[i] * (1.0f - this.dry);
        }
        return true;
    }

    private float standardDeviation(float[] data2) {
        float sum = 0.0f;
        for (int i = 0; i < data2.length; ++i) {
            sum += data2[i];
        }
        float mean = sum / (float)data2.length;
        sum = 0.0f;
        for (int i = 0; i < data2.length; ++i) {
            sum += (data2[i] - mean) * (data2[i] - mean);
        }
        float variance = sum / (float)(data2.length - 1);
        return (float)Math.sqrt(variance);
    }

    @Override
    public void processingFinished() {
    }

    public static void main(String ... args) throws LineUnavailableException {
        String file = "/home/joren/Desktop/parklife/Alles_Is_Op.wav";
        AudioDispatcher d = AudioDispatcherFactory.fromPipe(file, 44100, 1024, 0);
        final AmplitudeModulatedNoise noise = new AmplitudeModulatedNoise();
        d.addAudioProcessor(noise);
        d.addAudioProcessor(new AudioPlayer(d.getFormat()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                float i = 0.0f;
                while ((double)i < 1.1) {
                    noise.dry = i;
                    System.out.println(i);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    i = (float)((double)i + 0.1);
                }
            }
        }).start();
        d.run();
    }
}

