/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class GainProcessor
implements AudioProcessor {
    private double gain;

    public GainProcessor(double newGain) {
        this.setGain(newGain);
    }

    public void setGain(double newGain) {
        this.gain = newGain;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioFloatBuffer = audioEvent.getFloatBuffer();
        for (int i = audioEvent.getOverlap(); i < audioFloatBuffer.length; ++i) {
            float newValue = (float)((double)audioFloatBuffer[i] * this.gain);
            if (newValue > 1.0f) {
                newValue = 1.0f;
            } else if (newValue < -1.0f) {
                newValue = -1.0f;
            }
            audioFloatBuffer[i] = newValue;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

