/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class Oscilloscope
implements AudioProcessor {
    float[] dataBuffer;
    private final OscilloscopeEventHandler handler;

    public Oscilloscope(OscilloscopeEventHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioBuffer = audioEvent.getFloatBuffer();
        int offset = 0;
        float maxdx = 0.0f;
        for (int i = 0; i < audioBuffer.length / 4; ++i) {
            float dx = audioBuffer[i + 1] - audioBuffer[i];
            if (!(dx > maxdx)) continue;
            offset = i;
            maxdx = dx;
        }
        float tbase = audioBuffer.length / 2;
        int length = Math.min((int)tbase, audioBuffer.length - offset);
        if (this.dataBuffer == null || this.dataBuffer.length != length * 4) {
            this.dataBuffer = new float[length * 4];
        }
        int j = 0;
        for (int i = 0; i < length - 1; ++i) {
            float x1 = (float)i / tbase;
            float x2 = (float)i / tbase;
            this.dataBuffer[j] = x1;
            this.dataBuffer[j + 1] = audioBuffer[i + offset];
            this.dataBuffer[j + 2] = x2;
            this.dataBuffer[j + 3] = audioBuffer[i + 1 + offset];
            j += 4;
        }
        this.handler.handleEvent(this.dataBuffer, audioEvent);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static interface OscilloscopeEventHandler {
        public void handleEvent(float[] var1, AudioEvent var2);
    }
}

