/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class SilenceDetector
implements AudioProcessor {
    public static final double DEFAULT_SILENCE_THRESHOLD = -70.0;
    private final double threshold;
    private final boolean breakProcessingQueueOnSilence;
    double currentSPL = 0.0;

    public SilenceDetector() {
        this(-70.0, false);
    }

    public SilenceDetector(double silenceThreshold, boolean breakProcessingQueueOnSilence) {
        this.threshold = silenceThreshold;
        this.breakProcessingQueueOnSilence = breakProcessingQueueOnSilence;
    }

    private double localEnergy(float[] buffer) {
        double power = 0.0;
        for (float element : buffer) {
            power += (double)(element * element);
        }
        return power;
    }

    private double soundPressureLevel(float[] buffer) {
        double value = Math.pow(this.localEnergy(buffer), 0.5);
        return this.linearToDecibel(value /= (double)buffer.length);
    }

    private double linearToDecibel(double value) {
        return 20.0 * Math.log10(value);
    }

    public double currentSPL() {
        return this.currentSPL;
    }

    public boolean isSilence(float[] buffer, double silenceThreshold) {
        this.currentSPL = this.soundPressureLevel(buffer);
        return this.currentSPL < silenceThreshold;
    }

    public boolean isSilence(float[] buffer) {
        return this.isSilence(buffer, this.threshold);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        boolean isSilence = this.isSilence(audioEvent.getFloatBuffer());
        if (this.breakProcessingQueueOnSilence) {
            return !isSilence;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

