/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Agent;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import java.util.ListIterator;

public class AgentList {
    public static boolean useAverageSalience = false;
    public static boolean debug = false;
    public static final double DEFAULT_BI = 0.02;
    public static final double DEFAULT_BT = 0.04;
    public Agent ag;
    public AgentList next;
    public static int count = 0;
    public static double thresholdBI = 0.02;
    public static double thresholdBT = 0.04;

    public AgentList() {
        this(null, null);
    }

    public AgentList(Agent a, AgentList al) {
        this.ag = a;
        this.next = al;
        if (this.next == null) {
            if (this.ag != null) {
                this.next = new AgentList();
            } else {
                count = 0;
                thresholdBI = 0.02;
                thresholdBT = 0.04;
            }
        }
    }

    public void print() {
        System.out.println("agentList.print: (size=" + count + ")");
        AgentList ptr = this;
        while (ptr.ag != null) {
            ptr.ag.print(2);
            ptr = ptr.next;
        }
        System.out.println("End of agentList.print()");
    }

    public void add(Agent a) {
        this.add(a, true);
    }

    public void add(Agent newAgent, boolean sort) {
        if (newAgent == null) {
            return;
        }
        ++count;
        AgentList ptr = this;
        while (ptr.ag != null) {
            if (sort && newAgent.beatInterval <= ptr.ag.beatInterval) {
                ptr.next = new AgentList(ptr.ag, ptr.next);
                ptr.ag = newAgent;
                return;
            }
            ptr = ptr.next;
        }
        ptr.next = new AgentList();
        ptr.ag = newAgent;
    }

    public void sort() {
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            AgentList ptr = this;
            while (ptr.ag != null) {
                if (ptr.next.ag != null && ptr.ag.beatInterval > ptr.next.ag.beatInterval) {
                    Agent temp = ptr.ag;
                    ptr.ag = ptr.next.ag;
                    ptr.next.ag = temp;
                    sorted = false;
                }
                ptr = ptr.next;
            }
        }
    }

    public void remove(AgentList ptr) {
        --count;
        ptr.ag = ptr.next.ag;
        ptr.next = ptr.next.next;
    }

    protected void removeDuplicates() {
        this.sort();
        AgentList ptr = this;
        while (ptr.ag != null) {
            if (!(ptr.ag.phaseScore < 0.0)) {
                AgentList ptr2 = ptr.next;
                while (ptr2.ag != null && !(ptr2.ag.beatInterval - ptr.ag.beatInterval > thresholdBI)) {
                    if (!(Math.abs(ptr.ag.beatTime - ptr2.ag.beatTime) > thresholdBT)) {
                        if (ptr.ag.phaseScore < ptr2.ag.phaseScore) {
                            ptr.ag.phaseScore = -1.0;
                            if (!(ptr2.ag.topScoreTime < ptr.ag.topScoreTime)) break;
                            ptr2.ag.topScoreTime = ptr.ag.topScoreTime;
                            break;
                        }
                        ptr2.ag.phaseScore = -1.0;
                        if (ptr.ag.topScoreTime < ptr2.ag.topScoreTime) {
                            ptr.ag.topScoreTime = ptr2.ag.topScoreTime;
                        }
                    }
                    ptr2 = ptr2.next;
                }
            }
            ptr = ptr.next;
        }
        ptr = this;
        while (ptr.ag != null) {
            if (ptr.ag.phaseScore < 0.0) {
                this.remove(ptr);
                continue;
            }
            ptr = ptr.next;
        }
    }

    public void beatTrack(EventList el) {
        this.beatTrack(el, -1.0);
    }

    public void beatTrack(EventList el, double stop) {
        boolean phaseGiven;
        ListIterator<Event> ptr = el.listIterator();
        boolean bl = phaseGiven = this.ag != null && this.ag.beatTime >= 0.0;
        while (ptr.hasNext()) {
            Event ev = ptr.next();
            if (stop > 0.0 && ev.keyDown > stop) break;
            boolean created = phaseGiven;
            double prevBeatInterval = -1.0;
            AgentList ap = this;
            while (ap.ag != null) {
                Agent currentAgent = ap.ag;
                if (currentAgent.beatInterval != prevBeatInterval) {
                    if (prevBeatInterval >= 0.0 && !created && ev.keyDown < 5.0) {
                        Agent newAgent = new Agent(prevBeatInterval);
                        newAgent.considerAsBeat(ev, this);
                        this.add(newAgent);
                    }
                    prevBeatInterval = currentAgent.beatInterval;
                    created = phaseGiven;
                }
                if (currentAgent.considerAsBeat(ev, this)) {
                    created = true;
                }
                if (currentAgent != ap.ag) {
                    ap = ap.next;
                }
                ap = ap.next;
            }
            this.removeDuplicates();
        }
    }

    public Agent bestAgent() {
        double best = -1.0;
        Agent bestAg = null;
        AgentList ap = this;
        while (ap.ag != null) {
            double startTime = ap.ag.events.l.getFirst().keyDown;
            double conf = (ap.ag.phaseScore + ap.ag.tempoScore) / (useAverageSalience ? (double)ap.ag.beatCount : 1.0);
            if (conf > best) {
                bestAg = ap.ag;
                best = conf;
            }
            if (debug) {
                ap.ag.print(0);
                System.out.printf(" +%5.3f    Av-salience = %3.1f\n", startTime, conf);
            }
            ap = ap.next;
        }
        if (debug) {
            if (bestAg != null) {
                System.out.print("Best ");
                bestAg.print(0);
                System.out.printf("    Av-salience = %5.1f\n", best);
            } else {
                System.out.println("No surviving agent - beat tracking failed");
            }
        }
        return bestAg;
    }
}

