/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io;

import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.util.FFMPEGDownloader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public class PipeDecoder {
    private static final Logger LOG = Logger.getLogger(PipeDecoder.class.getName());
    private final String pipeEnvironment;
    private final String pipeArgument;
    private final String pipeCommand;
    private final int pipeBuffer;
    private boolean printErrorstream = false;
    private String decoderBinaryAbsolutePath;

    public PipeDecoder() {
        this.pipeBuffer = 10000;
        if (System.getProperty("os.name").indexOf("indows") > 0) {
            this.pipeEnvironment = "cmd.exe";
            this.pipeArgument = "/C";
        } else if (new File("/bin/bash").exists()) {
            this.pipeEnvironment = "/bin/bash";
            this.pipeArgument = "-c";
        } else if (new File("/system/bin/sh").exists()) {
            this.pipeEnvironment = "/system/bin/sh";
            this.pipeArgument = "-c";
        } else {
            LOG.severe("Coud not find a command line environment (cmd.exe or /bin/bash)");
            throw new Error("Decoding via a pipe will not work: Coud not find a command line environment (cmd.exe or /bin/bash)");
        }
        String path = System.getenv("PATH");
        String arguments = " -i \"%resource%\" -vn -ar %sample_rate% -ac %channels% -sample_fmt s16 -f s16le pipe:1";
        if (this.isAvailable("ffmpeg")) {
            LOG.info("found ffmpeg on the path (" + path + "). Will use ffmpeg for decoding media files.");
            this.pipeCommand = "ffmpeg" + arguments;
        } else if (this.isAvailable("avconv")) {
            LOG.info("found avconv on your path(" + path + "). Will use avconv for decoding media files.");
            this.pipeCommand = "avconv" + arguments;
        } else {
            if (this.isAndroid()) {
                String tempDirectory = System.getProperty("java.io.tmpdir");
                this.printErrorstream = true;
                File f = new File(tempDirectory, "ffmpeg");
                if (f.exists() && f.length() > 1000000L && f.canExecute()) {
                    this.decoderBinaryAbsolutePath = f.getAbsolutePath();
                } else {
                    LOG.severe("Could not find an ffmpeg binary for your Android system. Did you forget calling: 'new AndroidFFMPEGLocator(this);' ?");
                    LOG.severe("Tried to unpack a statically compiled ffmpeg binary for your architecture to: " + f.getAbsolutePath());
                }
            } else {
                LOG.warning("Dit not find ffmpeg or avconv on your path(" + path + "), will try to download it automatically.");
                FFMPEGDownloader downloader = new FFMPEGDownloader();
                this.decoderBinaryAbsolutePath = downloader.ffmpegBinary();
                if (this.decoderBinaryAbsolutePath == null) {
                    LOG.severe("Could not download an ffmpeg binary automatically for your system.");
                }
            }
            if (this.decoderBinaryAbsolutePath == null) {
                this.pipeCommand = "false";
                throw new Error("Decoding via a pipe will not work: Could not find an ffmpeg binary for your system");
            }
            this.pipeCommand = '\"' + this.decoderBinaryAbsolutePath + '\"' + arguments;
        }
    }

    private boolean isAvailable(String command) {
        try {
            Runtime.getRuntime().exec(command + " -version");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public PipeDecoder(String pipeEnvironment, String pipeArgument, String pipeCommand, String pipeLogFile, int pipeBuffer) {
        this.pipeEnvironment = pipeEnvironment;
        this.pipeArgument = pipeArgument;
        this.pipeCommand = pipeCommand;
        this.pipeBuffer = pipeBuffer;
    }

    public InputStream getDecodedStream(String resource, int targetSampleRate) {
        try {
            String command = this.pipeCommand;
            command = command.replace("%resource%", resource);
            command = command.replace("%sample_rate%", String.valueOf(targetSampleRate));
            command = command.replace("%channels%", "1");
            ProcessBuilder pb = new ProcessBuilder(this.pipeEnvironment, this.pipeArgument, command);
            LOG.info("Starting piped decoding process for " + resource);
            final Process process = pb.start();
            BufferedInputStream stdOut = new BufferedInputStream(process.getInputStream(), this.pipeBuffer){

                @Override
                public void close() throws IOException {
                    super.close();
                    process.destroy();
                }
            };
            if (this.printErrorstream) {
                new ErrorStreamGobbler(process.getErrorStream(), LOG).start();
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        process.waitFor();
                        LOG.info("Finished piped decoding process");
                    }
                    catch (InterruptedException e) {
                        LOG.severe("Interrupted while waiting for decoding sub process exit.");
                        e.printStackTrace();
                    }
                }
            }, "Decoding Pipe").start();
            return stdOut;
        }
        catch (IOException e) {
            LOG.warning("IO exception while decoding audio via sub process." + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void printBinaryInfo() {
        try {
            Process p = Runtime.getRuntime().exec(this.decoderBinaryAbsolutePath);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                System.out.println(line);
            }
            input.close();
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static TarsosDSPAudioFormat getTargetAudioFormat(int targetSampleRate) {
        TarsosDSPAudioFormat audioFormat = new TarsosDSPAudioFormat(TarsosDSPAudioFormat.Encoding.PCM_SIGNED, targetSampleRate, 16, 1, 2, targetSampleRate, ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()));
        return audioFormat;
    }

    private boolean isAndroid() {
        try {
            Class.forName("android.app.Activity");
            System.out.println("Running on Android!");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private class ErrorStreamGobbler
    extends Thread {
        private final InputStream is;
        private final Logger logger;

        private ErrorStreamGobbler(InputStream is, Logger logger) {
            this.is = is;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.logger.info(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

