/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io;

import be.tarsos.dsp.io.PipeDecoder;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.TarsosDSPAudioInputStream;
import be.tarsos.dsp.io.UniversalAudioInputStream;
import be.tarsos.dsp.util.AudioResourceUtils;
import java.io.InputStream;

public class PipedAudioStream {
    private final String resource;
    private static PipeDecoder pipeDecoder = new PipeDecoder();
    private final PipeDecoder decoder;

    public static void setDecoder(PipeDecoder decoder) {
        pipeDecoder = decoder;
    }

    public PipedAudioStream(String resource) {
        this.resource = AudioResourceUtils.sanitizeResource(resource);
        this.decoder = pipeDecoder;
    }

    public TarsosDSPAudioInputStream getMonoStream(int targetSampleRate) {
        InputStream stream = null;
        stream = this.decoder.getDecodedStream(this.resource, targetSampleRate);
        return new UniversalAudioInputStream(stream, this.getTargetFormat(targetSampleRate));
    }

    private TarsosDSPAudioFormat getTargetFormat(int targetSampleRate) {
        return new TarsosDSPAudioFormat(targetSampleRate, 16, 1, true, false);
    }
}

