/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io.jvm;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.jvm.JVMAudioInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class AudioPlayer
implements AudioProcessor {
    private SourceDataLine line;
    private final AudioFormat format;

    public AudioPlayer(AudioFormat format) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        this.format = format;
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        this.line.open();
        this.line.start();
    }

    public AudioPlayer(AudioFormat format, int bufferSize) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format, bufferSize);
        this.format = format;
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        this.line.open(format, bufferSize * 2);
        System.out.println("Buffer size:" + this.line.getBufferSize());
        this.line.start();
    }

    public AudioPlayer(TarsosDSPAudioFormat format, int bufferSize) throws LineUnavailableException {
        this(JVMAudioInputStream.toAudioFormat(format), bufferSize);
    }

    public AudioPlayer(TarsosDSPAudioFormat format) throws LineUnavailableException {
        this(JVMAudioInputStream.toAudioFormat(format));
    }

    public long getMicroSecondPosition() {
        return this.line.getMicrosecondPosition();
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int bytesWritten;
        int byteOverlap = audioEvent.getOverlap() * this.format.getFrameSize();
        int byteStepSize = audioEvent.getBufferSize() * this.format.getFrameSize() - byteOverlap;
        if (audioEvent.getTimeStamp() == 0.0) {
            byteOverlap = 0;
            byteStepSize = audioEvent.getBufferSize() * this.format.getFrameSize();
        }
        if ((bytesWritten = this.line.write(audioEvent.getByteBuffer(), byteOverlap, byteStepSize)) != byteStepSize) {
            System.err.println(String.format("Expected to write %d bytes but only wrote %d bytes", byteStepSize, bytesWritten));
        }
        return true;
    }

    @Override
    public void processingFinished() {
        this.line.drain();
        this.line.stop();
        this.line.close();
    }
}

