/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.onsets;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.onsets.OnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.util.fft.FFT;

public class PercussionOnsetDetector
implements AudioProcessor,
OnsetDetector {
    public static final double DEFAULT_THRESHOLD = 8.0;
    public static final double DEFAULT_SENSITIVITY = 20.0;
    private final FFT fft;
    private final float[] priorMagnitudes;
    private final float[] currentMagnitudes;
    private float dfMinus1;
    private float dfMinus2;
    private OnsetHandler handler;
    private final float sampleRate;
    private long processedSamples;
    private final double sensitivity;
    private final double threshold;

    public PercussionOnsetDetector(float sampleRate, int bufferSize, int bufferOverlap, OnsetHandler handler) {
        this(sampleRate, bufferSize, handler, 20.0, 8.0);
    }

    public PercussionOnsetDetector(float sampleRate, int bufferSize, OnsetHandler handler, double sensitivity, double threshold) {
        this.fft = new FFT(bufferSize / 2);
        this.threshold = threshold;
        this.sensitivity = sensitivity;
        this.priorMagnitudes = new float[bufferSize / 2];
        this.currentMagnitudes = new float[bufferSize / 2];
        this.handler = handler;
        this.sampleRate = sampleRate;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioFloatBuffer = audioEvent.getFloatBuffer();
        this.processedSamples += (long)audioFloatBuffer.length;
        this.processedSamples -= (long)audioEvent.getOverlap();
        this.fft.forwardTransform(audioFloatBuffer);
        this.fft.modulus(audioFloatBuffer, this.currentMagnitudes);
        int binsOverThreshold = 0;
        for (int i = 0; i < this.currentMagnitudes.length; ++i) {
            double diff;
            if (this.priorMagnitudes[i] > 0.0f && (diff = 10.0 * Math.log10(this.currentMagnitudes[i] / this.priorMagnitudes[i])) >= this.threshold) {
                ++binsOverThreshold;
            }
            this.priorMagnitudes[i] = this.currentMagnitudes[i];
        }
        if (this.dfMinus2 < this.dfMinus1 && this.dfMinus1 >= (float)binsOverThreshold && (double)this.dfMinus1 > (100.0 - this.sensitivity) * (double)audioFloatBuffer.length / 200.0) {
            float timeStamp = (float)this.processedSamples / this.sampleRate;
            this.handler.handleOnset(timeStamp, -1.0);
        }
        this.dfMinus2 = this.dfMinus1;
        this.dfMinus1 = binsOverThreshold;
        return true;
    }

    @Override
    public void processingFinished() {
    }

    @Override
    public void setHandler(OnsetHandler handler) {
        this.handler = handler;
    }
}

