/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;

public class AMDF
implements PitchDetector {
    private static final double DEFAULT_MIN_FREQUENCY = 82.0;
    private static final double DEFAULT_MAX_FREQUENCY = 1000.0;
    private static final double DEFAULT_RATIO = 5.0;
    private static final double DEFAULT_SENSITIVITY = 0.1;
    private final float sampleRate;
    private final double[] amd;
    private final long maxPeriod;
    private final long minPeriod;
    private final double ratio;
    private final double sensitivity;
    private final PitchDetectionResult result;

    public AMDF(float sampleRate, int bufferSize) {
        this(sampleRate, bufferSize, 82.0, 1000.0);
    }

    public AMDF(float sampleRate, int bufferSize, double minFrequency, double maxFrequency) {
        this.sampleRate = sampleRate;
        this.amd = new double[bufferSize];
        this.ratio = 5.0;
        this.sensitivity = 0.1;
        this.maxPeriod = Math.round((double)sampleRate / minFrequency + 0.5);
        this.minPeriod = Math.round((double)sampleRate / maxFrequency + 0.5);
        this.result = new PitchDetectionResult();
    }

    @Override
    public PitchDetectionResult getPitch(float[] audioBuffer) {
        int j;
        int t = 0;
        float f0 = -1.0f;
        double minval = Double.POSITIVE_INFINITY;
        double maxval = Double.NEGATIVE_INFINITY;
        double[] frames1 = new double[]{};
        double[] frames2 = new double[]{};
        double[] calcSub = new double[]{};
        int maxShift = audioBuffer.length;
        for (int i = 0; i < maxShift; ++i) {
            frames1 = new double[maxShift - i + 1];
            frames2 = new double[maxShift - i + 1];
            t = 0;
            for (int aux1 = 0; aux1 < maxShift - i; ++aux1) {
                frames1[++t] = audioBuffer[aux1];
            }
            t = 0;
            for (int aux2 = i; aux2 < maxShift; ++aux2) {
                frames2[++t] = audioBuffer[aux2];
            }
            int frameLength = frames1.length;
            calcSub = new double[frameLength];
            for (int u = 0; u < frameLength; ++u) {
                calcSub[u] = frames1[u] - frames2[u];
            }
            double summation = 0.0;
            for (int l = 0; l < frameLength; ++l) {
                summation += Math.abs(calcSub[l]);
            }
            this.amd[i] = summation;
        }
        for (int j2 = (int)this.minPeriod; j2 < (int)this.maxPeriod; ++j2) {
            if (this.amd[j2] < minval) {
                minval = this.amd[j2];
            }
            if (!(this.amd[j2] > maxval)) continue;
            maxval = this.amd[j2];
        }
        int cutoff = (int)Math.round(this.sensitivity * (maxval - minval) + minval);
        for (j = (int)this.minPeriod; j <= (int)this.maxPeriod && this.amd[j] > (double)cutoff; ++j) {
        }
        double search_length = this.minPeriod / 2L;
        minval = this.amd[j];
        int minpos = j;
        int i = j;
        while ((double)i < (double)j + search_length && (long)i <= this.maxPeriod) {
            if (!(this.amd[++i] < minval)) continue;
            minval = this.amd[i];
            minpos = i;
        }
        if ((double)Math.round(this.amd[minpos] * this.ratio) < maxval) {
            f0 = this.sampleRate / (float)minpos;
        }
        this.result.setPitch(f0);
        this.result.setPitched(-1.0f != f0);
        this.result.setProbability(-1.0f);
        return this.result;
    }
}

