/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

public class DTMF {
    public static final double[] DTMF_FREQUENCIES = new double[]{697.0, 770.0, 852.0, 941.0, 1209.0, 1336.0, 1477.0, 1633.0};
    public static final char[][] DTMF_CHARACTERS = new char[][]{{'1', '2', '3', 'A'}, {'4', '5', '6', 'B'}, {'7', '8', '9', 'C'}, {'*', '0', '#', 'D'}};

    public static float[] generateDTMFTone(char character) {
        double firstFrequency = -1.0;
        double secondFrequency = -1.0;
        for (int row = 0; row < DTMF_CHARACTERS.length; ++row) {
            for (int col = 0; col < DTMF_CHARACTERS[row].length; ++col) {
                if (DTMF_CHARACTERS[row][col] != character) continue;
                firstFrequency = DTMF_FREQUENCIES[row];
                secondFrequency = DTMF_FREQUENCIES[col + 4];
            }
        }
        return DTMF.audioBufferDTMF(firstFrequency, secondFrequency, 10240);
    }

    public static boolean isDTMFCharacter(char character) {
        double firstFrequency = -1.0;
        double secondFrequency = -1.0;
        for (int row = 0; row < DTMF_CHARACTERS.length; ++row) {
            for (int col = 0; col < DTMF_CHARACTERS[row].length; ++col) {
                if (DTMF_CHARACTERS[row][col] != character) continue;
                firstFrequency = DTMF_FREQUENCIES[row];
                secondFrequency = DTMF_FREQUENCIES[col + 4];
            }
        }
        return firstFrequency != -1.0 && secondFrequency != -1.0;
    }

    public static float[] audioBufferDTMF(double f0, double f1, int size) {
        double sampleRate = 44100.0;
        double amplitudeF0 = 0.4;
        double amplitudeF1 = 0.4;
        double twoPiF0 = Math.PI * 2 * f0;
        double twoPiF1 = Math.PI * 2 * f1;
        float[] buffer = new float[size];
        for (int sample = 0; sample < buffer.length; ++sample) {
            double time = (double)sample / 44100.0;
            double f0Component = 0.4 * Math.sin(twoPiF0 * time);
            double f1Component = 0.4 * Math.sin(twoPiF1 * time);
            buffer[sample] = (float)(f0Component + f1Component);
        }
        return buffer;
    }
}

