/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;
import java.util.Arrays;

public class DynamicWavelet
implements PitchDetector {
    private final int maxFLWTlevels = 6;
    private final double maxF = 3000.0;
    private final int differenceLevelsN = 3;
    private final double maximaThresholdRatio = 0.75;
    private final PitchDetectionResult result;
    private final float sampleRate;
    int[] distances;
    int[] mins;
    int[] maxs;

    public DynamicWavelet(float sampleRate, int bufferSize) {
        this.sampleRate = sampleRate;
        this.distances = new int[bufferSize];
        this.mins = new int[bufferSize];
        this.maxs = new int[bufferSize];
        this.result = new PitchDetectionResult();
    }

    @Override
    public PitchDetectionResult getPitch(float[] audioBuffer) {
        float pitchF = -1.0f;
        int curSamNb = audioBuffer.length;
        if (this.distances.length == audioBuffer.length) {
            Arrays.fill(this.distances, 0);
            Arrays.fill(this.mins, 0);
            Arrays.fill(this.maxs, 0);
        } else {
            this.distances = new int[audioBuffer.length];
            this.mins = new int[audioBuffer.length];
            this.maxs = new int[audioBuffer.length];
        }
        double theDC = 0.0;
        double maxValue = 0.0;
        double minValue = 0.0;
        for (int i = 0; i < audioBuffer.length; ++i) {
            double sample = audioBuffer[i];
            theDC += sample;
            maxValue = Math.max(maxValue, sample);
            minValue = Math.min(sample, minValue);
        }
        double amplitudeMax = (maxValue -= (theDC /= (double)audioBuffer.length)) > -(minValue -= theDC) ? maxValue : -minValue;
        double ampltitudeThreshold = amplitudeMax * 0.75;
        int curLevel = 0;
        double curModeDistance = -1.0;
        while (true) {
            double similarity;
            int delta = (int)((double)this.sampleRate / (Math.pow(2.0, curLevel) * 3000.0));
            if (curSamNb < 2) break;
            double previousDV = -1000.0;
            int nbMaxs = 0;
            int nbMins = 0;
            int lastMinIndex = -1000000;
            int lastmaxIndex = -1000000;
            boolean findMax = false;
            boolean findMin = false;
            for (int i = 2; i < curSamNb; ++i) {
                double si = (double)audioBuffer[i] - theDC;
                double si1 = (double)audioBuffer[i - 1] - theDC;
                if (si1 <= 0.0 && si > 0.0) {
                    findMax = true;
                }
                if (si1 >= 0.0 && si < 0.0) {
                    findMin = true;
                }
                double dv = si - si1;
                if (previousDV > -1000.0) {
                    if (findMin && previousDV < 0.0 && dv >= 0.0 && Math.abs(si) >= ampltitudeThreshold && i > lastMinIndex + delta) {
                        this.mins[nbMins++] = i;
                        lastMinIndex = i;
                        findMin = false;
                    }
                    if (findMax && previousDV > 0.0 && dv <= 0.0 && Math.abs(si) >= ampltitudeThreshold && i > lastmaxIndex + delta) {
                        this.maxs[nbMaxs++] = i;
                        lastmaxIndex = i;
                        findMax = false;
                    }
                }
                previousDV = dv;
            }
            if (nbMins == 0 && nbMaxs == 0) break;
            Arrays.fill(this.distances, 0);
            for (int i = 0; i < nbMins; ++i) {
                for (int j = 1; j < 3; ++j) {
                    if (i + j >= nbMins) continue;
                    int d = Math.abs(this.mins[i] - this.mins[i + j]);
                    this.distances[d] = this.distances[d] + 1;
                }
            }
            int bestDistance = -1;
            int bestValue = -1;
            for (int i = 0; i < curSamNb; ++i) {
                int summed = 0;
                for (int j = -delta; j <= delta; ++j) {
                    if (i + j < 0 || i + j >= curSamNb) continue;
                    summed += this.distances[i + j];
                }
                if (summed == bestValue) {
                    if (i != 2 * bestDistance) continue;
                    bestDistance = i;
                    continue;
                }
                if (summed <= bestValue) continue;
                bestValue = summed;
                bestDistance = i;
            }
            double distAvg = 0.0;
            double nbDists = 0.0;
            for (int j = -delta; j <= delta; ++j) {
                int nbDist;
                if (bestDistance + j < 0 || bestDistance + j >= audioBuffer.length || (nbDist = this.distances[bestDistance + j]) <= 0) continue;
                nbDists += (double)nbDist;
                distAvg += (double)((bestDistance + j) * nbDist);
            }
            distAvg /= nbDists;
            if (curModeDistance > -1.0 && (similarity = Math.abs(distAvg * 2.0 - curModeDistance)) <= (double)(2 * delta)) {
                pitchF = (float)((double)this.sampleRate / (Math.pow(2.0, curLevel - 1) * curModeDistance));
                break;
            }
            curModeDistance = distAvg;
            if (++curLevel >= 6 || curSamNb < 2) break;
            float[] newAudioBuffer = audioBuffer;
            if (curSamNb == this.distances.length) {
                newAudioBuffer = new float[curSamNb / 2];
            }
            for (int i = 0; i < curSamNb / 2; ++i) {
                newAudioBuffer[i] = (audioBuffer[2 * i] + audioBuffer[2 * i + 1]) / 2.0f;
            }
            audioBuffer = newAudioBuffer;
            curSamNb /= 2;
        }
        this.result.setPitch(pitchF);
        this.result.setPitched(-1.0f != pitchF);
        this.result.setProbability(-1.0f);
        return this.result;
    }
}

