/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class Goertzel
implements AudioProcessor {
    private static final double POWER_THRESHOLD = 35.0;
    private final double[] frequenciesToDetect;
    private final double[] precalculatedCosines;
    private final double[] precalculatedWnk;
    private final double[] calculatedPowers;
    private final FrequenciesDetectedHandler handler;

    public Goertzel(float audioSampleRate, int bufferSize, double[] frequencies, FrequenciesDetectedHandler handler) {
        this.frequenciesToDetect = frequencies;
        this.precalculatedCosines = new double[frequencies.length];
        this.precalculatedWnk = new double[frequencies.length];
        this.handler = handler;
        this.calculatedPowers = new double[frequencies.length];
        for (int i = 0; i < this.frequenciesToDetect.length; ++i) {
            this.precalculatedCosines[i] = 2.0 * Math.cos(Math.PI * 2 * this.frequenciesToDetect[i] / (double)audioSampleRate);
            this.precalculatedWnk[i] = Math.exp(Math.PI * -2 * this.frequenciesToDetect[i] / (double)audioSampleRate);
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioFloatBuffer = audioEvent.getFloatBuffer();
        int numberOfDetectedFrequencies = 0;
        for (int j = 0; j < this.frequenciesToDetect.length; ++j) {
            double skn2 = 0.0;
            double skn1 = 0.0;
            double skn0 = 0.0;
            for (int i = 0; i < audioFloatBuffer.length; ++i) {
                skn2 = skn1;
                skn1 = skn0;
                skn0 = this.precalculatedCosines[j] * skn1 - skn2 + (double)audioFloatBuffer[i];
            }
            double wnk = this.precalculatedWnk[j];
            this.calculatedPowers[j] = 20.0 * Math.log10(Math.abs(skn0 - wnk * skn1));
            if (!(this.calculatedPowers[j] > 35.0)) continue;
            ++numberOfDetectedFrequencies;
        }
        if (numberOfDetectedFrequencies > 0) {
            double[] frequencies = new double[numberOfDetectedFrequencies];
            double[] powers = new double[numberOfDetectedFrequencies];
            int index = 0;
            for (int j = 0; j < this.frequenciesToDetect.length; ++j) {
                if (!(this.calculatedPowers[j] > 35.0)) continue;
                frequencies[index] = this.frequenciesToDetect[j];
                powers[index] = this.calculatedPowers[j];
                ++index;
            }
            this.handler.handleDetectedFrequencies(audioEvent.getTimeStamp(), frequencies, powers, (double[])this.frequenciesToDetect.clone(), (double[])this.calculatedPowers.clone());
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static interface FrequenciesDetectedHandler {
        public void handleDetectedFrequencies(double var1, double[] var3, double[] var4, double[] var5, double[] var6);
    }
}

