/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.synthesis;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class AmplitudeLFO
implements AudioProcessor {
    private double frequency;
    private double scaleParameter;
    private double phase;

    public AmplitudeLFO() {
        this(1.5, 0.75);
    }

    public AmplitudeLFO(double frequency, double scaleParameter) {
        this.frequency = frequency;
        this.scaleParameter = scaleParameter;
        this.phase = 0.0;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] buffer = audioEvent.getFloatBuffer();
        double sampleRate = audioEvent.getSampleRate();
        double twoPiF = Math.PI * 2 * this.frequency;
        double time = 0.0;
        for (int i = 0; i < buffer.length; ++i) {
            time = (double)i / sampleRate;
            float gain = (float)(this.scaleParameter * Math.sin(twoPiF * time + this.phase));
            buffer[i] = gain * buffer[i];
        }
        this.phase = twoPiF * (double)buffer.length / sampleRate + this.phase;
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

