/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class LegendLayer
implements Layer {
    List<Color> colors;
    List<String> texts;
    CoordinateSystem cs;
    int pixelsFromRight;

    public LegendLayer(CoordinateSystem cs, int pixelsFromRight) {
        this.cs = cs;
        this.colors = new ArrayList<Color>();
        this.texts = new ArrayList<String>();
        this.pixelsFromRight = pixelsFromRight;
    }

    @Override
    public void draw(Graphics2D graphics) {
        int maxX = Math.round(this.cs.getMax(Axis.X));
        int maxY = Math.round(this.cs.getMax(Axis.Y));
        for (int i = 0; i < this.colors.size(); ++i) {
            String text = this.texts.get(i);
            Color color = this.colors.get(i);
            int textYOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 14, false));
            int textXOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, this.pixelsFromRight, true));
            LayerUtilities.drawString(graphics, text, maxX - textXOffset, maxY - textYOffset * (i + 1), false, true, Color.white, color);
        }
    }

    @Override
    public String getName() {
        return "Legend";
    }

    public void addEntry(String string, Color blue) {
        this.colors.add(blue);
        this.texts.add(string);
    }

    public void removeAllEntries() {
        this.colors.clear();
        this.texts.clear();
    }
}

