/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import be.tarsos.dsp.ui.layers.LayerUtilities;
import java.awt.Color;
import java.awt.Graphics2D;

public class VerticalFrequencyAxisLayer
implements Layer {
    CoordinateSystem cs;

    public VerticalFrequencyAxisLayer(CoordinateSystem cs) {
        this.cs = cs;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(Color.black);
        int minX = Math.round(this.cs.getMin(Axis.X));
        int maxY = Math.round(this.cs.getMax(Axis.Y));
        int wideMarkWidth = Math.round(LayerUtilities.pixelsToUnits(graphics, 8, true));
        int smallMarkWidth = Math.round(LayerUtilities.pixelsToUnits(graphics, 4, true));
        int textOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 12, true));
        int textLabelOffset = Math.round(LayerUtilities.pixelsToUnits(graphics, 12, false));
        int i = (int)this.cs.getMin(Axis.Y);
        while ((float)i < this.cs.getMax(Axis.Y)) {
            if (i % 1200 == 0) {
                graphics.drawLine(minX, i, minX + wideMarkWidth, i);
                String text = String.valueOf(i);
                LayerUtilities.drawString(graphics, text, minX + textOffset, i, false, true, null);
            } else if (i % 100 == 0) {
                graphics.drawLine(minX, i, minX + smallMarkWidth, i);
            }
            ++i;
        }
        LayerUtilities.drawString(graphics, "Frequency (cents)", minX + textOffset, maxY - textLabelOffset, false, true, Color.white);
    }

    @Override
    public String getName() {
        return "Frequency Axis";
    }
}

