/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.ui.layers;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.jvm.AudioDispatcherFactory;
import be.tarsos.dsp.ui.Axis;
import be.tarsos.dsp.ui.CoordinateSystem;
import be.tarsos.dsp.ui.layers.Layer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFormLayer
implements Layer {
    private final Color waveFormColor = Color.black;
    private final CoordinateSystem cs;
    private final File audioFile;
    private float[] samples;
    private float sampleRate;

    public WaveFormLayer(CoordinateSystem cs, File audioFile) {
        this.cs = cs;
        this.audioFile = audioFile;
        this.initialise();
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(this.waveFormColor);
        this.drawWaveForm(graphics);
    }

    private void drawWaveForm(Graphics2D graphics) {
        int waveFormXMin = (int)this.cs.getMin(Axis.X);
        int waveFormXMax = (int)this.cs.getMax(Axis.X);
        graphics.setColor(Color.GRAY);
        graphics.drawLine(waveFormXMin, 0, waveFormXMax, 0);
        graphics.setColor(Color.BLACK);
        if (this.samples != null && this.samples.length > 0) {
            int waveFormHeightInUnits = (int)this.cs.getDelta(Axis.Y);
            float lengthInMs = (float)this.samples.length / this.sampleRate * 1000.0f;
            int amountOfSamples = this.samples.length;
            float sampleCalculateFactor = (float)amountOfSamples / lengthInMs;
            int amplitudeFactor = waveFormHeightInUnits / 2;
            int step = 1;
            int i = Math.max(0, waveFormXMin);
            while ((float)i < Math.min((float)waveFormXMax, lengthInMs)) {
                int index = (int)((float)i * sampleCalculateFactor);
                if (index < this.samples.length) {
                    graphics.drawLine(i, 0, i, (int)(this.samples[index] * (float)amplitudeFactor));
                }
                i += step;
            }
        }
    }

    public void initialise() {
        try {
            AudioDispatcher adp = AudioDispatcherFactory.fromFile(this.audioFile, 52920000, 0);
            adp.setZeroPadLastBuffer(false);
            this.sampleRate = adp.getFormat().getSampleRate();
            adp.addAudioProcessor(new AudioProcessor(){

                @Override
                public void processingFinished() {
                }

                @Override
                public boolean process(AudioEvent audioEvent) {
                    float[] audioFloatBuffer = audioEvent.getFloatBuffer();
                    WaveFormLayer.access$002(WaveFormLayer.this, (float[])audioFloatBuffer.clone());
                    return true;
                }
            });
            new Thread(adp).start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "Waveform layer";
    }

    static /* synthetic */ float[] access$002(WaveFormLayer x0, float[] x1) {
        x0.samples = x1;
        return x1;
    }
}

