/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.util.fft;

import be.tarsos.dsp.util.fft.FloatFFT;
import be.tarsos.dsp.util.fft.WindowFunction;

public final class FFT {
    private final FloatFFT fft;
    private final WindowFunction windowFunction;
    private final int fftSize;
    private final float[] window;

    public FFT(int size) {
        this(size, null);
    }

    public FFT(int size, WindowFunction windowFunction) {
        this.fft = new FloatFFT(size);
        this.fftSize = size;
        this.windowFunction = windowFunction;
        this.window = (float[])(windowFunction == null ? null : windowFunction.generateCurve(size));
    }

    public void forwardTransform(float[] data2) {
        if (this.windowFunction != null) {
            for (int i = 0; i < data2.length; ++i) {
                data2[i] = data2[i] * this.window[i];
            }
        }
        this.fft.realForward(data2);
    }

    public void complexForwardTransform(float[] data2) {
        if (this.windowFunction != null) {
            for (int i = 0; i < data2.length; ++i) {
                data2[i] = data2[i] * this.window[i];
            }
        }
        this.fft.complexForward(data2);
    }

    public void backwardsTransform(float[] data2) {
        this.fft.realInverse(data2, true);
    }

    public double binToHz(int binIndex, float sampleRate) {
        return (double)((float)binIndex * sampleRate) / (double)this.fftSize;
    }

    public int size() {
        return this.fftSize;
    }

    public float modulus(float[] data2, int index) {
        int realIndex = 2 * index;
        int imgIndex = 2 * index + 1;
        float modulus = data2[realIndex] * data2[realIndex] + data2[imgIndex] * data2[imgIndex];
        return (float)Math.sqrt(modulus);
    }

    public void modulus(float[] data2, float[] amplitudes) {
        assert (data2.length / 2 == amplitudes.length);
        for (int i = 0; i < amplitudes.length; ++i) {
            amplitudes[i] = this.modulus(data2, i);
        }
    }

    public void powerPhaseFFT(float[] data2, float[] power, float[] phase) {
        assert (data2.length / 2 == power.length);
        assert (data2.length / 2 == phase.length);
        if (this.windowFunction != null) {
            this.windowFunction.apply(data2);
        }
        this.fft.realForward(data2);
        this.powerAndPhaseFromFFT(data2, power, phase);
    }

    public void powerAndPhaseFromFFT(float[] data2, float[] power, float[] phase) {
        phase[0] = (float)Math.PI;
        power[0] = -data2[0];
        for (int i = 1; i < power.length; ++i) {
            int realIndex = 2 * i;
            int imgIndex = 2 * i + 1;
            power[i] = (float)Math.sqrt(data2[realIndex] * data2[realIndex] + data2[imgIndex] * data2[imgIndex]);
            phase[i] = (float)Math.atan2(data2[imgIndex], data2[realIndex]);
        }
    }

    public void powerPhaseFFTBeatRootOnset(float[] data2, float[] power, float[] phase) {
        this.powerPhaseFFT(data2, power, phase);
        power[0] = (float)Math.sqrt(data2[0] * data2[0] + data2[1] * data2[1]);
    }

    public void multiply(float[] data2, float[] other) {
        assert (data2.length == other.length);
        if (data2.length != other.length) {
            throw new IllegalArgumentException("Both arrays with imaginary numbers shouldb e of equal length");
        }
        for (int i = 1; i < data2.length - 1; i += 2) {
            int realIndex = i;
            int imgIndex = i + 1;
            data2[realIndex] = data2[realIndex] * other[realIndex] + -1.0f * data2[imgIndex] * other[imgIndex];
            data2[imgIndex] = data2[realIndex] * other[imgIndex] + data2[imgIndex] * other[realIndex];
        }
    }
}

