/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class HaarWaveletFileWriter
implements AudioProcessor {
    private final int compression;
    private FileOutputStream rawOutputStream;

    public HaarWaveletFileWriter(String fileName, int compression) {
        this.compression = compression;
        try {
            this.rawOutputStream = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException e) {
            this.rawOutputStream = null;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] audioBuffer = audioEvent.getFloatBuffer();
        int placesWithZero = 0;
        int zeroCounter = 0;
        for (int i = 0; i < audioBuffer.length; ++i) {
            if (audioBuffer[i] != 0.0f || zeroCounter >= this.compression) continue;
            ++zeroCounter;
            placesWithZero |= 1 << i;
        }
        assert (zeroCounter == this.compression);
        byte[] byteBuffer = new byte[(audioBuffer.length - this.compression) * 2];
        zeroCounter = 0;
        int bufferIndex = 0;
        for (int i = 0; i < byteBuffer.length; ++i) {
            float value;
            if ((value = audioBuffer[bufferIndex++]) == 0.0f && zeroCounter < this.compression) {
                ++zeroCounter;
                --i;
                continue;
            }
            int x = (int)((double)value * 32767.0);
            byteBuffer[i] = (byte)x;
            byteBuffer[++i] = (byte)(x >>> 8);
        }
        try {
            this.rawOutputStream.write(byteBuffer);
            this.rawOutputStream.write((byte)placesWithZero);
            this.rawOutputStream.write((byte)(placesWithZero >>> 8));
            this.rawOutputStream.write((byte)(placesWithZero >>> 16));
            this.rawOutputStream.write((byte)(placesWithZero >>> 24));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void processingFinished() {
        try {
            this.rawOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

