/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.LiftingSchemeBaseWavelet;

public class Daubechies4Wavelet
extends LiftingSchemeBaseWavelet {
    static final float sqrt3 = (float)Math.sqrt(3.0);
    static final float sqrt2 = (float)Math.sqrt(2.0);

    protected void normalize(float[] S, int N, int direction) {
        int half = N >> 1;
        for (int n = 0; n < half; ++n) {
            if (direction == 1) {
                S[n] = (sqrt3 - 1.0f) / sqrt2 * S[n];
                S[n + half] = (sqrt3 + 1.0f) / sqrt2 * S[n + half];
                continue;
            }
            if (direction == 2) {
                S[n] = (sqrt3 + 1.0f) / sqrt2 * S[n];
                S[n + half] = (sqrt3 - 1.0f) / sqrt2 * S[n + half];
                continue;
            }
            System.out.println("Daubechies4Wavelet::normalize: bad direction value");
            break;
        }
    }

    @Override
    protected void predict(float[] S, int N, int direction) {
        int half = N >> 1;
        if (direction == 1) {
            S[half] = S[half] - sqrt3 / 4.0f * S[0] - (sqrt3 - 2.0f) / 4.0f * S[half - 1];
        } else if (direction == 2) {
            S[half] = S[half] + sqrt3 / 4.0f * S[0] + (sqrt3 - 2.0f) / 4.0f * S[half - 1];
        } else {
            System.out.println("Daubechies4Wavelet::predict: bad direction value");
        }
        for (int n = 1; n < half; ++n) {
            if (direction == 1) {
                S[half + n] = S[half + n] - sqrt3 / 4.0f * S[n] - (sqrt3 - 2.0f) / 4.0f * S[n - 1];
                continue;
            }
            if (direction != 2) break;
            S[half + n] = S[half + n] + sqrt3 / 4.0f * S[n] + (sqrt3 - 2.0f) / 4.0f * S[n - 1];
        }
    }

    protected void updateOne(float[] S, int N, int direction) {
        int half = N >> 1;
        for (int n = 0; n < half; ++n) {
            float updateVal = sqrt3 * S[half + n];
            if (direction == 1) {
                S[n] = S[n] + updateVal;
                continue;
            }
            if (direction == 2) {
                S[n] = S[n] - updateVal;
                continue;
            }
            System.out.println("Daubechies4Wavelet::updateOne: bad direction value");
            break;
        }
    }

    @Override
    protected void update(float[] S, int N, int direction) {
        int half = N >> 1;
        for (int n = 0; n < half - 1; ++n) {
            if (direction == 1) {
                S[n] = S[n] - S[half + n + 1];
                continue;
            }
            if (direction == 2) {
                S[n] = S[n] + S[half + n + 1];
                continue;
            }
            System.out.println("Daubechies4Wavelet::update: bad direction value");
            break;
        }
        if (direction == 1) {
            S[half - 1] = S[half - 1] - S[half];
        } else if (direction == 2) {
            S[half - 1] = S[half - 1] + S[half];
        }
    }

    @Override
    public void forwardTrans(float[] vec) {
        int N;
        for (int n = N = vec.length; n > 1; n >>= 1) {
            this.split(vec, n);
            this.updateOne(vec, n, 1);
            this.predict(vec, n, 1);
            this.update(vec, n, 1);
            this.normalize(vec, n, 1);
        }
    }

    @Override
    public void inverseTrans(float[] vec) {
        int N = vec.length;
        for (int n = 2; n <= N; n <<= 1) {
            this.normalize(vec, n, 2);
            this.update(vec, n, 2);
            this.predict(vec, n, 2);
            this.updateOne(vec, n, 2);
            this.merge(vec, n);
        }
    }
}

