/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

public abstract class LiftingSchemeBaseWavelet {
    protected final int forward = 1;
    protected final int inverse = 2;

    protected void split(float[] vec, int N) {
        int start = 1;
        for (int end2 = N - 1; start < end2; ++start, --end2) {
            for (int i = start; i < end2; i += 2) {
                float tmp = vec[i];
                vec[i] = vec[i + 1];
                vec[i + 1] = tmp;
            }
        }
    }

    protected void merge(float[] vec, int N) {
        int half = N >> 1;
        int start = half - 1;
        int end2 = half;
        while (start > 0) {
            for (int i = start; i < end2; i += 2) {
                float tmp = vec[i];
                vec[i] = vec[i + 1];
                vec[i + 1] = tmp;
            }
            --start;
            ++end2;
        }
    }

    protected abstract void predict(float[] var1, int var2, int var3);

    protected abstract void update(float[] var1, int var2, int var3);

    public void forwardTrans(float[] vec) {
        int N;
        for (int n = N = vec.length; n > 1; n >>= 1) {
            this.split(vec, n);
            this.predict(vec, n, 1);
            this.update(vec, n, 1);
        }
    }

    public void inverseTrans(float[] vec) {
        int N = vec.length;
        for (int n = 2; n <= N; n <<= 1) {
            this.update(vec, n, 2);
            this.predict(vec, n, 2);
            this.merge(vec, n);
        }
    }
}

