/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.Daubechies4Wavelet;
import be.tarsos.dsp.wavelet.lift.HaarWavelet;
import be.tarsos.dsp.wavelet.lift.HaarWithPolynomialInterpolationWavelet;
import be.tarsos.dsp.wavelet.lift.LineWavelet;
import be.tarsos.dsp.wavelet.lift.PolynomialWavelets;

class LiftingSchemeTest {
    LiftingSchemeTest() {
    }

    private static void print(float[] values) {
        System.out.print("[");
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double val = fArray[i];
            System.out.print(val);
            System.out.print(",");
        }
        System.out.println("]");
    }

    public static void main(String[] args) {
        float[] vals = new float[]{25.0f, 40.0f, 8.0f, 24.0f, 48.0f, 48.0f, 40.0f, 16.0f};
        HaarWavelet hr = new HaarWavelet();
        LineWavelet ln = new LineWavelet();
        Daubechies4Wavelet d = new Daubechies4Wavelet();
        HaarWithPolynomialInterpolationWavelet hrpy = new HaarWithPolynomialInterpolationWavelet();
        PolynomialWavelets py = new PolynomialWavelets();
        System.out.println("Data:");
        LiftingSchemeTest.print(vals);
        System.out.println();
        System.out.println("HaarWavelet:");
        hr.forwardTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        hr.inverseTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        System.out.println("Daubechies4Wavelet:");
        d.forwardTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        d.inverseTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        System.out.println("Line:");
        ln.forwardTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        ln.inverseTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        System.out.println("HaarWavelet, extended with polynomial interpolation:");
        hrpy.forwardTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        hrpy.inverseTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        System.out.println("Poly:");
        py.forwardTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        py.inverseTrans(vals);
        LiftingSchemeTest.print(vals);
        System.out.println();
        float[] t = new float[]{56.0f, 40.0f, 8.0f, 24.0f, 48.0f, 48.0f, 40.0f, 16.0f};
        hr.forwardTransOne(t);
        float[] signal = new float[]{56.0f, 40.0f, 8.0f, 24.0f, 48.0f, 48.0f, 40.0f, 16.0f};
        LiftingSchemeTest.dwtHaar(signal);
    }

    private static void dwtHaar(float[] signal) {
        float[] s = new float[signal.length];
        float[] d = new float[signal.length];
        for (int i = 0; i < signal.length / 2; ++i) {
            s[i] = (signal[2 * i] + signal[2 * i + 1]) / 2.0f;
            d[i] = signal[2 * i] - s[i];
        }
        LiftingSchemeTest.print(s);
        LiftingSchemeTest.print(d);
    }
}

