/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.writer;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.writer.WaveHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WriterProcessor
implements AudioProcessor {
    RandomAccessFile output;
    TarsosDSPAudioFormat audioFormat;
    private int audioLen = 0;
    private static final int HEADER_LENGTH = 44;

    public WriterProcessor(TarsosDSPAudioFormat audioFormat, RandomAccessFile output) {
        this.output = output;
        this.audioFormat = audioFormat;
        try {
            output.write(new byte[44]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        try {
            this.audioLen += audioEvent.getByteBuffer().length;
            this.output.write(audioEvent.getByteBuffer());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void processingFinished() {
        WaveHeader waveHeader = new WaveHeader(1, (short)this.audioFormat.getChannels(), (int)this.audioFormat.getSampleRate(), 16, this.audioLen);
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        try {
            waveHeader.write(header);
            this.output.seek(0L);
            this.output.write(header.toByteArray());
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

