/*
 * Decompiled with CFR 0.152.
 */
package de.malban;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.event.EventSupport;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.input.SystemController;
import de.malban.jogl.JOGLSupport;
import de.malban.sound.tinysound.TinySound;
import de.malban.util.UtilityString;
import de.malban.vide.CLI;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class VideMain {
    public static void main(String[] args) {
        int gridSize = 7;
        int stepSize = 50;
        int minCoord = -(3 * stepSize);
        int maxCoord = 3 * stepSize;
        for (int y = 0; y < gridSize; ++y) {
            for (int x = 0; x < gridSize; ++x) {
                int xCoord = minCoord + x * stepSize;
                int yCoord = maxCoord - y * stepSize;
                double radius = Math.sqrt(xCoord * xCoord + yCoord * yCoord);
                double angleRad = Math.atan2(yCoord, xCoord);
                double angleDeg = -Math.toDegrees(angleRad);
                if (angleDeg < 0.0) {
                    angleDeg += 360.0;
                }
                if (angleDeg < 0.0) {
                    angleDeg += 360.0;
                }
                if (angleDeg > 360.0) {
                    angleDeg -= 360.0;
                }
                if (angleDeg > 360.0) {
                    angleDeg -= 360.0;
                }
                double angle255 = angleDeg / 360.0;
                System.out.printf("\t db %.0f, %d, %d\t; radius, angle(512) in degree, from:  %.0f rad, ", radius, (int)(angle255 *= 512.0) / 256, (int)angle255 - 256 * ((int)angle255 / 256), angleRad);
                double xCart = radius * Math.cos(angleRad);
                double yCart = radius * Math.sin(angleRad);
                System.out.printf("y,x: %.0f, %.0f\n", yCart, xCart);
            }
            System.out.println();
        }
        String javaVersion2 = System.getProperty("java.vm.name") + " (build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")";
        String javaVersion1 = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String javaDir = "Java Home: " + System.getProperty("java.home");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        int majorVersion = 0;
        String[] v = osVersion.split(".");
        if ((v = UtilityString.cleanStringArray(v)).length > 0) {
            majorVersion = UtilityString.Int0(v[0]);
        }
        Global g = new Global();
        Configuration.getConfiguration().getDebugEntity();
        Configuration.getConfiguration().getDebugEntity().addLog("Global boot log: \n" + Global.bootString, LogPanel.INFO);
        Configuration.getConfiguration().getDebugEntity().addLog("---\n", LogPanel.INFO);
        Configuration.getConfiguration().getDebugEntity().addLog("Vide version: Version 2.6 RC3 2026 Feb 4rd", LogPanel.INFO);
        Configuration.getConfiguration().getDebugEntity().addLog("Operating system: " + osName + " Version: " + osVersion, LogPanel.INFO);
        Configuration.getConfiguration().getDebugEntity().addLog("Running on: " + javaVersion1, LogPanel.INFO);
        Configuration.getConfiguration().getDebugEntity().addLog("" + javaVersion2, LogPanel.INFO);
        Configuration.getConfiguration().getDebugEntity().addLog("" + javaDir, LogPanel.INFO);
        Configuration.getConfiguration().getDebugEntity().addLog("VIDE_HOME = " + Global.mainPathPrefix, LogPanel.INFO);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("sun.awt.noerasebackground", "true");
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        Global.initLAF();
        EventSupport.getEventSupport();
        String name = "vide.cli";
        args = VideMain.makeArgs(UtilityString.readTextFileToOneString(new File(Global.mainPathPrefix + name)));
        CLI cli = CLI.getCLI();
        boolean doExit = cli.parseArguments(args);
        if (doExit) {
            return;
        }
        cli.injectCLIConfig();
        SystemController.isJInputSupported();
        JOGLSupport.isJOGLSupported();
        TinySound.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CSAMainFrame mainFrame = new CSAMainFrame();
                mainFrame.setVisible(true);
            }
        });
    }

    public static String[] makeArgs(String s) {
        String[] relevantLines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String l : relevantLines) {
            if (l.startsWith("#")) continue;
            sb.append(l + "\n");
        }
        s = UtilityString.replaceWhiteSpaces(sb.toString(), " ");
        s = UtilityString.replace(s, "  ", " ");
        String[] ret = UtilityString.cleanStringArray(s.split(" "));
        return ret;
    }
}

