/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config;

import de.malban.Global;
import de.malban.config.ConfigChangedListener;
import de.malban.config.ConfigurationData;
import de.malban.config.ConfigurationDataPool;
import de.malban.config.LogListener;
import de.malban.config.Logable;
import de.malban.config.sound.SoundEffect;
import de.malban.config.sound.SoundMap;
import de.malban.config.sound.SoundMapPool;
import de.malban.config.theme.Theme;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.ImageCache;
import de.malban.gui.ResizeListener;
import de.malban.gui.ScaleListener;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.sound.Audio;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public final class Configuration {
    public static final int DIALOG_YES = 1;
    public static final int DIALOG_NO = 2;
    public static final int DIALOG_CANCEL = 0;
    private Theme currentTheme = null;
    private ConfigurationData mData = null;
    private static Configuration mConfiguration = null;
    private static ConfigurationDataPool mConfigurationDataPool = new ConfigurationDataPool();
    private Vector<ConfigChangedListener> mConfigListener = new Vector();
    private Vector<ScaleListener> mScaleListener = new Vector();
    private Vector<ResizeListener> mSizeListener = new Vector();
    private Vector<LogListener> mDebugListener = new Vector();
    private Vector<LogListener> mLogListener = new Vector();
    private SoundMap mSoundMap = null;
    private int mMainWidth = 1024;
    private int mMainHeight = 768;
    private int mMainWidthEvent = 1024;
    private int mMainHeightEvent = 768;
    private Logable mLogPanel = new LogPanel();
    private Logable mDebugPanel = new LogPanel();
    public boolean mIsFullscreen = false;
    private CSAMainFrame mMainFrame = null;
    boolean firstTimeSizeChanged = true;
    private static final String[] names = new String[0];
    private static final Map<String, Font> cache = new ConcurrentHashMap<String, Font>(names.length);
    static StringBuilder add;

    public Theme getCurrentTheme() {
        if (this.currentTheme == null) {
            this.currentTheme = Theme.getThemeInstance(this.getThemeName());
        }
        return this.currentTheme;
    }

    public String getThemeName() {
        String t = this.mData.mCurrentThemeName;
        if (t == null) {
            t = "default";
        }
        if (t.trim().length() == 0) {
            t = "default";
        }
        return t;
    }

    public void setThemeName(String t) {
        if (t == null) {
            t = "default";
        }
        if (t.trim().length() == 0) {
            t = "default";
        }
        this.mData.mCurrentThemeName = t;
    }

    public int getDebugLevel() {
        return this.mData.mDebugLevel;
    }

    public boolean isInit() {
        return this.mMainFrame != null;
    }

    public void setDebugOff(boolean b) {
        if (b == this.mData.mDebugOff) {
            return;
        }
        this.mData.mDebugOff = b;
        if (b) {
            this.mDebugPanel = new LogPanel();
            this.mDebugPanel.setDebugLevel(this.mData.mDebugLevel);
            this.mDebugPanel.setInterestedFiles(this.mData.mDebugFiles);
            this.mDebugPanel.setInterestedClasses(this.mData.mDebugClasses);
            this.mDebugPanel.setInterestedMethods(this.mData.mDebugMethods);
            this.mDebugPanel.setTrackTime(this.mData.mDebugTiming);
            this.mDebugPanel.setDebugFileOnly(this.mData.mDebugFileOnly);
            this.mDebugPanel.setFiletracking(!this.mData.mDisableFileLogs);
            ((LogPanel)this.mDebugPanel).setTitle("Debug Window");
        } else {
            this.mDebugPanel = new DummyLog();
        }
    }

    public void setCacheActive(boolean b) {
        this.mData.mPassAutoOnEmptyStack = b;
    }

    public boolean getCacheActive() {
        return this.mData.mPassAutoOnEmptyStack;
    }

    public boolean isSoundQuiet() {
        return this.mData.mNoSound;
    }

    public void setSoundQuiet(boolean p) {
        this.mData.mNoSound = p;
    }

    public boolean isDebugOff() {
        return this.mData.mDebugOff;
    }

    public void setDebugLevel(int d) {
        this.mData.mDebugLevel = d;
        this.mDebugPanel.setDebugLevel(d);
    }

    public void setDebugFiles(String d) {
        this.mData.mDebugFiles = d;
        this.mDebugPanel.setInterestedFiles(d);
    }

    public void setDebugClasses(String d) {
        this.mData.mDebugClasses = d;
        this.mDebugPanel.setInterestedClasses(d);
    }

    public void setDebugMethods(String d) {
        this.mData.mDebugMethods = d;
        this.mDebugPanel.setInterestedMethods(d);
    }

    public void setDebugTiming(boolean b) {
        this.mData.mDebugTiming = b;
        this.mDebugPanel.setTrackTime(b);
    }

    public String getDebugFiles() {
        return this.mData.mDebugFiles;
    }

    public String getDebugClasses() {
        return this.mData.mDebugClasses;
    }

    public String getDebugMethods() {
        return this.mData.mDebugMethods;
    }

    public boolean isDebugTiming() {
        return this.mData.mDebugTiming;
    }

    public boolean isDebugFileOnly() {
        return this.mData.mDebugFileOnly;
    }

    public boolean isDebugWindowFrameable() {
        return true;
    }

    public void setDebugFileOnly(boolean b) {
        this.mData.mDebugFileOnly = b;
        this.mDebugPanel.setDebugFileOnly(b);
    }

    public static Configuration getConfiguration() {
        if (mConfiguration == null) {
            mConfiguration = new Configuration();
        }
        return mConfiguration;
    }

    private Configuration() {
        this.mData = mConfigurationDataPool.get("Configuration");
        ((LogPanel)this.mLogPanel).setTitle("Log Window");
        if (this.mData == null) {
            this.mData = new ConfigurationData();
            this.setDebugOff(this.mData.mDebugOff);
            this.mData.mClass = "Configuration";
            this.mData.mName = "Configuration";
            this.mData.mScale = 100;
            this.mData.mCardHeight = 285;
            this.mData.mCardWidth = 200;
            this.mData.mSoundVolumne = 80;
            this.mData.mStartInFullScreen = false;
        } else {
            this.setDebugOff(this.mData.mDebugOff);
            this.mDebugPanel.setDebugLevel(this.mData.mDebugLevel);
            this.mDebugPanel.setInterestedFiles(this.mData.mDebugFiles);
            this.mDebugPanel.setInterestedClasses(this.mData.mDebugClasses);
            this.mDebugPanel.setInterestedMethods(this.mData.mDebugMethods);
            this.mDebugPanel.setTrackTime(this.mData.mDebugTiming);
            this.mDebugPanel.setFiletracking(!this.mData.mDisableFileLogs);
            this.mLogPanel.setFiletracking(!this.mData.mDisableFileLogs);
            ImageCache.cacheActive = this.getCacheActive();
        }
    }

    public void init() {
        this.mDebugPanel.setFiletracking(!this.mData.mDisableFileLogs);
        this.mLogPanel.setFiletracking(!this.mData.mDisableFileLogs);
        ImageCache.cacheActive = this.getCacheActive();
    }

    public void save() {
        mConfigurationDataPool.put(this.mData);
        mConfigurationDataPool.save();
        this.mDebugPanel.setDebugLevel(this.mData.mDebugLevel);
        this.mDebugPanel.setInterestedFiles(this.mData.mDebugFiles);
        this.mDebugPanel.setInterestedClasses(this.mData.mDebugClasses);
        this.mDebugPanel.setInterestedMethods(this.mData.mDebugMethods);
        this.mDebugPanel.setTrackTime(this.mData.mDebugTiming);
        this.mDebugPanel.setFiletracking(!this.mData.mDisableFileLogs);
        this.mLogPanel.setFiletracking(!this.mData.mDisableFileLogs);
        ImageCache.cacheActive = this.getCacheActive();
        this.fireConfigChanged();
    }

    public int getScalePercent() {
        return this.mData.mScale;
    }

    public void addScaleListerner(ScaleListener listener) {
        this.mScaleListener.removeElement(listener);
        this.mScaleListener.addElement(listener);
    }

    public void removeScaleListerner(ScaleListener listener) {
        this.mScaleListener.removeElement(listener);
    }

    public void addConfigListerner(ConfigChangedListener listener) {
        this.mConfigListener.removeElement(listener);
        this.mConfigListener.addElement(listener);
    }

    public void removeConfigListerner(ConfigChangedListener listener) {
        this.mConfigListener.removeElement(listener);
    }

    public void fireConfigChanged() {
        for (int i = 0; i < this.mConfigListener.size(); ++i) {
            this.mConfigListener.elementAt(i).configurationChanged();
        }
    }

    public void addResizeListener(ResizeListener listener) {
        this.mSizeListener.removeElement(listener);
        this.mSizeListener.addElement(listener);
    }

    public void removeResizeListener(ResizeListener listener) {
        this.mSizeListener.removeElement(listener);
    }

    public void addLogListener(LogListener listener) {
        this.mLogListener.removeElement(listener);
        this.mLogListener.addElement(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.mLogListener.removeElement(listener);
    }

    public void addDebugListener(LogListener listener) {
        this.mDebugListener.removeElement(listener);
        this.mDebugListener.addElement(listener);
    }

    public void removeDebugListener(LogListener listener) {
        this.mDebugListener.removeElement(listener);
    }

    public void fireLogAdded(String addTest) {
        for (int i = 0; i < this.mSizeListener.size(); ++i) {
            this.mLogListener.elementAt(i).logAddedChanged(addTest);
        }
    }

    public void fireDebugAdded(String addTest) {
        for (int i = 0; i < this.mSizeListener.size(); ++i) {
            this.mDebugListener.elementAt(i).logAddedChanged(addTest);
        }
    }

    public void setMainSize(int w, int h) {
        int scale;
        this.mMainWidth = w;
        this.mMainHeight = h;
        this.mData.mScale = scale = 100;
    }

    public int getMainWidth() {
        return this.mMainWidth;
    }

    public int getMainHeight() {
        return this.mMainHeight;
    }

    public void setMainFrame(CSAMainFrame frame) {
        this.mMainFrame = frame;
    }

    public CSAMainFrame getMainFrame() {
        return this.mMainFrame;
    }

    public void DisplayError(String text) {
        this.DisplayError(text, null);
    }

    public void DisplayError(String text, Throwable e) {
        this.getDebugEntity().addLog(text, 0);
        String extension = "";
        if (e != null) {
            this.getDebugEntity().addLog(e, 0);
            extension = e.toString();
        }
        if (this.mMainFrame == null) {
            return;
        }
        JOptionPane optionPane = new JOptionPane(text + "\n" + extension, 0);
        ModalInternalFrame modal = new ModalInternalFrame("Error!", this.getMainFrame().getRootPane(), (Component)this.getMainFrame(), optionPane);
        modal.setVisible(true);
    }

    public void showInfoDialog(String message, String title2) {
        if (this.mMainFrame == null) {
            return;
        }
        JOptionPane optionPane = new JOptionPane(message, 1);
        ModalInternalFrame modal = new ModalInternalFrame(title2, this.getMainFrame().getRootPane(), (Component)this.getMainFrame(), optionPane);
        modal.setVisible(true);
    }

    public int showConfirmDialog(String message, String title2) {
        if (this.mMainFrame == null) {
            return 0;
        }
        JOptionPane optionPane = new JOptionPane(message, 3, 0);
        ModalInternalFrame modal = new ModalInternalFrame(title2, this.getMainFrame().getRootPane(), (Component)this.getMainFrame(), optionPane);
        modal.setVisible(true);
        Object value = optionPane.getValue();
        if (value.equals(new Integer(0))) {
            return 1;
        }
        if (value.equals(new Integer(1))) {
            return 2;
        }
        return 0;
    }

    public int showFileChooserDialog(String message, String title2) {
        if (this.mMainFrame == null) {
            return 0;
        }
        return 0;
    }

    public int showFileDialog(String message, String title2) {
        if (this.mMainFrame == null) {
            return 0;
        }
        JOptionPane optionPane = new JOptionPane(message, 3, 0);
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        ModalInternalFrame modal = new ModalInternalFrame(title2, this.getMainFrame().getRootPane(), (Component)this.getMainFrame(), optionPane);
        modal.setVisible(true);
        Object value = optionPane.getValue();
        if (value.equals(new Integer(0))) {
            return 1;
        }
        if (value.equals(new Integer(1))) {
            return 2;
        }
        return 0;
    }

    public void fireSizeChanged(boolean forced) {
        if (this.firstTimeSizeChanged) {
            this.firstTimeSizeChanged = false;
            forced = true;
        }
        if (this.mMainWidth != this.mMainWidthEvent || this.mMainHeight != this.mMainHeightEvent || forced) {
            this.mData.mScale = 100;
            for (int i = 0; i < this.mSizeListener.size(); ++i) {
                this.mSizeListener.elementAt(i).sizeChanged();
            }
        }
        this.mMainWidthEvent = this.mMainWidth;
        this.mMainHeightEvent = this.mMainHeight;
    }

    public Logable getLogEntity() {
        return this.mLogPanel;
    }

    public static Font getFont(String name) {
        Font font;
        if (cache != null && (font = cache.get(name)) != null) {
            return font;
        }
        String fName = Global.mainPathPrefix + "fonts" + File.separator + name;
        try {
            FileInputStream is = new FileInputStream(new File(fName));
            font = Font.createFont(0, is).deriveFont(20.0f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(fName + " not loaded.  Using serif font.");
            font = new Font("serif", 0, 24);
        }
        return font;
    }

    public Font getMagicFont(int s) {
        return cache.get("MAGIC.TTF").deriveFont((float)s);
    }

    public Logable getDebugEntity() {
        return this.mDebugPanel;
    }

    public void clearLog() {
        this.mLogPanel.clearLog();
    }

    public void clearDebugLog() {
        this.mDebugPanel.clearLog();
    }

    public void resetStatic() {
        Audio.resetCaches();
        SoundEffect.resetMappings();
    }

    public void setSoundVolumne(int volumne) {
        this.mData.mSoundVolumne = volumne;
    }

    public int getSoundVolumne() {
        return this.mData.mSoundVolumne;
    }

    public void setStartInFullScrren(boolean b) {
        this.mData.mStartInFullScreen = b;
    }

    public boolean isStartInFullScrren() {
        return this.mData.mStartInFullScreen;
    }

    public void setFullScrrenResString(String res) {
        if (res == null) {
            res = "";
        }
        this.mData.mFullscreenResolution = res;
    }

    public String getFullScrrenResString() {
        if (this.mData.mFullscreenResolution == null) {
            return "";
        }
        return this.mData.mFullscreenResolution;
    }

    public boolean isFirstTime() {
        return !this.mData.mFirstTimeStarting;
    }

    public void setFirstTime(boolean f) {
        this.mData.mFirstTimeStarting = !f;
    }

    public void setTitleMusic(String t) {
        this.mData.mTitleMusik = t;
    }

    public String getTitleMusic() {
        return this.mData.mTitleMusik;
    }

    public void setFileLoggingDisabled(boolean b) {
        this.mData.mDisableFileLogs = b;
        this.mDebugPanel.setFiletracking(!this.mData.mDisableFileLogs);
        this.mLogPanel.setFiletracking(!this.mData.mDisableFileLogs);
    }

    public boolean isFileLoggingDisabled() {
        return this.mData.mDisableFileLogs;
    }

    public void setPlayTitleMusic(boolean b) {
        this.mData.mPlayMusic = b;
    }

    public boolean isPlayTitleMusic() {
        return this.mData.mPlayMusic;
    }

    public void setSoundMapName(String s) {
        this.mData.mSoundMapName = s;
        Audio.resetCaches();
        SoundEffect.resetMappings();
        this.mSoundMap = null;
    }

    public String getSoundMapName() {
        return this.mData.mSoundMapName;
    }

    public SoundMap getSoundMap() {
        if (this.mSoundMap == null) {
            SoundMapPool mSoundMapPool = new SoundMapPool();
            this.mSoundMap = mSoundMapPool.get(this.mData.mSoundMapName);
            if (this.mSoundMap == null) {
                this.mSoundMap = new SoundMap();
            }
            SoundEffect.resetMappings();
        }
        return this.mSoundMap;
    }

    public void setShowTOD(boolean b) {
        this.mData.mShowTippOfDay = b;
    }

    public boolean isShowTOD() {
        return this.mData.mShowTippOfDay;
    }

    Vector<String> getAllThemes() {
        return new Vector<String>();
    }

    public boolean isBackImageShown() {
        return false;
    }

    public static PrintStream getLogStream() {
        PrintStream p = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                add.append((char)b);
                if (b == 10) {
                    Configuration.getConfiguration().getDebugEntity().addLog(add.toString(), LogPanel.WARN);
                    add.delete(0, add.length());
                }
            }
        });
        return p;
    }

    static {
        for (String name : names) {
            cache.put(name, Configuration.getFont(name));
        }
        add = new StringBuilder();
    }

    class DummyLog
    implements Logable {
        DummyLog() {
        }

        @Override
        public void setFiletracking(boolean b) {
        }

        @Override
        public void setInterestedClasses(String c) {
        }

        @Override
        public void setInterestedMethods(String m) {
        }

        @Override
        public void setInterestedFiles(String f) {
        }

        @Override
        public void setTrackTime(boolean b) {
        }

        @Override
        public void setTrackInFile(boolean b) {
        }

        @Override
        public void setDebugLevel(int l) {
        }

        @Override
        public void setDebugFileOnly(boolean b) {
        }

        @Override
        public void setLog(String text, int level) {
        }

        @Override
        public void addLog(Throwable e, int level) {
        }

        @Override
        public void addLog(String text, int level) {
        }

        @Override
        public void setLog(String text) {
        }

        @Override
        public void addLog(Throwable e) {
        }

        @Override
        public void addLog(String text) {
        }

        @Override
        public String getLog() {
            return "";
        }

        @Override
        public boolean saveLog() {
            return false;
        }

        @Override
        public void clearLog() {
        }

        @Override
        public void addLogListener(LogListener l) {
        }

        @Override
        public void removeLogListener(LogListener l) {
        }
    }
}

