/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.sound;

import de.malban.Global;
import de.malban.config.sound.SoundMapXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class SoundMap {
    protected String mClass = "";
    public String mName = "";
    protected Vector<String> mSoundFile = new Vector();
    protected Vector<String> mColor = new Vector();
    protected Vector<String> mType = new Vector();
    protected Vector<String> mSubtype = new Vector();
    protected Vector<String> mID = new Vector();
    protected Vector<String> mEvent = new Vector();
    private static SoundMapXMLHandler XMLHANDLER = new SoundMapXMLHandler();

    public Vector<String> getSoundFile() {
        return this.mSoundFile;
    }

    public void setSoundFile(Vector<String> SoundFile) {
        this.mSoundFile = SoundFile;
    }

    public Vector<String> getColor() {
        return this.mColor;
    }

    public void setColor(Vector<String> Color2) {
        this.mColor = Color2;
    }

    public Vector<String> getType() {
        return this.mType;
    }

    public void setType(Vector<String> Type2) {
        this.mType = Type2;
    }

    public Vector<String> getSubtype() {
        return this.mSubtype;
    }

    public void setSubtype(Vector<String> Subtype) {
        this.mSubtype = Subtype;
    }

    public Vector<String> getID() {
        return this.mID;
    }

    public void setID(Vector<String> ID) {
        this.mID = ID;
    }

    public Vector<String> getEvent() {
        return this.mEvent;
    }

    public void setEvent(Vector<String> Event2) {
        this.mEvent = Event2;
    }

    private String exportXML() {
        int i;
        String s = new String();
        s = s + "\t<SoundMap>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<SOUNDFILEs>\n";
        for (i = 0; i < this.mSoundFile.size(); ++i) {
            s = s + "\t\t\t<SOUNDFILE>" + UtilityString.toXML(this.mSoundFile.elementAt(i)) + "</SOUNDFILE>\n";
        }
        s = s + "\t\t</SOUNDFILEs>\n";
        s = s + "\t\t<COLORs>\n";
        for (i = 0; i < this.mColor.size(); ++i) {
            s = s + "\t\t\t<COLOR>" + UtilityString.toXML(this.mColor.elementAt(i)) + "</COLOR>\n";
        }
        s = s + "\t\t</COLORs>\n";
        s = s + "\t\t<TYPEs>\n";
        for (i = 0; i < this.mType.size(); ++i) {
            s = s + "\t\t\t<TYPE>" + UtilityString.toXML(this.mType.elementAt(i)) + "</TYPE>\n";
        }
        s = s + "\t\t</TYPEs>\n";
        s = s + "\t\t<SUBTYPEs>\n";
        for (i = 0; i < this.mSubtype.size(); ++i) {
            s = s + "\t\t\t<SUBTYPE>" + UtilityString.toXML(this.mSubtype.elementAt(i)) + "</SUBTYPE>\n";
        }
        s = s + "\t\t</SUBTYPEs>\n";
        s = s + "\t\t<IDs>\n";
        for (i = 0; i < this.mID.size(); ++i) {
            s = s + "\t\t\t<ID>" + UtilityString.toXML(this.mID.elementAt(i)) + "</ID>\n";
        }
        s = s + "\t\t</IDs>\n";
        s = s + "\t\t<EVENTs>\n";
        for (i = 0; i < this.mEvent.size(); ++i) {
            s = s + "\t\t\t<EVENT>" + UtilityString.toXML(this.mEvent.elementAt(i)) + "</EVENT>\n";
        }
        s = s + "\t\t</EVENTs>\n";
        s = s + "\t</SoundMap>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public static SoundMapXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<SoundMap> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename);
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllSoundMap>\n");
            for (SoundMap item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllSoundMap>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, SoundMap> getHashMapFromXML(String filename) {
        HashMap<String, SoundMap> filters = new HashMap<String, SoundMap>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            SoundMapXMLHandler h = SoundMap.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "SoundMap Load Error...", 1);
        }
        return filters;
    }
}

