/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.sound;

import de.malban.config.Configuration;
import de.malban.config.sound.SoundEffect;
import de.malban.config.sound.SoundMap;
import de.malban.config.sound.SoundMapPool;
import de.malban.gui.components.CSATableModel;
import de.malban.gui.components.CSATablePanel;
import de.malban.gui.components.DoubleClickAction;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.sound.Audio;
import de.malban.util.UtilityString;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SoundMapPanel
extends JPanel {
    private SoundMap mSoundMap = new SoundMap();
    private SoundMapPool mSoundMapPool;
    private int mClassSetting = 0;
    private CSATablePanel csaPanel = null;
    private int mSelectedRow = -1;
    private int mRow = -1;
    private int mCol = -1;
    Vector<SoundEffect> mAIEffects = new Vector();
    SoundEffect mCurrentAIEffect = new SoundEffect();
    private JButton jButton10;
    private JButton jButton12;
    private JButton jButtonAddFx;
    private JButton jButtonDelete;
    private JButton jButtonDeleteFx;
    private JButton jButtonNew;
    private JButton jButtonNewFx;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox4;
    private JComboBox jComboBoxName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSound;
    private JTextField jTextFieldSound1;
    private JTextField jTextFieldSound2;

    public SoundMapPanel() {
        this.initComponents();
        this.mSoundMapPool = new SoundMapPool();
        CSATableModel t = CSATableModel.buildTableModel(this.getTableModel());
        this.csaPanel = new CSATablePanel(t);
        this.csaPanel.setXMLId("NamedFXEffectTable");
        this.csaPanel.setTableStyleSwitchingEnabled(false);
        this.csaPanel.setTablePopupEnabled(true);
        this.csaPanel.setDoubleClickAction(new DoubleClickAction(){

            @Override
            public void doIt() {
                JTable table = (JTable)this.evt.getSource();
                SoundMapPanel.this.mRow = table.convertRowIndexToModel(table.rowAtPoint(this.evt.getPoint()));
                SoundMapPanel.this.mCol = table.convertColumnIndexToModel(table.columnAtPoint(this.evt.getPoint()));
                SoundMapPanel.this.mCol = SoundMapPanel.this.csaPanel.getModel().convertEnabledColToRealCol(SoundMapPanel.this.mCol);
                SoundMapPanel.this.tableDoubleClicked();
            }
        });
        this.resetConfigPool(false);
        this.jComboBox4.removeAllItems();
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(SoundEffect.FX_EFFECT_TRIGGERS));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.csaPanel, -1, 642, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.csaPanel, -1, 159, Short.MAX_VALUE));
    }

    private void tableDoubleClicked() {
        if (this.mRow < 0) {
            return;
        }
        this.mCurrentAIEffect = SoundEffect.getEffectData(this.mSoundMap, this.mRow);
        this.setEffectData();
    }

    private void resetConfigPool(boolean select) {
        ++this.mClassSetting;
        Collection<SoundMap> colC = this.mSoundMapPool.getHashMap().values();
        Iterator<SoundMap> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        int i = 0;
        while (iterC.hasNext()) {
            SoundMap item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mSoundMap = this.mSoundMapPool.get(item.mName);
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mSoundMap = new SoundMap();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxName.setSelectedItem(this.mSoundMap.mName);
        this.jTextFieldName.setText(this.mSoundMap.mName);
        this.setEffectData();
        this.mAIEffects = SoundEffect.buildEffectVector(this.mSoundMap);
        this.mCurrentAIEffect = new SoundEffect();
        this.setEffectData();
        this.csaPanel.reInit();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mSoundMap.mName = this.jTextFieldName.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTextFieldSound = new JTextField();
        this.jButton10 = new JButton();
        this.jButton12 = new JButton();
        this.jLabel21 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBox4 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jTextFieldSound1 = new JTextField();
        this.jTextFieldSound2 = new JTextField();
        this.jButtonNewFx = new JButton();
        this.jButtonAddFx = new JButton();
        this.jButtonDeleteFx = new JButton();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel3).addGap(16, 16, 16).addComponent(this.jTextFieldName, -1, 150, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxName, 0, 150, Short.MAX_VALUE).addGap(73, 73, 73)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSaveAsNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addGap(140, 140, 140))).addGap(210, 210, 210)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxName, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonNew).addComponent(this.jButtonDelete)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 650, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 160, Short.MAX_VALUE));
        this.jTextFieldSound.setToolTipText("Image path Info");
        this.jButton10.setText("...");
        this.jButton10.setMargin(new Insets(0, 1, 0, -1));
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButton10ActionPerformed(evt);
            }
        });
        this.jButton12.setText("!");
        this.jButton12.setMargin(new Insets(0, 2, 0, 1));
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButton12ActionPerformed(evt);
            }
        });
        this.jLabel21.setText("Sound");
        this.jLabel1.setText("Color");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "W", "U", "G", "R", "B"}));
        this.jLabel2.setText("Type");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"Creature", "Instant", "Sorcery", "Land", "Enchantment", "Artifact"}));
        this.jLabel4.setText("SubType");
        this.jLabel5.setText("Event");
        this.jComboBox4.setModel(new DefaultComboBoxModel<String>(new String[]{"Card any", "Card played", "Card to grave", "Card to Library", "Player turn", "Player end", "Player add life", "Player lose life", "Game start", "Game end", " ", " "}));
        this.jLabel6.setText("ID");
        this.jTextFieldSound1.setToolTipText("Image path Info");
        this.jTextFieldSound2.setToolTipText("Image path Info");
        this.jButtonNewFx.setText("New");
        this.jButtonNewFx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButtonNewFxActionPerformed(evt);
            }
        });
        this.jButtonAddFx.setText("Add");
        this.jButtonAddFx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButtonAddFxActionPerformed(evt);
            }
        });
        this.jButtonDeleteFx.setText("Delete selected");
        this.jButtonDeleteFx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundMapPanel.this.jButtonDeleteFxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel21).addGap(22, 22, 22).addComponent(this.jTextFieldSound, -1, 280, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton12).addGap(268, 268, 268)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel1)).addGap(24, 24, 24).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBox4, GroupLayout.Alignment.LEADING, 0, 122, Short.MAX_VALUE).addComponent(this.jTextFieldSound1, -1, 122, Short.MAX_VALUE).addComponent(this.jComboBox1, 0, 122, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, 0, 174, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jButtonAddFx).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNewFx).addGap(51, 51, 51).addComponent(this.jButtonDeleteFx))).addGap(6, 6, 6).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSound2, -1, 127, Short.MAX_VALUE).addGap(79, 79, 79)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addContainerGap(629, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSound, -2, -1, -2).addComponent(this.jButton10).addComponent(this.jButton12).addComponent(this.jLabel21)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jTextFieldSound2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldSound1, -2, -1, -2)).addGap(11, 11, 11).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jComboBox4, -2, -1, -2).addComponent(this.jButtonAddFx).addComponent(this.jButtonDeleteFx).addComponent(this.jButtonNewFx)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mSoundMap = new SoundMap();
        this.clearAll();
        this.resetConfigPool(false);
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mSoundMap.mClass = "FXMap";
        this.mSoundMapPool.put(this.mSoundMap);
        this.mSoundMapPool.save();
        ++this.mClassSetting;
        this.resetConfigPool(true);
        this.jComboBoxName.setSelectedItem(this.mSoundMap.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mSoundMap = new SoundMap();
        SoundEffect.setEffectVector(this.mSoundMap, this.mAIEffects);
        this.readAllToCurrent();
        this.mSoundMap.mClass = "FXMap";
        this.mSoundMapPool.putAsNew(this.mSoundMap);
        this.mSoundMapPool.save();
        ++this.mClassSetting;
        this.resetConfigPool(true);
        this.jComboBoxName.setSelectedItem(this.mSoundMap.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mSoundMapPool.remove(this.mSoundMap);
        this.mSoundMapPool.save();
        ++this.mClassSetting;
        this.resetConfigPool(true);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSoundMap = this.mSoundMapPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mSoundMap = this.mSoundMapPool.get(key);
        this.setAllFromCurrent();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        fc.setCurrentDirectory(new File("sound"));
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String fullPath = fc.getSelectedFile().getAbsolutePath();
        this.jTextFieldSound.setText(UtilityString.makeRelative(fullPath));
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        String path = this.jTextFieldSound.getText();
        if (path.length() == 0) {
            return;
        }
        try {
            Audio.play(UtilityString.cleanFileString(path));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void jButtonAddFxActionPerformed(ActionEvent evt) {
        this.readEffectData();
        if (this.mCurrentAIEffect.mEvent.trim().length() == 0) {
            return;
        }
        SoundEffect.addEffect(this.mSoundMap, this.mCurrentAIEffect);
        this.mAIEffects = SoundEffect.buildEffectVector(this.mSoundMap);
        this.csaPanel.reInit();
    }

    private void jButtonDeleteFxActionPerformed(ActionEvent evt) {
        int[] rows = this.csaPanel.getTable().getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        Vector toDeleteIDs = new Vector();
        for (int i = rows.length - 1; i >= 0; --i) {
            int sel = this.csaPanel.convertRowIndexToModel(rows[i]);
            SoundEffect.removeEffect(this.mSoundMap, sel);
        }
        this.csaPanel.deleteSelected();
        this.mAIEffects = SoundEffect.buildEffectVector(this.mSoundMap);
        this.csaPanel.reInit();
        this.mCurrentAIEffect = new SoundEffect();
        this.setEffectData();
    }

    private void jButtonNewFxActionPerformed(ActionEvent evt) {
        this.mCurrentAIEffect = new SoundEffect();
        this.setEffectData();
    }

    private void setEffectData() {
        this.jTextFieldSound.setText(this.mCurrentAIEffect.mSoundFile);
        this.jComboBox1.setSelectedItem(this.mCurrentAIEffect.mColor);
        this.jComboBox2.setSelectedItem(this.mCurrentAIEffect.mType);
        this.jTextFieldSound2.setText(this.mCurrentAIEffect.mSubtype);
        this.jTextFieldSound1.setText(this.mCurrentAIEffect.mID);
        this.jComboBox4.setSelectedItem(this.mCurrentAIEffect.mEvent);
    }

    private void readEffectData() {
        this.mCurrentAIEffect.mSoundFile = this.jTextFieldSound.getText().trim();
        this.mCurrentAIEffect.mColor = this.jComboBox1.getSelectedIndex() == -1 ? "" : this.jComboBox1.getSelectedItem().toString().trim();
        this.mCurrentAIEffect.mType = this.jComboBox2.getSelectedIndex() == -1 ? "" : this.jComboBox2.getSelectedItem().toString().trim();
        this.mCurrentAIEffect.mSubtype = this.jTextFieldSound2.getText().trim();
        this.mCurrentAIEffect.mID = this.jTextFieldSound1.getText().trim();
        this.mCurrentAIEffect.mEvent = this.jComboBox4.getSelectedIndex() == -1 ? "" : this.jComboBox4.getSelectedItem().toString().trim();
    }

    private TableModel getTableModel() {
        AbstractTableModel model = new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                if (col == 0) {
                    return "Event";
                }
                if (col == 1) {
                    return "File";
                }
                if (col == 2) {
                    return "Color";
                }
                if (col == 3) {
                    return "Type";
                }
                if (col == 4) {
                    return "Subtype";
                }
                if (col == 5) {
                    return "ID";
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return SoundMapPanel.this.mAIEffects.size();
            }

            @Override
            public int getColumnCount() {
                return 6;
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return SoundMapPanel.this.mAIEffects.elementAt((int)row).mEvent;
                }
                if (col == 1) {
                    return SoundMapPanel.this.mAIEffects.elementAt((int)row).mSoundFile;
                }
                if (col == 2) {
                    return SoundMapPanel.this.mAIEffects.elementAt((int)row).mColor;
                }
                if (col == 3) {
                    return SoundMapPanel.this.mAIEffects.elementAt((int)row).mType;
                }
                if (col == 4) {
                    return SoundMapPanel.this.mAIEffects.elementAt((int)row).mSubtype;
                }
                if (col == 5) {
                    return SoundMapPanel.this.mAIEffects.elementAt((int)row).mID;
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public Class getColumnClass(int col) {
                return String.class;
            }
        };
        return model;
    }
}

