/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.config.Configuration;
import de.malban.config.theme.INetThemeConstants;
import de.malban.config.theme.ImageEdit;
import de.malban.config.theme.InetImageBaseData;
import de.malban.gui.components.CSAView;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.net.Proxy;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class INetPictureImportPanel
extends JPanel
implements INetThemeConstants {
    private CSAView mParent = null;
    Vector<InetImageBaseData> data = null;
    int inEvent = 0;
    int currentId = -1;
    BufferedImage currentImage = null;
    Proxy proxy = Proxy.NO_PROXY;
    private JButton jButton2;
    private JButton jButtonGet;
    private JButton jButtonGetDir;
    private JButton jButtonSave;
    private JButton jButtonShow;
    private JCheckBox jCheckBoxDoScale;
    private JCheckBox jCheckBoxbuildFromBig;
    private JCheckBox jCheckBoxbuildFromMana;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JTextField jTextFieldDir;
    private JTextField jTextFieldH;
    private JTextField jTextFieldHeight;
    private JTextField jTextFieldName;
    private JTextField jTextFieldScaleH;
    private JTextField jTextFieldScaleW;
    private JTextField jTextFieldURL;
    private JTextField jTextFieldW;
    private JTextField jTextFieldWidth;
    private JTextField jTextFieldX;
    private JTextField jTextFieldY;

    public void setProxy(Proxy p) {
        this.proxy = p;
    }

    public INetPictureImportPanel() {
        this.initComponents();
        this.jCheckBoxbuildFromMana.setVisible(false);
        this.jCheckBoxbuildFromBig.setVisible(false);
    }

    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldDir = new JTextField();
        this.jButtonShow = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldHeight = new JTextField();
        this.jTextFieldWidth = new JTextField();
        this.jButtonGetDir = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextFieldX = new JTextField();
        this.jTextFieldY = new JTextField();
        this.jTextFieldH = new JTextField();
        this.jTextFieldW = new JTextField();
        this.jButton2 = new JButton();
        this.jButtonGet = new JButton();
        this.jButtonSave = new JButton();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jTextFieldScaleW = new JTextField();
        this.jTextFieldScaleH = new JTextField();
        this.jCheckBoxDoScale = new JCheckBox();
        this.jCheckBoxbuildFromMana = new JCheckBox();
        this.jCheckBoxbuildFromBig = new JCheckBox();
        this.jLabel1.setText("URL:");
        this.jLabel1.setName("jLabel1");
        this.jTextFieldURL.setName("jTextFieldURL");
        this.jLabel2.setText("Save as:");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText("Save to:");
        this.jLabel3.setName("jLabel3");
        this.jTextFieldName.setName("jTextFieldName");
        this.jTextFieldDir.setName("jTextFieldDir");
        this.jButtonShow.setText("Show");
        this.jButtonShow.setName("jButtonShow");
        this.jButtonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                INetPictureImportPanel.this.jButtonShowActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Height:");
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText("Width:");
        this.jLabel5.setName("jLabel5");
        this.jTextFieldHeight.setEnabled(false);
        this.jTextFieldHeight.setName("jTextFieldHeight");
        this.jTextFieldWidth.setEnabled(false);
        this.jTextFieldWidth.setName("jTextFieldWidth");
        this.jButtonGetDir.setText("...");
        this.jButtonGetDir.setName("jButtonGetDir");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setName("jPanel1");
        this.jLabel7.setName("jLabel7");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -1, 212, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -1, 160, Short.MAX_VALUE));
        this.jLabel6.setText("Preview:");
        this.jLabel6.setName("jLabel6");
        this.jLabel8.setText("start X:");
        this.jLabel8.setName("jLabel8");
        this.jLabel9.setText("start Y:");
        this.jLabel9.setName("jLabel9");
        this.jLabel10.setText("height:");
        this.jLabel10.setName("jLabel10");
        this.jLabel11.setText("width:");
        this.jLabel11.setName("jLabel11");
        this.jTextFieldX.setName("jTextFieldX");
        this.jTextFieldX.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                INetPictureImportPanel.this.jTextFieldXFocusLost(evt);
            }
        });
        this.jTextFieldY.setName("jTextFieldY");
        this.jTextFieldY.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                INetPictureImportPanel.this.jTextFieldYFocusLost(evt);
            }
        });
        this.jTextFieldH.setName("jTextFieldH");
        this.jTextFieldH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                INetPictureImportPanel.this.jTextFieldHFocusLost(evt);
            }
        });
        this.jTextFieldW.setName("jTextFieldW");
        this.jTextFieldW.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                INetPictureImportPanel.this.jTextFieldWFocusLost(evt);
            }
        });
        this.jButton2.setText("Manual edit");
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                INetPictureImportPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButtonGet.setText("Get");
        this.jButtonGet.setName("jButtonGet");
        this.jButtonGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                INetPictureImportPanel.this.jButtonGetActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setName("jButtonSave");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                INetPictureImportPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jLabel12.setText("scale width:");
        this.jLabel12.setName("jLabel12");
        this.jLabel13.setText("scale height:");
        this.jLabel13.setName("jLabel13");
        this.jTextFieldScaleW.setName("jTextFieldScaleW");
        this.jTextFieldScaleW.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                INetPictureImportPanel.this.jTextFieldScaleWFocusLost(evt);
            }
        });
        this.jTextFieldScaleH.setName("jTextFieldScaleH");
        this.jTextFieldScaleH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                INetPictureImportPanel.this.jTextFieldScaleHFocusLost(evt);
            }
        });
        this.jCheckBoxDoScale.setText("scale it:");
        this.jCheckBoxDoScale.setHorizontalTextPosition(10);
        this.jCheckBoxDoScale.setName("jCheckBoxDoScale");
        this.jCheckBoxDoScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                INetPictureImportPanel.this.jCheckBoxDoScaleActionPerformed(evt);
            }
        });
        this.jCheckBoxbuildFromMana.setText("build from mana");
        this.jCheckBoxbuildFromMana.setName("jCheckBoxbuildFromMana");
        this.jCheckBoxbuildFromMana.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                INetPictureImportPanel.this.jCheckBoxbuildFromManaActionPerformed(evt);
            }
        });
        this.jCheckBoxbuildFromBig.setText("build from big version");
        this.jCheckBoxbuildFromBig.setName("jCheckBoxbuildFromBig");
        this.jCheckBoxbuildFromBig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                INetPictureImportPanel.this.jCheckBoxbuildFromBigActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldName, -2, 132, -2).addGap(261, 261, 261)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldDir, GroupLayout.Alignment.LEADING, -1, 341, Short.MAX_VALUE).addComponent(this.jTextFieldURL, -1, 341, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonGet).addGroup(layout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.jButtonGetDir))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonShow).addComponent(this.jButtonSave))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldHeight, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldWidth, GroupLayout.Alignment.LEADING, -2, 52, -2)))).addComponent(this.jLabel6).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel11).addComponent(this.jLabel9).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldX, -1, 46, Short.MAX_VALUE).addComponent(this.jTextFieldY).addComponent(this.jTextFieldH).addComponent(this.jTextFieldW)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxbuildFromMana).addComponent(this.jCheckBoxbuildFromBig)).addGap(22, 22, 22)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jCheckBoxDoScale).addGap(46, 46, 46)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel12).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldScaleH, -2, 41, -2).addComponent(this.jTextFieldScaleW, -2, 41, -2)).addGap(22, 22, 22)))).addComponent(this.jButton2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldURL, -2, -1, -2).addComponent(this.jButtonShow).addComponent(this.jButtonGet)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldWidth, -2, -1, -2)).addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldDir, -2, -1, -2).addComponent(this.jButtonGetDir).addComponent(this.jButtonSave)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextFieldX, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jTextFieldScaleW, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextFieldY, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.jTextFieldScaleH, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jTextFieldH, -2, -1, -2).addComponent(this.jCheckBoxDoScale)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextFieldW, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jCheckBoxbuildFromMana)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxbuildFromBig))).addContainerGap(22, Short.MAX_VALUE)));
    }

    public void hideSave() {
        this.jLabel3.setVisible(false);
        this.jTextFieldDir.setVisible(false);
        this.jButtonGetDir.setVisible(false);
        this.jButtonSave.setVisible(false);
    }

    private void jButtonGetActionPerformed(ActionEvent evt) {
        ++this.inEvent;
        String urlS = this.jTextFieldURL.getText();
        if (urlS.length() == 0) {
            if (this.jCheckBoxbuildFromMana.isSelected()) {
                this.doCurrentCropPreview();
            }
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new URL(urlS).openConnection(this.proxy).getInputStream());
            this.currentImage = ImageIO.read(in);
            double scale = 1.325;
            while (this.currentImage.getHeight(null) == -1) {
            }
            int height = this.currentImage.getHeight(null);
            int width = this.currentImage.getWidth(null);
            double scaleLoaded = (double)width / (double)height;
            double percent = 212.0 / (double)width;
            if (scaleLoaded <= scale) {
                percent = 160.0 / (double)height;
            }
            this.jTextFieldHeight.setText("" + height);
            this.jTextFieldWidth.setText("" + width);
            if (UtilityString.Int0(this.jTextFieldH.getText()) == 0) {
                this.jTextFieldH.setText("" + height);
                this.jTextFieldW.setText("" + width);
                this.jTextFieldX.setText("0");
                this.jTextFieldY.setText("0");
            }
            BufferedImage scaled = UtilityImage.imageScale(this.currentImage, (int)(percent * 100.0));
            ImageIcon i = new ImageIcon(scaled);
            this.jLabel7.setIcon(i);
            in.close();
        }
        catch (Exception e) {
            this.currentImage = null;
            Configuration.getConfiguration().getDebugEntity().addLog(e, LogPanel.ERROR);
        }
        --this.inEvent;
        this.doCurrentCropPreview();
    }

    private void jButtonShowActionPerformed(ActionEvent evt) {
        if (this.currentImage == null) {
            return;
        }
        ImageIcon i = new ImageIcon(this.currentImage);
        JLabel label = new JLabel(i);
        final ModalInternalFrame f = new ModalInternalFrame("Picture", Configuration.getConfiguration().getMainFrame().getRootPane(), (Component)Configuration.getConfiguration().getMainFrame(), label);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    f.setClosed(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        f.setClosable(true);
        f.setVisible(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.currentImage == null) {
            return;
        }
        String name = this.jTextFieldName.getText();
        if (name.length() == 0) {
            return;
        }
        BufferedImage bimageCropped2 = this.getCurrentCalculatedImage();
        if (bimageCropped2 == null) {
            return;
        }
        String dir = this.jTextFieldDir.getText();
        if (dir.length() != 0) {
            dir = dir + File.separator;
        }
        String imagePath = dir + name;
        if (name.toUpperCase().indexOf(".PNG") == -1) {
            imagePath = imagePath + ".png";
        }
        File f = new File(imagePath);
        try {
            ImageIO.write((RenderedImage)bimageCropped2, "png", f);
        }
        catch (Exception e) {
            Configuration.getConfiguration().getDebugEntity().addLog(e, LogPanel.ERROR);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.currentImage == null) {
            return;
        }
        ImageEdit panel = new ImageEdit();
        panel.setImage(this.currentImage);
        this.mParent.showPanelModal(panel, "Manual image selection", 1000, 750);
        this.jTextFieldX.setText("" + panel.getImageX());
        this.jTextFieldY.setText("" + panel.getImageY());
        this.jTextFieldW.setText("" + panel.getImageWidth());
        this.jTextFieldH.setText("" + panel.getImageHeight());
        this.doCurrentCropPreview();
    }

    private void jTextFieldXFocusLost(FocusEvent evt) {
        this.doCurrentCropPreview();
    }

    private void jTextFieldYFocusLost(FocusEvent evt) {
        this.doCurrentCropPreview();
    }

    private void jTextFieldHFocusLost(FocusEvent evt) {
        this.doCurrentCropPreview();
    }

    private void jTextFieldWFocusLost(FocusEvent evt) {
        this.doCurrentCropPreview();
    }

    private void jCheckBoxDoScaleActionPerformed(ActionEvent evt) {
        if (this.inEvent != 0) {
            return;
        }
        this.doCurrentCropPreview();
    }

    private void jTextFieldScaleWFocusLost(FocusEvent evt) {
        if (this.jCheckBoxDoScale.isSelected()) {
            this.doCurrentCropPreview();
        }
    }

    private void jTextFieldScaleHFocusLost(FocusEvent evt) {
        if (this.jCheckBoxDoScale.isSelected()) {
            this.doCurrentCropPreview();
        }
    }

    private void jCheckBoxbuildFromManaActionPerformed(ActionEvent evt) {
        if (this.inEvent > 0) {
            return;
        }
        if (this.jCheckBoxbuildFromMana.isSelected()) {
            this.jTextFieldURL.setText("");
            this.doCurrentCropPreview();
        }
    }

    private void jCheckBoxbuildFromBigActionPerformed(ActionEvent evt) {
        if (this.inEvent > 0) {
            return;
        }
        if (this.jCheckBoxbuildFromBig.isSelected()) {
            this.jTextFieldURL.setText("");
            this.doCurrentCropPreview();
        }
    }

    public void writeData(InetImageBaseData iData, Vector<InetImageBaseData> allData) {
        ++this.inEvent;
        this.data = allData;
        this.currentId = iData.id;
        this.jTextFieldURL.setText(iData.url);
        this.jTextFieldName.setEnabled(iData.id == 0);
        if (iData.id == 4) {
            this.jCheckBoxbuildFromMana.setVisible(true);
        } else {
            this.jCheckBoxbuildFromMana.setVisible(false);
        }
        if (iData.id == 22 || iData.id == 11 || iData.id == 10 || iData.id == 13 || iData.id == 12 || iData.id == 14 || iData.id == 17) {
            this.jCheckBoxbuildFromBig.setVisible(true);
        } else {
            this.jCheckBoxbuildFromBig.setVisible(false);
        }
        this.jTextFieldName.setText(iData.saveName);
        this.jTextFieldX.setText("" + iData.x);
        this.jTextFieldY.setText("" + iData.y);
        this.jTextFieldW.setText("" + iData.w);
        this.jTextFieldH.setText("" + iData.h);
        this.jTextFieldScaleW.setText("" + iData.scaleW);
        this.jTextFieldScaleH.setText("" + iData.scaleH);
        this.jCheckBoxDoScale.setSelected(iData.doScale);
        this.jTextFieldScaleW.setEnabled(true);
        this.jTextFieldScaleH.setEnabled(true);
        this.jCheckBoxDoScale.setEnabled(true);
        this.jCheckBoxbuildFromMana.setSelected(iData.fromMana);
        this.jCheckBoxbuildFromBig.setSelected(iData.fromBig);
        --this.inEvent;
    }

    public void readData(InetImageBaseData data2) {
        data2.url = this.jTextFieldURL.getText();
        data2.saveName = this.jTextFieldName.getText();
        data2.x = UtilityString.Int0(this.jTextFieldX.getText());
        data2.y = UtilityString.Int0(this.jTextFieldY.getText());
        data2.w = UtilityString.Int0(this.jTextFieldW.getText());
        data2.h = UtilityString.Int0(this.jTextFieldH.getText());
        data2.scaleW = UtilityString.Int0(this.jTextFieldScaleW.getText());
        data2.scaleH = UtilityString.Int0(this.jTextFieldScaleH.getText());
        data2.doScale = this.jCheckBoxDoScale.isSelected();
        data2.fromMana = this.jCheckBoxbuildFromMana.isSelected();
        data2.fromBig = this.jCheckBoxbuildFromBig.isSelected();
    }

    public void clearAll() {
        this.jTextFieldURL.setText("");
        this.jTextFieldName.setEnabled(false);
        this.jTextFieldName.setText("");
        this.jTextFieldX.setText("");
        this.jTextFieldY.setText("");
        this.jTextFieldW.setText("");
        this.jTextFieldH.setText("");
        this.jTextFieldScaleW.setText("");
        this.jTextFieldScaleH.setText("");
        this.jCheckBoxDoScale.setSelected(false);
        this.jCheckBoxbuildFromMana.setSelected(false);
    }

    public boolean importImage(InetImageBaseData idata, String name, Vector<InetImageBaseData> allData) {
        boolean ret = true;
        String directoryPath = "theme" + File.separator + name;
        this.writeData(idata, allData);
        this.jTextFieldDir.setText(directoryPath);
        this.jButtonGetActionPerformed(null);
        this.jButtonSaveActionPerformed(null);
        return ret;
    }

    public void setScale(boolean scale, int height, int width) {
        ++this.inEvent;
        this.jTextFieldScaleW.setText("" + width);
        this.jTextFieldScaleH.setText("" + height);
        this.jCheckBoxDoScale.setSelected(scale);
        this.jTextFieldScaleW.setEnabled(false);
        this.jTextFieldScaleH.setEnabled(false);
        this.jCheckBoxDoScale.setEnabled(false);
        this.doCurrentCropPreview();
        --this.inEvent;
    }

    void doCurrentCropPreview() {
        if (this.currentImage == null && !this.jCheckBoxbuildFromMana.isSelected() && !this.jCheckBoxbuildFromBig.isSelected()) {
            return;
        }
        BufferedImage bimageCropped2 = this.getCurrentCalculatedImage();
        if (bimageCropped2 == null) {
            return;
        }
        double scale = 1.325;
        int height = bimageCropped2.getHeight(null);
        int width = bimageCropped2.getWidth(null);
        double scaleLoaded = (double)height / (double)width;
        double percent = 212.0 / (double)width;
        if (scaleLoaded <= scale) {
            percent = 160.0 / (double)height;
        }
        BufferedImage scaled = UtilityImage.imageScale(bimageCropped2, (int)(percent * 100.0));
        ImageIcon i = new ImageIcon(scaled);
        this.jLabel7.setIcon(i);
    }

    InetImageBaseData getDataForId(int id) {
        InetImageBaseData ret = null;
        for (int i = 0; i < this.data.size(); ++i) {
            InetImageBaseData c = this.data.elementAt(i);
            if (id != c.id) continue;
            ret = c;
            break;
        }
        return ret;
    }

    private static void copySrcIntoDstAt(BufferedImage src, BufferedImage dst, int dx, int dy) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int width = src.getWidth();
        int height = src.getHeight();
        int dstoffs = dx + dy * dst.getWidth();
        int srcoffs = 0;
        int y = 0;
        while (y < height) {
            System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
            ++y;
            dstoffs += dst.getWidth();
            srcoffs += width;
        }
    }

    BufferedImage getCurrentCalculatedImage() {
        BufferedImage ret = null;
        if (this.jCheckBoxbuildFromMana.isSelected()) {
            if (this.data == null) {
                return ret;
            }
            INetPictureImportPanel helper = new INetPictureImportPanel();
            InetImageBaseData black = this.getDataForId(6);
            if (black == null) {
                return ret;
            }
            InetImageBaseData blue = this.getDataForId(9);
            if (blue == null) {
                return ret;
            }
            InetImageBaseData white = this.getDataForId(5);
            if (white == null) {
                return ret;
            }
            InetImageBaseData red = this.getDataForId(7);
            if (red == null) {
                return ret;
            }
            InetImageBaseData green = this.getDataForId(8);
            if (green == null) {
                return ret;
            }
            helper.writeData(white, this.data);
            helper.jButtonGetActionPerformed(null);
            BufferedImage whiteImagePre = helper.getCurrentCalculatedImage();
            helper.writeData(black, this.data);
            helper.jButtonGetActionPerformed(null);
            BufferedImage blackImagePre = helper.getCurrentCalculatedImage();
            helper.writeData(red, this.data);
            helper.jButtonGetActionPerformed(null);
            BufferedImage redImagePre = helper.getCurrentCalculatedImage();
            helper.writeData(green, this.data);
            helper.jButtonGetActionPerformed(null);
            BufferedImage greenImagePre = helper.getCurrentCalculatedImage();
            helper.writeData(blue, this.data);
            helper.jButtonGetActionPerformed(null);
            BufferedImage blueImagePre = helper.getCurrentCalculatedImage();
            BufferedImage whiteImage = UtilityImage.toBufferedImage(UtilityImage.imageScale(whiteImagePre, 27, 27));
            BufferedImage blackImage = UtilityImage.toBufferedImage(UtilityImage.imageScale(blackImagePre, 27, 27));
            BufferedImage redImage = UtilityImage.toBufferedImage(UtilityImage.imageScale(redImagePre, 27, 27));
            BufferedImage greenImage = UtilityImage.toBufferedImage(UtilityImage.imageScale(greenImagePre, 27, 27));
            BufferedImage blueImage = UtilityImage.toBufferedImage(UtilityImage.imageScale(blueImagePre, 27, 27));
            BufferedImage i = new BufferedImage(100, 100, whiteImage.getType());
            Graphics2D g2d = i.createGraphics();
            Color transparent = new Color(0, 0, 0, 0);
            g2d.setColor(transparent);
            g2d.setComposite(AlphaComposite.Src);
            g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f));
            g2d.dispose();
            INetPictureImportPanel.copySrcIntoDstAt(blueImage, i, 18, 5);
            INetPictureImportPanel.copySrcIntoDstAt(blackImage, i, 58, 5);
            INetPictureImportPanel.copySrcIntoDstAt(whiteImage, i, 8, 42);
            INetPictureImportPanel.copySrcIntoDstAt(greenImage, i, 68, 43);
            INetPictureImportPanel.copySrcIntoDstAt(redImage, i, 36, 64);
            ret = i;
        } else if (this.jCheckBoxbuildFromBig.isSelected()) {
            int sourceId = -1;
            if (this.currentId == 22) {
                sourceId = 4;
            }
            if (this.currentId == 11) {
                sourceId = 6;
            }
            if (this.currentId == 10) {
                sourceId = 5;
            }
            if (this.currentId == 13) {
                sourceId = 8;
            }
            if (this.currentId == 12) {
                sourceId = 7;
            }
            if (this.currentId == 14) {
                sourceId = 9;
            }
            if (this.currentId == 17) {
                sourceId = 16;
            }
            if (sourceId == -1) {
                return null;
            }
            INetPictureImportPanel helper = new INetPictureImportPanel();
            InetImageBaseData source = this.getDataForId(sourceId);
            if (source == null) {
                return ret;
            }
            helper.writeData(source, this.data);
            helper.jButtonGetActionPerformed(null);
            BufferedImage sourceImagePre = helper.getCurrentCalculatedImage();
            ret = UtilityImage.toBufferedImage(UtilityImage.imageScale(sourceImagePre, 16, 16));
        } else {
            BufferedImage bimageCropped;
            if (this.currentImage == null) {
                return ret;
            }
            int x = UtilityString.IntX(this.jTextFieldX.getText(), 0);
            int y = UtilityString.IntX(this.jTextFieldY.getText(), 0);
            int w = UtilityString.IntX(this.jTextFieldW.getText(), this.currentImage.getWidth(null));
            int h = UtilityString.IntX(this.jTextFieldH.getText(), this.currentImage.getHeight(null));
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x > this.currentImage.getWidth(null)) {
                x = this.currentImage.getWidth(null);
            }
            if (y > this.currentImage.getHeight(null)) {
                y = this.currentImage.getHeight(null);
            }
            if (x + w > this.currentImage.getWidth(null)) {
                w = this.currentImage.getWidth(null) - x;
            }
            if (y + h > this.currentImage.getHeight(null)) {
                h = this.currentImage.getHeight(null) - y;
            }
            if (w == 0) {
                return null;
            }
            if (h == 0) {
                return null;
            }
            BufferedImage bimage = UtilityImage.toBufferedImage(this.currentImage);
            ret = bimageCropped = bimage.getSubimage(x, y, w, h);
            if (this.jCheckBoxDoScale.isSelected()) {
                int sw = UtilityString.IntX(this.jTextFieldScaleW.getText(), 0);
                int sh = UtilityString.IntX(this.jTextFieldScaleH.getText(), 0);
                if (sw != 0 && sh != 0) {
                    ret = UtilityImage.toBufferedImage(UtilityImage.imageScale(bimageCropped, sw, sh));
                }
            }
        }
        return ret;
    }
}

