/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.Global;
import de.malban.config.theme.InetThemeDataXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class InetThemeData {
    protected String mClass = "";
    public String mName = "";
    protected Vector<String> mThemeID = new Vector();
    protected Vector<String> mImageUrl = new Vector();
    protected boolean mThemeResizeBackImage = false;
    protected Vector<String> mSaveImageName = new Vector();
    protected Vector<Integer> mStartX = new Vector();
    protected Vector<Integer> mStartY = new Vector();
    protected Vector<Integer> mHeight = new Vector();
    protected Vector<Integer> mWidth = new Vector();
    protected Vector<Integer> mScaleWidth = new Vector();
    protected Vector<Integer> mScaleHeight = new Vector();
    protected Vector<Boolean> mDoScale = new Vector();
    protected boolean mThemeResizeTitleImage = false;
    protected String mGameBackgroundImageName = "";
    protected Vector<Boolean> mBuildFromMana = new Vector();
    protected Vector<Boolean> mBuildFromBig = new Vector();
    private static InetThemeDataXMLHandler XMLHANDLER = new InetThemeDataXMLHandler();

    public Vector<String> getThemeID() {
        return this.mThemeID;
    }

    public void setThemeID(Vector<String> ThemeID) {
        this.mThemeID = ThemeID;
    }

    public Vector<String> getImageUrl() {
        return this.mImageUrl;
    }

    public void setImageUrl(Vector<String> ImageUrl) {
        this.mImageUrl = ImageUrl;
    }

    public boolean getThemeResizeBackImage() {
        return this.mThemeResizeBackImage;
    }

    public void setThemeResizeBackImage(boolean ThemeResizeBackImage) {
        this.mThemeResizeBackImage = ThemeResizeBackImage;
    }

    public Vector<String> getSaveImageName() {
        return this.mSaveImageName;
    }

    public void setSaveImageName(Vector<String> SaveImageName) {
        this.mSaveImageName = SaveImageName;
    }

    public Vector<Integer> getStartX() {
        return this.mStartX;
    }

    public void setStartX(Vector<Integer> StartX) {
        this.mStartX = StartX;
    }

    public Vector<Integer> getStartY() {
        return this.mStartY;
    }

    public void setStartY(Vector<Integer> StartY) {
        this.mStartY = StartY;
    }

    public Vector<Integer> getHeight() {
        return this.mHeight;
    }

    public void setHeight(Vector<Integer> Height) {
        this.mHeight = Height;
    }

    public Vector<Integer> getWidth() {
        return this.mWidth;
    }

    public void setWidth(Vector<Integer> Width) {
        this.mWidth = Width;
    }

    public Vector<Integer> getScaleWidth() {
        return this.mScaleWidth;
    }

    public void setScaleWidth(Vector<Integer> ScaleWidth) {
        this.mScaleWidth = ScaleWidth;
    }

    public Vector<Integer> getScaleHeight() {
        return this.mScaleHeight;
    }

    public void setScaleHeight(Vector<Integer> ScaleHeight) {
        this.mScaleHeight = ScaleHeight;
    }

    public Vector<Boolean> getDoScale() {
        return this.mDoScale;
    }

    public void setDoScale(Vector<Boolean> DoScale) {
        this.mDoScale = DoScale;
    }

    public boolean getThemeResizeTitleImage() {
        return this.mThemeResizeTitleImage;
    }

    public void setThemeResizeTitleImage(boolean ThemeResizeTitleImage) {
        this.mThemeResizeTitleImage = ThemeResizeTitleImage;
    }

    public String getGameBackgroundImageName() {
        return this.mGameBackgroundImageName;
    }

    public void setGameBackgroundImageName(String GameBackgroundImageName) {
        this.mGameBackgroundImageName = GameBackgroundImageName;
    }

    public Vector<Boolean> getBuildFromMana() {
        return this.mBuildFromMana;
    }

    public void setBuildFromMana(Vector<Boolean> BuildFromMana) {
        this.mBuildFromMana = BuildFromMana;
    }

    public Vector<Boolean> getBuildFromBig() {
        return this.mBuildFromBig;
    }

    public void setBuildFromBig(Vector<Boolean> BuildFromBig) {
        this.mBuildFromBig = BuildFromBig;
    }

    private String exportXML() {
        int i;
        String s = new String();
        s = s + "\t<InetThemeData>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<ThemeIDs>\n";
        for (i = 0; i < this.mThemeID.size(); ++i) {
            s = s + "\t\t\t<ThemeID>" + UtilityString.toXML(this.mThemeID.elementAt(i)) + "</ThemeID>\n";
        }
        s = s + "\t\t</ThemeIDs>\n";
        s = s + "\t\t<ImageUrls>\n";
        for (i = 0; i < this.mImageUrl.size(); ++i) {
            s = s + "\t\t\t<ImageUrl>" + UtilityString.toXML(this.mImageUrl.elementAt(i)) + "</ImageUrl>\n";
        }
        s = s + "\t\t</ImageUrls>\n";
        s = s + "\t\t<ThemeResizeBackImage>" + this.mThemeResizeBackImage + "</ThemeResizeBackImage>\n";
        s = s + "\t\t<SaveImageNames>\n";
        for (i = 0; i < this.mSaveImageName.size(); ++i) {
            s = s + "\t\t\t<SaveImageName>" + UtilityString.toXML(this.mSaveImageName.elementAt(i)) + "</SaveImageName>\n";
        }
        s = s + "\t\t</SaveImageNames>\n";
        s = s + "\t\t<StartXs>\n";
        for (i = 0; i < this.mStartX.size(); ++i) {
            s = s + "\t\t\t<StartX>" + this.mStartX.elementAt(i) + "</StartX>\n";
        }
        s = s + "\t\t</StartXs>\n";
        s = s + "\t\t<StartYs>\n";
        for (i = 0; i < this.mStartY.size(); ++i) {
            s = s + "\t\t\t<StartY>" + this.mStartY.elementAt(i) + "</StartY>\n";
        }
        s = s + "\t\t</StartYs>\n";
        s = s + "\t\t<Heights>\n";
        for (i = 0; i < this.mHeight.size(); ++i) {
            s = s + "\t\t\t<Height>" + this.mHeight.elementAt(i) + "</Height>\n";
        }
        s = s + "\t\t</Heights>\n";
        s = s + "\t\t<Widths>\n";
        for (i = 0; i < this.mWidth.size(); ++i) {
            s = s + "\t\t\t<Width>" + this.mWidth.elementAt(i) + "</Width>\n";
        }
        s = s + "\t\t</Widths>\n";
        s = s + "\t\t<ScaleWidths>\n";
        for (i = 0; i < this.mScaleWidth.size(); ++i) {
            s = s + "\t\t\t<ScaleWidth>" + this.mScaleWidth.elementAt(i) + "</ScaleWidth>\n";
        }
        s = s + "\t\t</ScaleWidths>\n";
        s = s + "\t\t<ScaleHeights>\n";
        for (i = 0; i < this.mScaleHeight.size(); ++i) {
            s = s + "\t\t\t<ScaleHeight>" + this.mScaleHeight.elementAt(i) + "</ScaleHeight>\n";
        }
        s = s + "\t\t</ScaleHeights>\n";
        s = s + "\t\t<DoScales>\n";
        for (i = 0; i < this.mDoScale.size(); ++i) {
            s = s + "\t\t\t<DoScale>" + this.mDoScale.elementAt(i) + "</DoScale>\n";
        }
        s = s + "\t\t</DoScales>\n";
        s = s + "\t\t<ThemeResizeTitleImage>" + this.mThemeResizeTitleImage + "</ThemeResizeTitleImage>\n";
        s = s + "\t\t<GameBackgroundImageName>" + UtilityString.toXML(this.mGameBackgroundImageName) + "</GameBackgroundImageName>\n";
        s = s + "\t\t<BuildFromManas>\n";
        for (i = 0; i < this.mBuildFromMana.size(); ++i) {
            s = s + "\t\t\t<BuildFromMana>" + this.mBuildFromMana.elementAt(i) + "</BuildFromMana>\n";
        }
        s = s + "\t\t</BuildFromManas>\n";
        s = s + "\t\t<BuildFromBigs>\n";
        for (i = 0; i < this.mBuildFromBig.size(); ++i) {
            s = s + "\t\t\t<BuildFromBig>" + this.mBuildFromBig.elementAt(i) + "</BuildFromBig>\n";
        }
        s = s + "\t\t</BuildFromBigs>\n";
        s = s + "\t</InetThemeData>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public static InetThemeDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<InetThemeData> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllInetThemeData>\n");
            for (InetThemeData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllInetThemeData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, InetThemeData> getHashMapFromXML(String filename) {
        HashMap<String, InetThemeData> filters = new HashMap<String, InetThemeData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            InetThemeDataXMLHandler h = InetThemeData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "InetThemeData Load Error...", 1);
        }
        return filters;
    }
}

