/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.Global;
import de.malban.config.theme.ThemeData;
import de.malban.config.theme.ThemeDataPool;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Theme {
    public static final String THEME_BASE_PATH = Global.mainPathPrefix + "theme" + File.separator;
    String themeDir = THEME_BASE_PATH + "default";
    boolean isDefault = true;
    String mName = "default";
    ThemeData data = null;
    public static HashMap<String, Theme> allThemes = null;

    public static void resetAllData() {
        Set<Map.Entry<String, Theme>> entries = allThemes.entrySet();
        for (Map.Entry<String, Theme> entry : entries) {
            Theme value = entry.getValue();
            value.data = null;
        }
    }

    private Theme(String name) {
        if (!name.equals("default")) {
            this.isDefault = false;
        }
        this.themeDir = THEME_BASE_PATH + name;
        this.mName = name;
    }

    private Theme() {
    }

    public ThemeData getData() {
        if (this.data == null) {
            ThemeDataPool mThemeDataPool = new ThemeDataPool(".." + File.separator + "theme" + File.separator + this.mName + File.separator + "Theme.xml");
            Collection<ThemeData> colC = mThemeDataPool.getMapForKlasse("Themes").values();
            for (ThemeData item : colC) {
                if (!item.mName.equals(this.mName)) continue;
                this.data = mThemeDataPool.get(item.mName);
            }
            if (this.data == null) {
                this.data = new ThemeData();
            }
        }
        return this.data;
    }

    public static Theme getThemeInstance(String name) {
        Theme t = allThemes.get(name);
        if (t == null) {
            t = new Theme(name);
            allThemes.put(name, t);
        }
        return t;
    }

    private static Image loadOneImage(String name) {
        Image dImage = null;
        File file = new File(name);
        if (file.exists()) {
            dImage = Toolkit.getDefaultToolkit().createImage(name);
            MediaTracker tracker = new MediaTracker(Global.mMainWindow);
            tracker.addImage(dImage, 1);
            boolean interrupt = false;
            do {
                try {
                    interrupt = false;
                    tracker.waitForAll();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                    System.out.println("Error loading images!");
                    e.printStackTrace();
                    dImage = null;
                }
            } while (interrupt);
        }
        return dImage;
    }

    public String getCurrentThemePath() {
        String name = this.themeDir + File.separator;
        return name;
    }

    public String getBackImagePath() {
        String name = this.themeDir + File.separator + "Back.png";
        File f = new File(name);
        if (!this.isDefault && !f.exists()) {
            return Theme.getThemeInstance("default").getBackImagePath();
        }
        return name;
    }

    public String getTitleImagePath() {
        String name = this.themeDir + File.separator + "Title.png";
        File f = new File(name);
        if (!this.isDefault && !f.exists()) {
            return Theme.getThemeInstance("default").getTitleImagePath();
        }
        return name;
    }

    public Image getTitleImage() {
        String name = this.getTitleImagePath();
        Image i = Theme.loadOneImage(name);
        if (i == null && !this.isDefault) {
            return Theme.getThemeInstance("default").getTitleImage();
        }
        return i;
    }

    public Image getBackImage() {
        String name = this.getBackImagePath();
        Image i = Theme.loadOneImage(name);
        if (i == null && !this.isDefault) {
            return Theme.getThemeInstance("default").getBackImage();
        }
        return i;
    }

    public String getImagePath(String in) {
        String name = this.themeDir + File.separator + in;
        File f = new File(name);
        if (!this.isDefault && !f.exists()) {
            return Theme.getThemeInstance("default").getImagePath(in);
        }
        return name;
    }

    public Image getImage(String in) {
        String name = this.getImagePath(in);
        Image i = Theme.loadOneImage(name);
        if (i == null && !this.isDefault) {
            return Theme.getThemeInstance("default").getImage(in);
        }
        return i;
    }

    public String getGameImagePath() {
        String name = this.getData().mGameImage;
        File f = new File(name);
        if (!this.isDefault && !f.exists()) {
            return Theme.getThemeInstance("default").getGameImagePath();
        }
        return name;
    }

    public Image getGameImage() {
        String name = this.getTitleImagePath();
        Image i = Theme.loadOneImage(name);
        if (i == null && !this.isDefault) {
            return Theme.getThemeInstance("default").getGameImage();
        }
        return i;
    }

    static {
        allThemes = new HashMap();
        allThemes.put("default", new Theme());
    }
}

