/*
 * Decompiled with CFR 0.152.
 */
package de.malban.config.theme;

import de.malban.Global;
import de.malban.config.theme.ThemeDataXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ThemeData {
    protected String mClass = "";
    public String mName = "";
    protected boolean mResizeTitleImage = false;
    protected boolean mResizeGameImage = false;
    protected String mGameImage = "";
    private static ThemeDataXMLHandler XMLHANDLER = new ThemeDataXMLHandler();

    public boolean getResizeTitleImage() {
        return this.mResizeTitleImage;
    }

    public void setResizeTitleImage(boolean ResizeTitleImage) {
        this.mResizeTitleImage = ResizeTitleImage;
    }

    public boolean getResizeGameImage() {
        return this.mResizeGameImage;
    }

    public void setResizeGameImage(boolean ResizeGameImage) {
        this.mResizeGameImage = ResizeGameImage;
    }

    public String getGameImage() {
        return this.mGameImage;
    }

    public void setGameImage(String GameImage) {
        this.mGameImage = GameImage;
    }

    private String exportXML() {
        String s = new String();
        s = s + "\t<ThemeData>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<ResizeTitleImage>" + this.mResizeTitleImage + "</ResizeTitleImage>\n";
        s = s + "\t\t<ResizeGameImage>" + this.mResizeGameImage + "</ResizeGameImage>\n";
        s = s + "\t\t<GameImage>" + UtilityString.toXML(this.mGameImage) + "</GameImage>\n";
        s = s + "\t</ThemeData>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public static ThemeDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<ThemeData> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllThemeData>\n");
            for (ThemeData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllThemeData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, ThemeData> getHashMapFromXML(String filename) {
        HashMap<String, ThemeData> filters = new HashMap<String, ThemeData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ThemeDataXMLHandler h = ThemeData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "ThemeData Load Error...", 1);
        }
        return filters;
    }
}

