/*
 * Decompiled with CFR 0.152.
 */
package de.malban.event;

import de.malban.event.MasterEvent;
import de.malban.event.MasterEventListener;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.Vector;

public class EventSupport {
    private static EventSupport keyboard = null;
    private Vector<MasterEventListener> mKeyEventListener = new Vector();

    public void addKeyEventListener(MasterEventListener listener) {
        this.removeKeyEventListener(listener);
        this.mKeyEventListener.addElement(listener);
    }

    public void removeKeyEventListener(MasterEventListener listener) {
        this.mKeyEventListener.removeElement(listener);
    }

    public void fireKeyEvent(MasterEvent event) {
        for (int i = 0; i < this.mKeyEventListener.size(); ++i) {
            this.mKeyEventListener.elementAt(i).eventOccured(event);
        }
    }

    public static EventSupport getEventSupport() {
        if (keyboard == null) {
            keyboard = new EventSupport();
        }
        return keyboard;
    }

    private EventSupport() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                EventSupport.this.keyEventDispatched(e);
            }
        }, 8L);
    }

    public void keyEventDispatched(AWTEvent e) {
        if (!(e instanceof KeyEvent)) {
            return;
        }
        KeyEvent ke = (KeyEvent)e;
        MasterEvent event = new MasterEvent();
        int id = ke.getID();
        if (id == 401) {
            event.keyboardState = 0;
        }
        if (id == 402) {
            event.keyboardState = 2;
        }
        if (id == 400) {
            event.keyboardState = 1;
        }
        event.orgAWTEvent = e;
        event.orgAWTEvent = ke;
        event.type = 0;
        event.keyCode = ke.getKeyCode();
        this.fireKeyEvent(event);
    }
}

