/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.graphics.ImageSequenceData;
import de.malban.gui.ImageCache;
import de.malban.gui.Scaler;
import de.malban.util.UtilityImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JPanel;

public class BaseImageData {
    String fileName = "";
    public int xOrg = 0;
    public int yOrg = 0;
    public int x = 0;
    public int y = 0;
    public int w = 0;
    public int h = 0;
    public int cx = 0;
    public int cy = 0;
    public int cw = 0;
    public int ch = 0;
    public int pos = 0;
    public int ox = 0;
    public int oy = 0;
    public boolean randomAnim = false;
    public BufferedImage image = null;
    public String notice = "";
    JPanel cpanel = null;
    public static int _thickness = 2;
    public static int _antialiaseCount = 3;
    public static int _shadow_r = 0;
    public static int _shadow_g = 0;
    public static int _shadow_b = 0;
    public int thickness = 2;
    public int antialiaseCount = 3;
    public int shadow_r = 0;
    public int shadow_g = 0;
    public int shadow_b = 0;
    boolean wasShadowed = false;
    int step = 50;
    int[] colors;
    int shadow_a = 254;
    int shadowColor = 0;

    BaseImageData copy() {
        BaseImageData newBase = new BaseImageData();
        newBase.fileName = this.fileName;
        newBase.xOrg = this.xOrg;
        newBase.yOrg = this.yOrg;
        newBase.x = this.x;
        newBase.y = this.y;
        newBase.w = this.w;
        newBase.h = this.h;
        newBase.cx = this.cx;
        newBase.cy = this.cy;
        newBase.cw = this.cw;
        newBase.ch = this.ch;
        newBase.pos = this.pos;
        newBase.randomAnim = this.randomAnim;
        newBase.image = this.image;
        newBase.notice = this.notice;
        newBase.cpanel = null;
        return newBase;
    }

    public BaseImageData clone() {
        BaseImageData newBase = this.copy();
        newBase.image = UtilityImage.copyImage(this.image);
        return newBase;
    }

    public static Vector<BaseImageData> toBase(ImageSequenceData iData) {
        return BaseImageData.toBase(iData, 1.0);
    }

    public static Dimension getUnscaledMaxDimensions(ImageSequenceData iData) {
        int maxW = 0;
        int maxH = 0;
        for (int i = 0; i < iData.mHeight.size(); ++i) {
            int h = iData.mHeight.elementAt(i);
            int w = iData.mWidth.elementAt(i);
            if (iData.moptimzeCropOffsetX.size() > i) {
                w += iData.moptimzeCropOffsetX.elementAt(i).intValue();
                h += iData.moptimzeCropOffsetY.elementAt(i).intValue();
            }
            if (w > maxW) {
                maxW = w;
            }
            if (h <= maxH) continue;
            maxH = h;
        }
        return new Dimension(maxW, maxH);
    }

    public static Vector<BaseImageData> toBasePercent(ImageSequenceData iData, int scalePercent, int fixed100Width, int fixed100Height, boolean shadow) {
        return BaseImageData.toBase(iData, (float)scalePercent / 100.0f, fixed100Width, fixed100Height, shadow);
    }

    public static Vector<BaseImageData> toBasePercent(ImageSequenceData iData, int scalePercent, int fixed100Width, int fixed100Height) {
        return BaseImageData.toBase(iData, (float)scalePercent / 100.0f, fixed100Width, fixed100Height, false);
    }

    public static Vector<BaseImageData> toBasePercent(ImageSequenceData iData, int scalePercent) {
        return BaseImageData.toBasePercent(iData, scalePercent, false);
    }

    public static Vector<BaseImageData> toBasePercent(ImageSequenceData iData, int scalePercent, boolean shadow) {
        Dimension unscaledSize = BaseImageData.getUnscaledMaxDimensions(iData);
        return BaseImageData.toBasePercent(iData, scalePercent, unscaledSize.width, unscaledSize.height, shadow);
    }

    public static Vector<BaseImageData> toBase(ImageSequenceData iData, double scale) {
        return BaseImageData.toBase(iData, scale, false);
    }

    public static Vector<BaseImageData> toBase(ImageSequenceData iData, double scale, boolean shadow) {
        Dimension unscaledSize = BaseImageData.getUnscaledMaxDimensions(iData);
        return BaseImageData.toBase(iData, scale, unscaledSize.width, unscaledSize.height, shadow);
    }

    public static Vector<BaseImageData> toBase(ImageSequenceData iData, double scale, int fixed100Width, int fixed100Height) {
        return BaseImageData.toBase(iData, scale, fixed100Width, fixed100Height, false);
    }

    public static Vector<BaseImageData> toBase(ImageSequenceData iData, double scale, int fixed100Width, int fixed100Height, boolean shadow) {
        return BaseImageData.toBase(iData, (float)scale, fixed100Width, fixed100Height, shadow);
    }

    public static Vector<BaseImageData> toBase(ImageSequenceData iData, float scale, int fixed100Width, int fixed100Height) {
        return BaseImageData.toBase(iData, scale, fixed100Width, fixed100Height, false);
    }

    public static synchronized Vector<BaseImageData> toBase(ImageSequenceData iData, float scale, int fixed100Width, int fixed100Height, boolean shadow) {
        Vector<BaseImageData> bases = new Vector<BaseImageData>();
        Dimension unscaledSize = BaseImageData.getUnscaledMaxDimensions(iData);
        for (int i = 0; i < iData.mHeight.size(); ++i) {
            BaseImageData d = new BaseImageData();
            d.h = iData.mHeight.elementAt(i);
            d.w = iData.mWidth.elementAt(i);
            d.x = iData.mXPos.elementAt(i);
            d.y = iData.mYPos.elementAt(i);
            d.xOrg = d.x;
            d.yOrg = d.y;
            if (iData.mCropHeight.size() > i) {
                d.ch = iData.mCropHeight.elementAt(i);
                d.cw = iData.mCropWidth.elementAt(i);
                d.cx = iData.mCropXPos.elementAt(i);
                d.cy = iData.mCropYPos.elementAt(i);
            } else {
                d.ch = d.h;
                d.cw = d.w;
                d.cx = 0;
                d.cy = 0;
            }
            if (iData.moptimzeCropOffsetX.size() > i) {
                d.ox = iData.moptimzeCropOffsetX.elementAt(i);
                d.oy = iData.moptimzeCropOffsetY.elementAt(i);
            } else {
                d.ox = 0;
                d.oy = 0;
            }
            d.pos = iData.mPosition.elementAt(i);
            d.fileName = iData.mImageSourceFile.elementAt(i);
            d.notice = iData.mOriginNotice;
            d.randomAnim = iData.mRandomAnimationStart;
            BufferedImage lastBim = ImageCache.getImageCache().getImage(d.fileName);
            ImageCache.getImageCache().canBeInvalidated(lastBim);
            d.image = ImageCache.getImageCache().getDerivatSubImage(lastBim, d.x, d.y, d.w, d.h);
            float scaleX = Scaler.unscaleFloatToFloat(fixed100Width, unscaledSize.width);
            float scaleY = Scaler.unscaleFloatToFloat(fixed100Height, unscaledSize.height);
            scaleX = Scaler.scaleFloatToFloat(scaleX, scale);
            scaleY = Scaler.scaleFloatToFloat(scaleY, scale);
            int newWidth = Scaler.scaleFloatToInt(d.w, scaleX);
            int newHeight = Scaler.scaleFloatToInt(d.h, scaleY);
            if ((double)scaleX != 1.0) {
                if (Scaler.overlappedScaling) {
                    ++newWidth;
                    ++newHeight;
                    if ((double)scaleX < 0.6) {
                        ++newWidth;
                    }
                    if ((double)scaleY < 0.6) {
                        ++newHeight;
                    }
                    if ((double)scaleX < 0.3) {
                        ++newWidth;
                    }
                    if ((double)scaleY < 0.3) {
                        ++newHeight;
                    }
                }
                d.image = ImageCache.getImageCache().getDerivatScale(d.image, newWidth, newHeight);
            }
            d.x = 0;
            d.y = 0;
            d.w = newWidth;
            d.h = newHeight;
            d.ch = (int)((float)d.ch * scaleY);
            d.cw = (int)((float)d.cw * scaleX);
            d.cx = (int)((float)d.cx * scaleX);
            d.cy = (int)((float)d.cy * scaleY);
            d.ox = (int)((float)d.ox * scaleX);
            d.oy = (int)((float)d.oy * scaleY);
            if (shadow) {
                d.thickness = _thickness;
                d.antialiaseCount = _antialiaseCount;
                d.shadow_r = _shadow_r;
                d.shadow_g = _shadow_g;
                d.shadow_b = _shadow_b;
                d.applyShadow();
                d.wasShadowed = true;
            } else {
                d.wasShadowed = false;
            }
            bases.addElement(d);
        }
        return BaseImageData.reorder(bases);
    }

    public void calculateCrop() {
        int y_;
        int x_;
        int a;
        int rgba;
        int x_2;
        boolean opaque;
        int y_2;
        this.cx = 0;
        this.cy = 0;
        this.cw = this.w;
        this.ch = this.h;
        for (y_2 = 0; y_2 < this.h; ++y_2) {
            opaque = false;
            for (x_2 = 0; x_2 < this.w; ++x_2) {
                rgba = this.image.getRGB(x_2, y_2);
                a = rgba >> 24 & 0xFF;
                if (a == 0) continue;
                opaque = true;
                break;
            }
            if (opaque) break;
            ++this.cy;
            --this.ch;
        }
        for (y_2 = this.h - 1; y_2 >= 0; --y_2) {
            opaque = false;
            for (x_2 = 0; x_2 < this.w; ++x_2) {
                rgba = this.image.getRGB(x_2, y_2);
                a = rgba >> 24 & 0xFF;
                if (a == 0) continue;
                opaque = true;
                break;
            }
            if (opaque) break;
            --this.ch;
        }
        for (x_ = 0; x_ < this.w; ++x_) {
            opaque = false;
            for (y_ = 0; y_ < this.h; ++y_) {
                rgba = this.image.getRGB(x_, y_);
                a = rgba >> 24 & 0xFF;
                if (a == 0) continue;
                opaque = true;
                break;
            }
            if (opaque) break;
            ++this.cx;
            --this.cw;
        }
        for (x_ = this.w - 1; x_ >= 0; --x_) {
            opaque = false;
            for (y_ = 0; y_ < this.h; ++y_) {
                rgba = this.image.getRGB(x_, y_);
                a = rgba >> 24 & 0xFF;
                if (a == 0) continue;
                opaque = true;
                break;
            }
            if (opaque) break;
            --this.cw;
        }
    }

    public void applySimpleCrop() {
        this.x += this.cx;
        this.y += this.cy;
        this.xOrg += this.cx;
        this.yOrg += this.cy;
        this.w = this.cw;
        this.h = this.ch;
        this.cx = 0;
        this.cy = 0;
        this.cw = this.w;
        this.ch = this.h;
        this.ox = 0;
        this.oy = 0;
        this.reInitImage();
    }

    public void applyOffsetCrop() {
        this.x += this.cx;
        this.y += this.cy;
        this.xOrg += this.cx;
        this.yOrg += this.cy;
        this.w = this.cw;
        this.h = this.ch;
        this.ox = this.cx;
        this.oy = this.cy;
        this.cx = 0;
        this.cy = 0;
        this.cw = this.w;
        this.ch = this.h;
        this.reInitImage();
    }

    public static Vector<BaseImageData> reorder(Vector<BaseImageData> bases) {
        Collections.sort(bases, new Comparator<BaseImageData>(){

            @Override
            public final int compare(BaseImageData s1, BaseImageData s2) {
                return s1.pos - s2.pos;
            }
        });
        return bases;
    }

    public static void fromBase(ImageSequenceData iData, Vector<BaseImageData> base) {
        Vector<Integer> poss = new Vector<Integer>();
        Vector<Integer> heights = new Vector<Integer>();
        Vector<Integer> widths = new Vector<Integer>();
        Vector<Integer> xs = new Vector<Integer>();
        Vector<Integer> ys = new Vector<Integer>();
        Vector<Integer> cheights = new Vector<Integer>();
        Vector<Integer> cwidths = new Vector<Integer>();
        Vector<Integer> cxs = new Vector<Integer>();
        Vector<Integer> cys = new Vector<Integer>();
        Vector<Integer> oxs = new Vector<Integer>();
        Vector<Integer> oys = new Vector<Integer>();
        Vector<String> names = new Vector<String>();
        String notice = "";
        boolean random = false;
        for (int i = 0; i < base.size(); ++i) {
            BaseImageData d = base.elementAt(i);
            poss.addElement(i);
            heights.addElement(d.h);
            widths.addElement(d.w);
            xs.addElement(d.xOrg);
            ys.addElement(d.yOrg);
            cheights.addElement(d.ch);
            cwidths.addElement(d.cw);
            cxs.addElement(d.cx);
            cys.addElement(d.cy);
            oxs.addElement(d.ox);
            oys.addElement(d.oy);
            names.addElement(d.fileName);
            notice = d.notice;
            random = d.randomAnim;
        }
        iData.mHeight = heights;
        iData.mWidth = widths;
        iData.mXPos = xs;
        iData.mYPos = ys;
        iData.mCropHeight = cheights;
        iData.mCropWidth = cwidths;
        iData.mCropXPos = cxs;
        iData.mCropYPos = cys;
        iData.moptimzeCropOffsetX = oxs;
        iData.moptimzeCropOffsetY = oys;
        iData.mPosition = poss;
        iData.mImageSourceFile = names;
        iData.mOriginNotice = notice;
        iData.mRandomAnimationStart = random;
    }

    synchronized void reInitImage() {
        if (this.fileName == null) {
            return;
        }
        if (this.fileName.trim().length() == 0) {
            if (this.w + this.x > this.image.getWidth()) {
                this.w = this.image.getWidth() - this.x;
            }
            if (this.h + this.y > this.image.getHeight()) {
                this.h = this.image.getHeight() - this.y;
            }
            ImageCache.getImageCache().remove(this.fileName);
            this.image = ImageCache.getImageCache().getDerivatSubImage(this.image, this.x, this.y, this.w, this.h);
            if (this.wasShadowed) {
                this.applyShadow();
            }
            this.x = 0;
            this.y = 0;
            return;
        }
        ImageCache.getImageCache().remove(this.fileName);
        BufferedImage lastBim = ImageCache.getImageCache().getImage(this.fileName);
        if (this.w + this.xOrg > lastBim.getWidth()) {
            this.w = lastBim.getWidth() - this.xOrg;
        }
        if (this.h + this.yOrg > lastBim.getHeight()) {
            this.h = lastBim.getHeight() - this.yOrg;
        }
        ImageCache.getImageCache().canBeInvalidated(lastBim);
        this.image = ImageCache.getImageCache().getDerivatSubImage(lastBim, this.xOrg, this.yOrg, this.w, this.h);
        if (this.wasShadowed) {
            this.applyShadow();
        }
        this.x = 0;
        this.y = 0;
    }

    private void applyShadow() {
        int a;
        int rgba;
        int _y;
        int _x;
        int i;
        BufferedImage copy = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
        Graphics2D g2 = copy.createGraphics();
        g2.drawImage(this.image, null, null);
        g2.dispose();
        BufferedImage copy2 = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 2);
        Graphics2D g3 = copy2.createGraphics();
        g3.drawImage(this.image, null, null);
        g3.dispose();
        int _w = copy.getWidth();
        int _h = copy.getHeight();
        this.shadowColor = (this.shadow_r << 16) + (this.shadow_g << 8) + this.shadow_b;
        this.step = this.shadow_a / (this.thickness + 1);
        this.colors = new int[this.thickness];
        int bb = this.shadow_a;
        for (i = 0; i < this.thickness; ++i) {
            this.colors[i] = (bb << 24) + this.shadowColor;
            if ((bb -= this.step) >= 0) continue;
            bb = 0;
        }
        for (_x = 0; _x < _w; ++_x) {
            for (_y = 0; _y < _h; ++_y) {
                rgba = this.image.getRGB(_x, _y);
                a = rgba >> 24 & 0xFF;
                if (a == 0) continue;
                this.setThickPixel(copy, _w, _h, _x, _y, this.thickness);
            }
        }
        for (_x = 0; _x < _w; ++_x) {
            for (_y = 0; _y < _h; ++_y) {
                rgba = this.image.getRGB(_x, _y);
                a = rgba >> 24 & 0xFF;
                if (a != 0 || (a = (rgba = copy.getRGB(_x, _y)) >> 24 & 0xFF) == 0) continue;
                copy2.setRGB(_x, _y, rgba);
            }
        }
        for (i = 0; i < this.antialiaseCount; ++i) {
            this.antialiase(copy2);
        }
        this.image = copy2;
    }

    void setThickPixel(BufferedImage image, int _w, int _h, int _x, int _y, int _thickness_) {
        image.setRGB(_x, _y, (this.shadow_a << 24) + this.shadowColor);
        for (int yy = 1; yy < _thickness_ + 1; ++yy) {
            this.setOnePixel(image, _w, _h, _x, _y - yy, this.colors[yy - 1]);
            this.setOnePixel(image, _w, _h, _x, _y + yy, this.colors[yy - 1]);
            for (int xx = 1; xx < _thickness_ + 1; ++xx) {
                int radius = (xx + yy) / 2;
                this.setOnePixel(image, _w, _h, _x - xx, _y - yy, this.colors[radius - 1]);
                this.setOnePixel(image, _w, _h, _x + xx, _y - yy, this.colors[radius - 1]);
                this.setOnePixel(image, _w, _h, _x - xx, _y + yy, this.colors[radius - 1]);
                this.setOnePixel(image, _w, _h, _x + xx, _y + yy, this.colors[radius - 1]);
                this.setOnePixel(image, _w, _h, _x - xx, _y, this.colors[xx - 1]);
                this.setOnePixel(image, _w, _h, _x + xx, _y, this.colors[xx - 1]);
            }
        }
    }

    void setOnePixel(BufferedImage image, int _w, int _h, int _x, int _y, int color) {
        int newa;
        if (_x < 0) {
            return;
        }
        if (_y < 0) {
            return;
        }
        if (_x > _w - 1) {
            return;
        }
        if (_y > _h - 1) {
            return;
        }
        int olda = image.getRGB(_x, _y) >> 24 & 0xFF;
        if (olda > (newa = color >> 24 & 0xFF)) {
            return;
        }
        image.setRGB(_x, _y, color);
    }

    void antialiase(BufferedImage image) {
        int _w = image.getWidth();
        int _h = image.getHeight();
        for (int _x = 0; _x < _w; ++_x) {
            for (int _y = 0; _y < _h; ++_y) {
                int rgba = image.getRGB(_x, _y);
                int rgb = rgba & 0xFFFFFF;
                int a = rgba >> 24 & 0xFF;
                int count = 1;
                if (rgb != this.shadowColor && rgb != 0 || a >= 254) continue;
                int a2 = this.getAlpha(image, _w, _h, _x - 1, _y - 1);
                if (a2 != -1) {
                    ++count;
                    a += a2;
                }
                if ((a2 = this.getAlpha(image, _w, _h, _x, _y - 1)) != -1) {
                    ++count;
                    a += a2;
                }
                if ((a2 = this.getAlpha(image, _w, _h, _x + 1, _y - 1)) != -1) {
                    ++count;
                    a += a2;
                }
                if ((a2 = this.getAlpha(image, _w, _h, _x - 1, _y + 1)) != -1) {
                    ++count;
                    a += a2;
                }
                if ((a2 = this.getAlpha(image, _w, _h, _x, _y + 1)) != -1) {
                    ++count;
                    a += a2;
                }
                if ((a2 = this.getAlpha(image, _w, _h, _x + 1, _y + 1)) != -1) {
                    ++count;
                    a += a2;
                }
                if ((a2 = this.getAlpha(image, _w, _h, _x - 1, _y)) != -1) {
                    ++count;
                    a += a2;
                }
                if ((a2 = this.getAlpha(image, _w, _h, _x + 1, _y)) != -1) {
                    ++count;
                    a += a2;
                }
                a /= count;
                image.setRGB(_x, _y, (a <<= 24) + this.shadowColor);
            }
        }
    }

    int getAlpha(BufferedImage image, int _w, int _h, int _x, int _y) {
        if (_x < 0) {
            return -1;
        }
        if (_y < 0) {
            return -1;
        }
        if (_x > _w - 1) {
            return -1;
        }
        if (_y > _h - 1) {
            return -1;
        }
        int rgba = image.getRGB(_x, _y);
        int rgb = rgba & 0xFFFFFF;
        int a = rgba >> 24 & 0xFF;
        if (rgb != this.shadowColor && rgb != 0) {
            return -1;
        }
        if (a == 255) {
            return -1;
        }
        return a;
    }
}

