/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.graphics.Vertex;
import de.malban.util.UtilityString;
import java.util.ArrayList;
import java.util.Comparator;

public class Face {
    public static final int NONE = 0;
    public static final int FACE = 1;
    public static final int POINT = 2;
    public static final int LINE = 3;
    public ArrayList<Vertex> vertice = new ArrayList();
    public int faceID = -1;
    public int type = 0;

    public void order() {
        this.vertice.sort(new Comparator<Vertex>(){

            @Override
            public int compare(Vertex v1, Vertex v2) {
                int pos1 = -1;
                for (String faceIdString : v1.face) {
                    if (!faceIdString.startsWith("" + Face.this.faceID + "|")) continue;
                    String pos1S = faceIdString.substring(("" + Face.this.faceID + "|").length());
                    pos1 = UtilityString.Int0(pos1S);
                    break;
                }
                int pos2 = -1;
                for (String faceIdString : v2.face) {
                    if (!faceIdString.startsWith("" + Face.this.faceID + "|")) continue;
                    String pos2S = faceIdString.substring(("" + Face.this.faceID + "|").length());
                    pos2 = UtilityString.Int0(pos2S);
                    break;
                }
                return pos1 - pos2;
            }
        });
    }

    public String getUidsString() {
        String ret = "";
        for (Vertex v : this.vertice) {
            ret = ret + v.uid + " ";
        }
        return ret;
    }

    public String getPointsString() {
        String ret = "";
        for (Vertex v : this.vertice) {
            ret = ret + "(" + v.toString() + ") ";
        }
        return ret;
    }
}

