/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.config.Configuration;
import de.malban.graphics.VectorColors;
import de.malban.graphics.Vertex;
import de.malban.gui.panels.LogPanel;
import de.malban.util.XMLSupport;
import java.util.HashMap;

public class GFXVector {
    public int isPosUsed = 0;
    public String key1 = "";
    public String key2 = "";
    public int maxConnectCount = Integer.MAX_VALUE;
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public static XMLSupport xmlSupport = new XMLSupport();
    private transient int orgUID = -1;
    private transient int oldCloneUID = -1;
    private static int UID = 0;
    public int uid = ++UID;
    public int load_uid = 0;
    boolean relativ = false;
    public boolean is3d = false;
    public int order;
    public GFXVector start_connect = null;
    public GFXVector end_connect = null;
    public Vertex start = new Vertex();
    public Vertex end = new Vertex();
    public int uid_start_connect = -1;
    public int uid_end_connect = -1;
    public int factor;
    public int r = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getRed();
    public int g = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getGreen();
    public int b = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getBlue();
    public int a = 128;
    public int pattern = 255;
    public int intensity = 127;
    public boolean selected = false;
    public boolean highlight = false;

    public static void setMaxUID(int u) {
        UID = u;
    }

    public GFXVector inverse() {
        Vertex x = this.start;
        this.start = this.end;
        this.end = x;
        int xx = this.uid_start_connect;
        this.uid_start_connect = this.uid_end_connect;
        this.uid_end_connect = xx;
        GFXVector xxx = this.start_connect;
        this.start_connect = this.end_connect;
        this.end_connect = xxx;
        return this;
    }

    public GFXVector() {
        this.order = this.uid;
    }

    public GFXVector(Vertex v1, Vertex v2) {
        this.order = this.uid;
        this.start = new Vertex(v1);
        this.end = new Vertex(v2);
    }

    public String toString() {
        return this.start.toString() + " -> " + this.end.toString();
    }

    public void resetSelection() {
        this.selected = false;
        this.highlight = false;
        this.start.resetSelection();
        this.end.resetSelection();
    }

    public void resetDisplay() {
        this.selected = false;
        this.highlight = false;
        this.r = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getRed();
        this.g = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getGreen();
        this.b = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getBlue();
        this.a = 128;
        this.start.resetDisplay();
        this.end.resetDisplay();
    }

    public GFXVector(GFXVector oldVector, int difX, int difY, int difZ) {
        this.order = this.uid;
        if (oldVector != null) {
            this.start = oldVector.end;
            oldVector.end_connect = this;
            oldVector.uid_end_connect = this.uid;
            if (oldVector.uid_start_connect != -1) {
                oldVector.setRelativ(true);
            }
            this.start_connect = oldVector;
            this.uid_start_connect = oldVector.uid;
            this.end.x(this.start.x() + (double)difX);
            this.end.y(this.start.y() + (double)difY);
            this.end.z(this.start.z() + (double)difZ);
        }
    }

    public GFXVector clone() {
        GFXVector v = new GFXVector();
        v.selected = this.selected;
        v.highlight = this.highlight;
        v.setIntensity(this.getIntensity());
        v.pattern = this.pattern;
        v.r = this.r;
        v.g = this.b;
        v.b = this.b;
        v.a = this.a;
        v.factor = this.factor;
        v.start.set(this.start);
        v.end.set(this.end);
        v.oldCloneUID = this.uid;
        v.orgUID = this.orgUID;
        return v;
    }

    public GFXVector cloneSetOrg() {
        GFXVector v = new GFXVector();
        v.selected = this.selected;
        v.highlight = this.highlight;
        v.setIntensity(this.getIntensity());
        v.pattern = this.pattern;
        v.r = this.r;
        v.g = this.b;
        v.b = this.b;
        v.a = this.a;
        v.factor = this.factor;
        v.start.set(this.start);
        v.end.set(this.end);
        v.oldCloneUID = this.uid;
        v.orgUID = this.uid;
        return v;
    }

    public int getOrgUID() {
        return this.orgUID;
    }

    public int getOldCloneUID() {
        return this.oldCloneUID;
    }

    public boolean isRelativ() {
        return this.relativ;
    }

    public void setRelativ(boolean relativ) {
        this.relativ = relativ;
        if (!relativ) {
            this.r = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getRed();
            this.g = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getGreen();
            this.b = VectorColors.VECCI_VECTOR_FOREGROUND_COLOR.getBlue();
            this.a = this.getIntensity() * 2;
        } else {
            this.r = VectorColors.VECCI_VECTOR_RELATIVE_COLOR.getRed();
            this.g = VectorColors.VECCI_VECTOR_RELATIVE_COLOR.getGreen();
            this.b = VectorColors.VECCI_VECTOR_RELATIVE_COLOR.getBlue();
            this.a = this.getIntensity() * 2;
        }
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
        this.a = intensity * 2;
        if (this.a > 255) {
            this.a = 255;
        }
        if (this.a < 0) {
            this.a = 0;
        }
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= this.start.toXML(s, "startVertex");
        ok &= this.end.toXML(s, "endVertex");
        ok &= XMLSupport.addElement(s, "pattern", this.pattern);
        ok &= XMLSupport.addElement(s, "r", this.r);
        ok &= XMLSupport.addElement(s, "g", this.g);
        ok &= XMLSupport.addElement(s, "b", this.b);
        ok &= XMLSupport.addElement(s, "a", this.a);
        ok &= XMLSupport.addElement(s, "id", this.uid);
        ok &= XMLSupport.addElement(s, "order", this.order);
        ok &= XMLSupport.addElement(s, "start_neighbour_id", this.uid_start_connect);
        ok &= XMLSupport.addElement(s, "end_neighbour_id", this.uid_end_connect);
        ok &= XMLSupport.addElement(s, "start_is_relative", this.relativ);
        ok &= XMLSupport.addElement(s, "end_is_relative", this.relativ);
        ok &= XMLSupport.addElement(s, "is_3d", this.is3d);
        s.append("</").append(tag).append(">\n");
        return ok &= XMLSupport.addElement(s, "intensity", this.intensity);
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.start.fromXML(xmlSupport.getXMLElement("startVertex", xml), xmlSupport);
        errorCode |= xmlSupport.errorCode;
        this.end.fromXML(xmlSupport.getXMLElement("endVertex", xml), xmlSupport);
        errorCode |= xmlSupport.errorCode;
        this.pattern = xmlSupport.getIntElement("pattern", xml);
        errorCode |= xmlSupport.errorCode;
        this.r = xmlSupport.getIntElement("r", xml);
        errorCode |= xmlSupport.errorCode;
        this.g = xmlSupport.getIntElement("g", xml);
        errorCode |= xmlSupport.errorCode;
        this.b = xmlSupport.getIntElement("b", xml);
        errorCode |= xmlSupport.errorCode;
        this.a = xmlSupport.getIntElement("a", xml);
        errorCode |= xmlSupport.errorCode;
        this.load_uid = xmlSupport.getIntElement("id", xml);
        errorCode |= xmlSupport.errorCode;
        this.order = xmlSupport.getIntElement("order", xml);
        errorCode |= xmlSupport.errorCode;
        this.uid_start_connect = xmlSupport.getIntElement("start_neighbour_id", xml);
        errorCode |= xmlSupport.errorCode;
        this.uid_end_connect = xmlSupport.getIntElement("end_neighbour_id", xml);
        errorCode |= xmlSupport.errorCode;
        boolean startRelative = xmlSupport.getBooleanElement("start_is_relative", xml);
        errorCode |= xmlSupport.errorCode;
        boolean endRelative = xmlSupport.getBooleanElement("end_is_relative", xml);
        errorCode |= xmlSupport.errorCode;
        this.relativ = startRelative & endRelative;
        this.is3d = xmlSupport.getBooleanElement("is_3d", xml);
        errorCode |= xmlSupport.errorCode;
        this.intensity = xmlSupport.getIntElement("intensity", xml);
        return (errorCode |= xmlSupport.errorCode) == 0;
    }

    public double getMaxAbsValue() {
        double minX = 2.147483647E9;
        double maxX = -2.147483647E9;
        double minY = 2.147483647E9;
        double maxY = -2.147483647E9;
        double minZ = 2.147483647E9;
        double maxZ = -2.147483647E9;
        GFXVector v = this;
        if (minX > v.start.x()) {
            minX = v.start.x();
        }
        if (minX > v.end.x()) {
            minX = v.end.x();
        }
        if (maxX < v.start.x()) {
            maxX = v.start.x();
        }
        if (maxX < v.end.x()) {
            maxX = v.end.x();
        }
        if (minY > v.start.y()) {
            minY = v.start.y();
        }
        if (minY > v.end.y()) {
            minY = v.end.y();
        }
        if (maxY < v.start.y()) {
            maxY = v.start.y();
        }
        if (maxY < v.end.y()) {
            maxY = v.end.y();
        }
        if (minZ > v.start.z()) {
            minZ = v.start.z();
        }
        if (minZ > v.end.z()) {
            minZ = v.end.z();
        }
        if (maxZ < v.start.z()) {
            maxZ = v.start.z();
        }
        if (maxZ < v.end.z()) {
            maxZ = v.end.z();
        }
        double max = Math.max(Math.abs(maxX), Math.abs(maxY));
        max = Math.max(max, Math.abs(maxZ));
        max = Math.max(max, Math.abs(minX));
        max = Math.max(max, Math.abs(minY));
        max = Math.max(max, Math.abs(minZ));
        return max;
    }

    public double getMaxAbsLenValue() {
        GFXVector v = this;
        double xLen = v.end.x() - v.start.x();
        double yLen = v.end.y() - v.start.y();
        double zLen = v.end.z() - v.start.z();
        double max = Math.max(Math.abs(xLen), Math.abs(yLen));
        max = Math.max(max, Math.abs(zLen));
        return max;
    }

    public void intAll() {
        GFXVector v = this;
        v.start.x((int)v.start.x());
        v.start.y((int)v.start.y());
        v.start.z((int)v.start.z());
        v.end.x((int)v.end.x());
        v.end.y((int)v.end.y());
        v.end.z((int)v.end.z());
    }

    public void scaleAll(double scale, HashMap<Vertex, Boolean> safetyMap) {
        this.scaleAll(scale, safetyMap, true, true, true);
    }

    public void scaleAll(double scale, HashMap<Vertex, Boolean> safetyMap, boolean yScale, boolean xScale, boolean zScale) {
        GFXVector v = this;
        if (safetyMap.get(v.start) == null) {
            if (xScale) {
                v.start.x((int)(v.start.x() * scale));
            }
            if (yScale) {
                v.start.y((int)(v.start.y() * scale));
            }
            if (zScale) {
                v.start.z((int)(v.start.z() * scale));
            }
            safetyMap.put(v.start, true);
        }
        if (safetyMap.get(v.end) == null) {
            if (xScale) {
                v.end.x((int)(v.end.x() * scale));
            }
            if (yScale) {
                v.end.y((int)(v.end.y() * scale));
            }
            if (zScale) {
                v.end.z((int)(v.end.z() * scale));
            }
            safetyMap.put(v.end, true);
        }
    }

    public boolean contains(Vertex v) {
        if (v == null) {
            return false;
        }
        if (this.start != null && this.start.uid == v.uid) {
            return true;
        }
        return this.end != null && this.end.uid == v.uid;
    }

    public boolean equals(GFXVector v1) {
        return this.start.equals(v1.start) && this.end.equals(v1.end);
    }

    public boolean equalsIgnoreDirection(GFXVector v1) {
        if (this.start.equals(v1.start) && this.end.equals(v1.end)) {
            return true;
        }
        return this.start.equals(v1.end) && this.end.equals(v1.start);
    }
}

