/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.config.Configuration;
import de.malban.event.EditMouseEvent;
import de.malban.graphics.BaseImageData;
import de.malban.graphics.GridData;
import de.malban.graphics.MouseMovedListener;
import de.malban.graphics.MousePressedListener;
import de.malban.gui.ImageCache;
import de.malban.gui.panels.LogPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class SingleImagePanel
extends JPanel {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    private Vector<MouseMovedListener> mMovedListener = new Vector();
    private Vector<MousePressedListener> mClickListener = new Vector();
    private BufferedImage sourceImage = null;
    BufferedImage scaledImage = null;
    GridData grid = new GridData();
    Color crossColor = Color.ORANGE;
    int sourceHeight = 0;
    int sourceWidth = 0;
    boolean doOffset = false;
    int offsetX = 0;
    int offsetY = 0;
    int scaledOffsetX = 0;
    int scaledOffsetY = 0;
    boolean fixedScale = false;
    boolean isScale = false;
    int scaleW = 0;
    int scaleH = 0;
    boolean drawCheckers = true;
    int scaleHeight = 0;
    int scaleWidth = 0;
    double scaleX = 1.0;
    double scaleY = 1.0;
    int inSetting = 0;
    int mX = 0;
    int mY = 0;
    int mXPressStart = 0;
    int mYPressStart = 0;
    boolean shiftPressed = false;
    boolean pressed = false;
    boolean crossDrawn = true;
    boolean displayDragSelection = true;
    boolean noCross = true;
    boolean draging = false;
    boolean displayGrid = false;
    public int selWidth = 0;
    public int selHeight = 0;
    boolean selectionLock = false;
    boolean noMouseReaction = false;
    int R = 0;
    int G = 0;
    int B = 0;
    int A = 0;
    String orgName = "";
    int selX = -1;
    int selY = -1;
    int selW = -1;
    int selH = -1;
    boolean selectionSet = false;
    boolean scaleToFit = false;

    public SingleImagePanel() {
        this.initComponents();
    }

    public void deinit() {
        this.setVisible(false);
        this.mMovedListener.clear();
        this.mClickListener.clear();
        this.unsetImage();
    }

    public boolean saveSourceImage() {
        return this.saveSourceImage(this.orgName);
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setDrawCheckers(boolean dc) {
        this.drawCheckers = dc;
    }

    public void setCrossDrawn(boolean cd) {
        this.crossDrawn = cd;
    }

    public void setSelectionDrawn(boolean sd) {
        this.displayDragSelection = sd;
    }

    public void setNoMouseRection(boolean mr) {
        this.noMouseReaction = mr;
    }

    public boolean isShiftPressedOnClick() {
        return this.shiftPressed;
    }

    public int getSourceHeight() {
        return this.sourceHeight;
    }

    public int getSourceWidth() {
        return this.sourceWidth;
    }

    public boolean saveSourceImage(String path) {
        try {
            File outputfile = new File(path);
            ImageIO.write((RenderedImage)this.sourceImage, "png", outputfile);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean saveScaledImage(String path) {
        try {
            File outputfile = new File(path);
            ImageIO.write((RenderedImage)this.scaledImage, "png", outputfile);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean isImageSet() {
        return this.sourceImage != null;
    }

    public void sourceToAlpha() {
        this.sourceImage = ImageCache.getImageCache().toAlpha(this.sourceImage);
        this.correctScaleWithOffset();
    }

    public boolean isAlpha() {
        return this.sourceImage.getColorModel().hasAlpha();
    }

    public void replaceColorToBackground(int r, int g, int b, int a) {
        if (this.inSetting > 0) {
            return;
        }
        ++this.inSetting;
        if (!this.isAlpha()) {
            this.sourceToAlpha();
        }
        int rgbaSeek = new Color(r, g, b, a).getRGB();
        int rgbaSet = new Color(r, g, b, 0).getRGB();
        for (int y = 0; y < this.sourceImage.getHeight(); ++y) {
            for (int x = 0; x < this.sourceImage.getWidth(); ++x) {
                int rgba = this.sourceImage.getRGB(x, y);
                if (rgba != rgbaSeek) continue;
                this.sourceImage.setRGB(x, y, rgbaSet);
            }
        }
        ImageCache.getImageCache().invalidateDerivates(this.sourceImage);
        this.scaledImage = ImageCache.getImageCache().getDerivatScale(this.sourceImage, this.scaleWidth, this.scaleHeight);
        this.setSize(new Dimension(this.scaleWidth, this.scaleHeight));
        this.setPreferredSize(new Dimension(this.scaleWidth, this.scaleHeight));
        this.repaint();
        --this.inSetting;
    }

    public boolean setImageFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                bufferedImage.getGraphics().drawImage(image, 0, 0, null);
                this.sourceImage = bufferedImage;
                if (this.sourceImage == null) {
                    return false;
                }
                this.sourceHeight = this.sourceImage.getHeight(null);
                this.sourceWidth = this.sourceImage.getWidth(null);
                this.setScale(1);
                return true;
            }
            this.log.addLog("No image available in clipboard.");
        }
        catch (Exception e) {
            this.log.addLog("Failed to retrieve image from clipboard.");
        }
        return false;
    }

    public boolean setImage(String path) {
        if (this.inSetting > 0) {
            return true;
        }
        if (path.trim().length() == 0) {
            return false;
        }
        this.orgName = path;
        this.sourceImage = ImageCache.getImageCache().getImage(path);
        if (this.sourceImage == null) {
            return false;
        }
        this.sourceHeight = this.sourceImage.getHeight(null);
        this.sourceWidth = this.sourceImage.getWidth(null);
        this.setScale(1);
        return true;
    }

    public boolean setImage(String path, boolean scaleToFit) {
        if (this.inSetting > 0) {
            return true;
        }
        if (path.trim().length() == 0) {
            return false;
        }
        this.orgName = path;
        this.sourceImage = ImageCache.getImageCache().getImage(path);
        if (this.sourceImage == null) {
            return false;
        }
        this.sourceHeight = this.sourceImage.getHeight(null);
        this.sourceWidth = this.sourceImage.getWidth(null);
        this.scaleToFit();
        return true;
    }

    public BufferedImage getImage() {
        return this.sourceImage;
    }

    public BufferedImage getScaledImage() {
        return this.scaledImage;
    }

    public boolean setImage(BufferedImage image) {
        if (this.inSetting > 0) {
            return true;
        }
        ++this.inSetting;
        this.orgName = "";
        this.sourceImage = image;
        this.sourceHeight = this.sourceImage.getHeight(null);
        this.sourceWidth = this.sourceImage.getWidth(null);
        --this.inSetting;
        this.setScale(1);
        return true;
    }

    void correctScaleWithOffset() {
        if (!this.isScale) {
            this.scaledOffsetY = this.offsetY;
            this.scaledOffsetX = this.offsetX;
            return;
        }
        if (this.fixedScale) {
            this.setScale(this.scaleW, this.scaleH);
        } else {
            this.setScale(this.scaleX, this.scaleY);
        }
    }

    private void setScale(double sx, double sy) {
        if (this.inSetting > 0) {
            return;
        }
        if (this.sourceImage == null) {
            return;
        }
        ++this.inSetting;
        this.isScale = true;
        this.scaleX = sx;
        this.scaleY = sy;
        this.scaledOffsetY = (int)(this.scaleY * (double)this.offsetY);
        this.scaledOffsetX = (int)(this.scaleX * (double)this.offsetX);
        this.scaleHeight = (int)(this.scaleY * (double)this.sourceHeight);
        this.scaleWidth = (int)(this.scaleX * (double)this.sourceWidth);
        this.scaledImage = ImageCache.getImageCache().getDerivatScale(this.sourceImage, this.scaleWidth, this.scaleHeight);
        this.setSize(new Dimension(this.scaleWidth, this.scaleHeight));
        this.setPreferredSize(new Dimension(this.scaleWidth, this.scaleHeight));
        this.repaint();
        this.scaleToFit = false;
        --this.inSetting;
    }

    public void setScale(int scale) {
        this.fixedScale = false;
        this.setScale((double)scale, (double)scale);
    }

    public void setScale(double scale) {
        this.fixedScale = false;
        this.setScale(scale, scale);
    }

    public void scaleToFit() {
        this.setScale(this.getWidth(), this.getHeight());
        this.scaleToFit = true;
    }

    public void setScale(int w, int h) {
        this.scaleToFit = false;
        this.isScale = true;
        this.fixedScale = true;
        this.scaleW = w;
        this.scaleH = h;
        this.scaleX = (double)w / (double)(this.sourceWidth + this.offsetX);
        this.scaleY = (double)h / (double)(this.sourceHeight + this.offsetY);
        if (this.inSetting > 0) {
            return;
        }
        if (this.sourceImage == null) {
            return;
        }
        ++this.inSetting;
        this.scaledOffsetY = (int)(this.scaleY * (double)this.offsetY);
        this.scaledOffsetX = (int)(this.scaleX * (double)this.offsetX);
        this.scaleHeight = (int)(this.scaleY * (double)this.sourceHeight);
        this.scaleWidth = (int)(this.scaleX * (double)this.sourceWidth);
        this.scaledImage = ImageCache.getImageCache().getDerivatScale(this.sourceImage, this.scaleWidth, this.scaleHeight);
        this.setSize(new Dimension(this.scaleWidth, this.scaleHeight));
        this.setPreferredSize(new Dimension(this.scaleWidth, this.scaleHeight));
        this.invalidate();
        this.validate();
        this.repaint();
        --this.inSetting;
    }

    public void unsetScale(int w, int h) {
        if (this.inSetting > 0) {
            return;
        }
        if (this.sourceImage == null) {
            return;
        }
        this.setScale(1.0);
        this.isScale = false;
        this.setSize(new Dimension(w, h));
        this.setPreferredSize(new Dimension(w, h));
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void unsetScale() {
        if (this.inSetting > 0) {
            return;
        }
        if (this.sourceImage == null) {
            return;
        }
        this.setScale(1.0);
        this.isScale = false;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    private void initComponents() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SingleImagePanel.this.formMouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                SingleImagePanel.this.formMouseDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SingleImagePanel.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SingleImagePanel.this.formMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SingleImagePanel.this.formMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SingleImagePanel.this.formMouseEntered(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SingleImagePanel.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseMoved(MouseEvent evt) {
        this.mX = evt.getX();
        this.mY = evt.getY();
        this.crossColor = Color.ORANGE;
        this.repaint();
        this.fireMouseMoved(evt);
    }

    void setGrid(boolean g) {
        this.displayGrid = g;
        this.repaint();
    }

    void setGrid(GridData g) {
        this.grid = g;
        this.repaint();
    }

    private void formMousePressed(MouseEvent evt) {
        if (this.noMouseReaction) {
            return;
        }
        this.shiftPressed = false;
        if (evt.getButton() == 1) {
            this.selectionSet = false;
            this.pressed = true;
            this.mXPressStart = evt.getX();
            this.mYPressStart = evt.getY();
            if (evt != null) {
                this.shiftPressed = (evt.getModifiers() & 1) == 1;
            }
        }
        this.fillRGBA(this.mXPressStart, this.mYPressStart);
        this.fireClicked(evt);
        this.crossColor = Color.GREEN;
        this.repaint();
    }

    public int getPressedStartX() {
        return this.mXPressStart;
    }

    public int getPressedStartY() {
        return this.mYPressStart;
    }

    private void formMouseReleased(MouseEvent evt) {
        if (this.noMouseReaction) {
            return;
        }
        if (evt.getButton() == 1) {
            this.pressed = false;
            this.draging = false;
        }
        this.crossColor = Color.ORANGE;
        this.repaint();
    }

    private void formMouseExited(MouseEvent evt) {
        if (this.noMouseReaction) {
            return;
        }
        this.pressed = false;
        this.noCross = true;
        this.repaint();
    }

    private void formMouseDragged(MouseEvent evt) {
        if (this.noMouseReaction) {
            return;
        }
        if (this.selectionLock) {
            this.mXPressStart = evt.getX();
            this.mYPressStart = evt.getY();
        }
        this.mX = evt.getX();
        this.mY = evt.getY();
        this.draging = true;
        this.crossColor = Color.GREEN;
        this.fireMouseMoved(evt);
        this.repaint();
    }

    private void formMouseEntered(MouseEvent evt) {
        if (this.noMouseReaction) {
            return;
        }
        if (evt.getButton() == 1) {
            this.pressed = true;
        }
        this.noCross = false;
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.scaleToFit) {
            this.scaleToFit();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        int clearWidth = this.scaleWidth;
        int clearHeight = this.scaleHeight;
        if (this.scaleWidth < this.getWidth()) {
            clearWidth = this.getWidth();
        }
        if (this.scaleHeight < this.getHeight()) {
            clearHeight = this.getHeight();
        }
        g.clearRect(0, 0, clearWidth, clearHeight);
        if (this.drawCheckers) {
            int SIZE = 10;
            boolean first = true;
            for (int y = 0; y < clearHeight; y += SIZE) {
                x = 0;
                while (x < clearWidth) {
                    if (first) {
                        g.setColor(Color.lightGray);
                        g.fillRect(x, y, SIZE, SIZE);
                        g.setColor(Color.GRAY);
                        g.fillRect(x += SIZE, y, SIZE, SIZE);
                        x += SIZE;
                        continue;
                    }
                    g.setColor(Color.GRAY);
                    g.fillRect(x, y, SIZE, SIZE);
                    g.setColor(Color.lightGray);
                    g.fillRect(x += SIZE, y, SIZE, SIZE);
                    x += SIZE;
                }
                first = !first;
            }
        }
        if (this.scaledImage != null) {
            g.drawImage(this.scaledImage, this.scaledOffsetX, this.scaledOffsetY, null);
        }
        Color c = g.getColor();
        if (!this.noCross && this.crossDrawn) {
            int x2 = (int)((double)((int)((double)this.mX / this.scaleX)) * this.scaleX);
            int y = (int)((double)((int)((double)this.mY / this.scaleY)) * this.scaleY);
            g.setColor(this.crossColor);
            g.drawLine(0, y, clearWidth, y);
            g.drawLine(x2, 0, x2, clearHeight);
        }
        if (this.displayGrid) {
            Color gridColor = Color.PINK;
            g.setColor(gridColor);
            for (int xc = 0; xc < this.grid.gridWidth; ++xc) {
                for (int yc = 0; yc < this.grid.gridHeight; ++yc) {
                    int x3 = this.grid.startX + xc * (this.grid.gapX + this.grid.singleWidth);
                    int y = this.grid.startY + yc * (this.grid.gapY + this.grid.singleHeight);
                    x3 = (int)((double)(x3 / 1) * this.scaleX);
                    y = (int)((double)(y / 1) * this.scaleY);
                    int w = this.grid.singleWidth;
                    int h = this.grid.singleHeight;
                    w = (int)((double)(w / 1) * this.scaleX);
                    h = (int)((double)(h / 1) * this.scaleY);
                    g.drawRect(x3, y, w, h);
                }
            }
        }
        if (this.displayDragSelection) {
            if (this.draging || this.selectionLock && this.pressed) {
                Color dragArea = new Color(0, 200, 0, 50);
                g.setColor(dragArea);
                x = (int)((double)((int)(((double)this.mXPressStart + this.scaleX / 2.0) / this.scaleX)) * this.scaleX);
                int y = (int)((double)((int)(((double)this.mYPressStart + this.scaleY / 2.0) / this.scaleY)) * this.scaleY);
                int w = (int)((double)((int)(((double)(this.mX - this.mXPressStart) + this.scaleX / 2.0) / this.scaleX)) * this.scaleX);
                int h = (int)((double)((int)(((double)(this.mY - this.mYPressStart) + this.scaleY / 2.0) / this.scaleY)) * this.scaleY);
                if (this.selectionLock) {
                    w = (int)((double)((int)(((double)this.selWidth + this.scaleX / 2.0) / this.scaleX)) * this.scaleX);
                    h = (int)((double)((int)(((double)this.selHeight + this.scaleY / 2.0) / this.scaleY)) * this.scaleY);
                    w = (int)((double)w * this.scaleX);
                    h = (int)((double)h * this.scaleY);
                }
                g.fillRect(x, y, w, h);
                if (!this.selectionLock) {
                    this.selWidth = (int)((double)w / this.scaleX);
                    this.selHeight = (int)((double)h / this.scaleY);
                }
            } else if (!this.selectionLock) {
                this.selWidth = 0;
                this.selHeight = 0;
            }
        }
        if (this.selX != -1) {
            g.setColor(Color.blue);
            g.drawRect((int)((double)this.selX * this.scaleX), (int)((double)this.selY * this.scaleY), (int)((double)this.selW * this.scaleX), (int)((double)this.selH * this.scaleY));
        }
        g.setColor(c);
    }

    public boolean isLocked() {
        return this.selectionLock;
    }

    public Dimension getSelectionLock() {
        if (!this.selectionLock) {
            return new Dimension(-1, -1);
        }
        return new Dimension(this.selWidth, this.selHeight);
    }

    public void setSelectionLock(boolean lock, int w, int h) {
        this.selectionLock = lock;
        this.selHeight = h;
        this.selWidth = w;
    }

    public BaseImageData getSelection(int x, int y, int w, int h) {
        BaseImageData tile = new BaseImageData();
        tile.fileName = this.orgName;
        tile.x = x;
        tile.y = y;
        tile.w = w;
        tile.h = h;
        if (tile.w < 0) {
            tile.w *= -1;
            tile.x -= tile.w;
        }
        if (tile.h < 0) {
            tile.h *= -1;
            tile.y -= tile.h;
        }
        if (tile.x < 0) {
            tile.x = 0;
        }
        if (tile.y < 0) {
            tile.y = 0;
        }
        if (tile.x + tile.w > this.sourceWidth) {
            tile.w = this.sourceWidth - tile.x;
        }
        if (tile.y + tile.h > this.sourceHeight) {
            tile.h = this.sourceHeight - tile.y;
        }
        tile.image = tile.w <= 0 || tile.h <= 0 || this.sourceImage == null ? null : this.sourceImage.getSubimage(tile.x, tile.y, tile.w, tile.h);
        tile.cx = 0;
        tile.cy = 0;
        tile.cw = w;
        tile.ch = h;
        return tile;
    }

    public void fillRGBA(int X, int Y) {
        if (this.sourceImage == null) {
            return;
        }
        int x = (int)((double)((int)(((double)X + this.scaleX / 2.0) / this.scaleX)) * this.scaleX);
        int y = (int)((double)((int)(((double)Y + this.scaleY / 2.0) / this.scaleY)) * this.scaleY);
        x = (int)((double)x / this.scaleX);
        y = (int)((double)y / this.scaleY);
        if (x >= this.sourceImage.getWidth()) {
            return;
        }
        if (y >= this.sourceImage.getHeight()) {
            return;
        }
        if (x < 0) {
            return;
        }
        if (y < 0) {
            return;
        }
        int rgba = this.sourceImage.getRGB(x, y);
        Color c = new Color(rgba);
        this.A = rgba >> 24 & 0xFF;
        this.R = c.getRed();
        this.G = c.getGreen();
        this.B = c.getBlue();
    }

    public void setSelection(int x, int y, int w, int h) {
        this.selX = x;
        this.selY = y;
        this.selW = w;
        this.selH = h;
        this.repaint();
    }

    public BaseImageData getSelection() {
        BaseImageData tile = new BaseImageData();
        tile.fileName = this.orgName;
        int x = (int)((double)((int)(((double)this.mXPressStart + this.scaleX / 2.0) / this.scaleX)) * this.scaleX);
        int y = (int)((double)((int)(((double)this.mYPressStart + this.scaleY / 2.0) / this.scaleY)) * this.scaleY);
        int w = (int)((double)((int)(((double)(this.mX - this.mXPressStart) + this.scaleX / 2.0) / this.scaleX)) * this.scaleX);
        int h = (int)((double)((int)(((double)(this.mY - this.mYPressStart) + this.scaleY / 2.0) / this.scaleY)) * this.scaleY);
        if (this.selectionLock) {
            w = (int)((double)((int)(((double)this.selWidth + this.scaleX / 2.0) / this.scaleX)) * this.scaleX);
            h = (int)((double)((int)(((double)this.selHeight + this.scaleY / 2.0) / this.scaleY)) * this.scaleY);
            w = (int)((double)w * this.scaleX);
            h = (int)((double)h * this.scaleY);
        }
        return this.getSelection((int)((double)x / this.scaleX), (int)((double)y / this.scaleY), (int)((double)w / this.scaleX), (int)((double)h / this.scaleY));
    }

    public void setBaseImage(BufferedImage image, int w, int h) {
        this.noCross = true;
        this.noMouseReaction = true;
        if (image == null) {
            this.sourceImage = null;
            return;
        }
        this.sourceImage = image;
        this.sourceWidth = this.sourceImage.getWidth();
        this.sourceHeight = this.sourceImage.getHeight();
        this.setScale(w, h);
        this.setVisible(true);
    }

    public void bakeScale() {
        this.setBaseImage(this.scaledImage);
    }

    public void setBaseImage(BufferedImage image) {
        this.noCross = true;
        this.noMouseReaction = true;
        if (image == null) {
            this.sourceImage = null;
            return;
        }
        this.sourceImage = image;
        this.sourceWidth = this.sourceImage.getWidth();
        this.sourceHeight = this.sourceImage.getHeight();
        this.unsetScale();
    }

    public int getR() {
        return this.R;
    }

    public int getG() {
        return this.G;
    }

    public int getB() {
        return this.B;
    }

    public int getA() {
        return this.A;
    }

    public void removeAllListeners() {
        this.mMovedListener.clear();
        this.mClickListener.clear();
    }

    public void addClickListener(MousePressedListener listener) {
        this.mClickListener.removeElement(listener);
        this.mClickListener.addElement(listener);
    }

    public void removeClickListener(MousePressedListener listener) {
        this.mClickListener.removeElement(listener);
    }

    public void addMouseMovedListener(MouseMovedListener listener) {
        this.mMovedListener.removeElement(listener);
        this.mMovedListener.addElement(listener);
    }

    public void removeMouseMovedListener(MouseMovedListener listener) {
        this.mMovedListener.removeElement(listener);
    }

    public void fireMouseMoved(MouseEvent evt) {
        EditMouseEvent e = new EditMouseEvent();
        e.evt = evt;
        e.dragging = this.draging;
        e.panel = this;
        for (int i = 0; i < this.mMovedListener.size(); ++i) {
            this.mMovedListener.elementAt(i).moved(e);
        }
    }

    public void fireClicked(MouseEvent evt) {
        EditMouseEvent e = new EditMouseEvent();
        e.evt = evt;
        e.panel = this;
        for (int i = 0; i < this.mClickListener.size(); ++i) {
            this.mClickListener.elementAt(i).pressed(e);
        }
    }

    public void unsetImage() {
        this.sourceImage = null;
        this.scaledImage = null;
        this.sourceHeight = 0;
        this.sourceWidth = 0;
        this.scaleHeight = 0;
        this.scaleWidth = 0;
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.inSetting = 0;
        this.crossColor = Color.ORANGE;
        this.mX = 0;
        this.mY = 0;
        this.mXPressStart = 0;
        this.mYPressStart = 0;
        this.pressed = false;
        this.noCross = true;
        this.draging = false;
        this.grid = new GridData();
        this.displayGrid = false;
        this.selWidth = 0;
        this.selHeight = 0;
        this.selectionLock = false;
        this.noMouseReaction = false;
        this.selectionSet = false;
        this.R = 0;
        this.G = 0;
        this.B = 0;
        this.A = 0;
        this.orgName = "";
        this.offsetX = 0;
        this.offsetY = 0;
        this.scaledOffsetX = 0;
        this.scaledOffsetY = 0;
        this.repaint();
    }

    public void setOffset(int x, int y, boolean ds) {
        this.doOffset = ds;
        if (this.doOffset) {
            this.offsetX = x;
            this.offsetY = y;
        } else {
            this.offsetX = 0;
            this.offsetY = 0;
        }
        this.correctScaleWithOffset();
        this.repaint();
    }
}

