/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.event.EditMouseEvent;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Matrix4x4;
import de.malban.graphics.SingleVectorPanel;
import de.malban.graphics.VectorColors;
import de.malban.graphics.Vertex;
import de.malban.gui.Scaler;
import de.malban.util.UtilityImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.GroupLayout;

public class SingleVector3dPanel
extends SingleVectorPanel {
    int inSetting = 0;
    boolean isOpaque = false;
    public boolean moveXAllowed = true;
    public boolean moveYAllowed = true;
    public boolean moveZAllowed = false;
    GFXVector xAxis = new GFXVector();
    GFXVector yAxis = new GFXVector();
    GFXVector zAxis = new GFXVector();
    boolean axisShown = false;
    boolean repaint = true;
    int axisXAngle = 0;
    int axisYAngle = 0;
    int axisZAngle = 0;
    int angleX = 0;
    int angleY = 0;
    int angleZ = 0;
    int transX = 0;
    int transY = 0;
    int transZ = 0;
    GFXVectorList lastDisplayList = new GFXVectorList();
    boolean singleRepaint = false;
    boolean oldSingleRepaint = false;
    BufferedImage[] paintBufferImage = new BufferedImage[2];
    int bufferUsed = -1;
    boolean noRepaint = false;
    boolean dumpMode = false;
    boolean gridx = true;
    boolean gridy = true;
    boolean gridz = false;

    public void setRepaint(boolean rp) {
        this.repaint = rp;
    }

    public void setAxisShown(boolean s) {
        this.axisShown = s;
        this.sharedRepaint();
    }

    public SingleVector3dPanel() {
        this.initComponents();
        this.xAxis.start.x(-2000.0);
        this.xAxis.end.x(2000.0);
        this.yAxis.start.y(-2000.0);
        this.yAxis.end.y(2000.0);
        this.zAxis.start.z(-2000.0);
        this.zAxis.end.z(2000.0);
    }

    @Override
    public void deinit() {
        this.setVisible(false);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 235, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 241, Short.MAX_VALUE));
    }

    public void setAxisAngleX(int value) {
        this.axisXAngle = value;
        this.sharedRepaint();
    }

    public void setAxisAngleY(int value) {
        this.axisYAngle = value;
        this.sharedRepaint();
    }

    public void setAxisAngleZ(int value) {
        this.axisZAngle = value;
        this.sharedRepaint();
    }

    public int getAxisAngleX() {
        return this.axisXAngle;
    }

    public int getAxisAngleY() {
        return this.axisYAngle;
    }

    public int getAxisAngleZ() {
        return this.axisZAngle;
    }

    public void setAngleX(int value) {
        this.angleX = value;
        this.sharedRepaint();
    }

    public void setAngleY(int value) {
        this.angleY = value;
        this.sharedRepaint();
    }

    public void setAngleZ(int value) {
        this.angleZ = value;
        this.sharedRepaint();
    }

    public void setTranslocationX(int x) {
        this.transX = x;
        this.sharedRepaint();
    }

    public void setTranslocationY(int y) {
        this.transY = y;
        this.sharedRepaint();
    }

    public void setTranslocationZ(int z) {
        this.transZ = z;
        this.sharedRepaint();
    }

    public GFXVectorList getDisplayVectorList() {
        return this.lastDisplayList;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.bufferUsed == -1) {
            return;
        }
        g.drawImage(this.paintBufferImage[this.bufferUsed], 0, 0, null);
    }

    @Override
    public void sharedRepaint() {
        if (this.singleRepaint) {
            return;
        }
        this.updateAndRepaint();
        super.sharedRepaint();
    }

    public void setSingleRepaint(boolean b) {
        this.singleRepaint = b;
    }

    public void disableSingleRepaint() {
        this.oldSingleRepaint = this.singleRepaint;
        this.singleRepaint = false;
    }

    public void enableSingleRepaint() {
        this.oldSingleRepaint = this.singleRepaint;
        this.singleRepaint = true;
    }

    public void restoreSingleRepaint() {
        this.singleRepaint = this.oldSingleRepaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateAndRepaint() {
        int usedzOff;
        if (this.noRepaint) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0) {
            return;
        }
        if (height == 0) {
            return;
        }
        int nextBuffer = (this.bufferUsed + 1) % 2;
        this.paintBufferImage[nextBuffer] = UtilityImage.getNewImage(width, height);
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        int n = usedzOff = this.usePrivateOffset ? this.zOffset : this.vars.zOffset;
        if (this.paintBufferImage[nextBuffer] == null) {
            return;
        }
        if (!this.repaint) {
            this.bufferUsed = nextBuffer;
            return;
        }
        this.x0Offset = this.getWidth() / 2;
        this.y0Offset = this.getHeight() / 2;
        Matrix4x4 trans = Matrix4x4.getTranslocation(this.transX, this.transY, this.transZ);
        Matrix4x4 rotx = Matrix4x4.getRotationX(Math.toRadians(this.angleX));
        Matrix4x4 roty = Matrix4x4.getRotationY(Math.toRadians(this.angleY));
        Matrix4x4 rotz = Matrix4x4.getRotationZ(Math.toRadians(this.angleZ));
        Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
        Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
        Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
        Graphics2D g = this.paintBufferImage[nextBuffer].createGraphics();
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            g.setColor(VectorColors.VECCI_BACKGROUND_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (!this.repaint) {
                return;
            }
            if (this.vars.drawByteFrame) {
                g.setColor(VectorColors.VECCI_FRAME_COLOR);
                Vertex vq1 = new Vertex(-128.0, -128.0, -128.0);
                Vertex vq2 = new Vertex(-128.0, -128.0, 127.0);
                Vertex vq3 = new Vertex(-128.0, 127.0, -128.0);
                Vertex vq4 = new Vertex(-128.0, 127.0, 127.0);
                Vertex vq5 = new Vertex(127.0, -128.0, -128.0);
                Vertex vq6 = new Vertex(127.0, -128.0, 127.0);
                Vertex vq7 = new Vertex(127.0, 127.0, -128.0);
                Vertex vq8 = new Vertex(127.0, 127.0, 127.0);
                int q = 0;
                GFXVector[] qube = new GFXVector[12];
                qube[q++] = new GFXVector(vq1, vq5);
                qube[q++] = new GFXVector(vq1, vq3);
                qube[q++] = new GFXVector(vq1, vq2);
                qube[q++] = new GFXVector(vq8, vq4);
                qube[q++] = new GFXVector(vq8, vq6);
                qube[q++] = new GFXVector(vq8, vq7);
                qube[q++] = new GFXVector(vq7, vq5);
                qube[q++] = new GFXVector(vq7, vq3);
                qube[q++] = new GFXVector(vq4, vq3);
                qube[q++] = new GFXVector(vq4, vq2);
                qube[q++] = new GFXVector(vq6, vq2);
                qube[q++] = new GFXVector(vq6, vq5);
                for (q = 0; q < 12; ++q) {
                    qube[q].start.x(qube[q].start.x() + (double)usedxOff);
                    qube[q].start.y(qube[q].start.y() - (double)usedyOff);
                    qube[q].start.z(qube[q].start.z() + (double)usedzOff);
                    qube[q].end.x(qube[q].end.x() + (double)usedxOff);
                    qube[q].end.y(qube[q].end.y() - (double)usedyOff);
                    qube[q].end.z(qube[q].end.z() + (double)usedzOff);
                    qube[q].start = rotax.multiply(qube[q].start);
                    qube[q].start = rotay.multiply(qube[q].start);
                    qube[q].start = rotaz.multiply(qube[q].start);
                    qube[q].end = rotax.multiply(qube[q].end);
                    qube[q].end = rotay.multiply(qube[q].end);
                    qube[q].end = rotaz.multiply(qube[q].end);
                    int x0 = Scaler.scaleDoubleToInt(qube[q].start.x(), this.scale);
                    int y0 = -Scaler.scaleDoubleToInt(qube[q].start.y(), this.scale);
                    int x1 = Scaler.scaleDoubleToInt(qube[q].end.x(), this.scale);
                    int y1 = -Scaler.scaleDoubleToInt(qube[q].end.y(), this.scale);
                    x0 = this.x0Offset + x0;
                    y0 = this.y0Offset + y0;
                    x1 = this.x0Offset + x1;
                    y1 = this.y0Offset + y1;
                    g.drawLine(x0, y0, x1, y1);
                }
            }
            if (this.axisShown) {
                GFXVector xAxisClone = this.xAxis.clone();
                GFXVector yAxisClone = this.yAxis.clone();
                GFXVector zAxisClone = this.zAxis.clone();
                xAxisClone.start.x(xAxisClone.start.x() + (double)usedxOff);
                xAxisClone.end.x(xAxisClone.end.x() + (double)usedxOff);
                xAxisClone.start.y(xAxisClone.start.y() - (double)usedyOff);
                xAxisClone.end.y(xAxisClone.end.y() - (double)usedyOff);
                xAxisClone.start.z(xAxisClone.start.z() + (double)usedzOff);
                xAxisClone.end.z(xAxisClone.end.z() + (double)usedzOff);
                yAxisClone.start.x(yAxisClone.start.x() + (double)usedxOff);
                yAxisClone.end.x(yAxisClone.end.x() + (double)usedxOff);
                yAxisClone.start.y(yAxisClone.start.y() - (double)usedyOff);
                yAxisClone.end.y(yAxisClone.end.y() - (double)usedyOff);
                yAxisClone.start.z(yAxisClone.start.z() + (double)usedzOff);
                yAxisClone.end.z(yAxisClone.end.z() + (double)usedzOff);
                zAxisClone.start.x(zAxisClone.start.x() + (double)usedxOff);
                zAxisClone.end.x(zAxisClone.end.x() + (double)usedxOff);
                zAxisClone.start.y(zAxisClone.start.y() - (double)usedyOff);
                zAxisClone.end.y(zAxisClone.end.y() - (double)usedyOff);
                zAxisClone.start.z(zAxisClone.start.z() + (double)usedzOff);
                zAxisClone.end.z(zAxisClone.end.z() + (double)usedzOff);
                GFXVector ax = rotax.multiply(xAxisClone);
                ax = rotay.multiply(ax);
                ax = rotaz.multiply(ax);
                Object ay = rotax.multiply(yAxisClone);
                ay = rotay.multiply((GFXVector)ay);
                ay = rotaz.multiply((GFXVector)ay);
                GFXVector az = rotax.multiply(zAxisClone);
                az = rotay.multiply(az);
                az = rotaz.multiply(az);
                g.setColor(VectorColors.VECCI_X_AXIS_COLOR);
                double x0 = Scaler.scaleDoubleToInt(ax.start.x(), this.scale);
                double y0 = -Scaler.scaleDoubleToInt(ax.start.y(), this.scale);
                double x1 = Scaler.scaleDoubleToInt(ax.end.x(), this.scale);
                double y1 = -Scaler.scaleDoubleToInt(ax.end.y(), this.scale);
                g.drawLine((int)(x0 + (double)this.x0Offset), (int)(y0 + (double)this.y0Offset), (int)(x1 + (double)this.x0Offset), (int)(y1 + (double)this.y0Offset));
                g.setColor(VectorColors.VECCI_Y_AXIS_COLOR);
                x0 = Scaler.scaleDoubleToInt(((GFXVector)ay).start.x(), this.scale);
                y0 = -Scaler.scaleDoubleToInt(((GFXVector)ay).start.y(), this.scale);
                x1 = Scaler.scaleDoubleToInt(((GFXVector)ay).end.x(), this.scale);
                y1 = -Scaler.scaleDoubleToInt(((GFXVector)ay).end.y(), this.scale);
                g.drawLine((int)(x0 + (double)this.x0Offset), (int)(y0 + (double)this.y0Offset), (int)(x1 + (double)this.x0Offset), (int)(y1 + (double)this.y0Offset));
                g.setColor(VectorColors.VECCI_Z_AXIS_COLOR);
                x0 = Scaler.scaleDoubleToInt(az.start.x(), this.scale);
                y0 = -Scaler.scaleDoubleToInt(az.start.y(), this.scale);
                x1 = Scaler.scaleDoubleToInt(az.end.x(), this.scale);
                y1 = -Scaler.scaleDoubleToInt(az.end.y(), this.scale);
                g.drawLine((int)(x0 + (double)this.x0Offset), (int)(y0 + (double)this.y0Offset), (int)(x1 + (double)this.x0Offset), (int)(y1 + (double)this.y0Offset));
            }
            this.drawGrid(g);
            Color c = g.getColor();
            int pos = 0;
            this.lastDisplayList = this.vars.foregroundVectors.clone();
            int count = 0;
            HashMap<Vertex, Vertex> noDouble = new HashMap<Vertex, Vertex>();
            for (GFXVector v : this.lastDisplayList.list) {
                Vertex p1 = v.start;
                Vertex p2 = v.end;
                if (noDouble.get(p1) == null) {
                    noDouble.put(p1, p1);
                    p1.x(p1.x() + (double)usedxOff);
                    p1.y(p1.y() - (double)usedyOff);
                    p1.z(p1.z() + (double)usedzOff);
                    p1 = trans.multiply(p1);
                    p1 = rotx.multiply(p1);
                    p1 = roty.multiply(p1);
                    p1 = rotz.multiply(p1);
                    p1 = rotax.multiply(p1);
                    p1 = rotay.multiply(p1);
                    p1 = rotaz.multiply(p1);
                    v.start.set(p1);
                }
                if (noDouble.get(p2) == null) {
                    noDouble.put(p2, p2);
                    p2.x(p2.x() + (double)usedxOff);
                    p2.y(p2.y() - (double)usedyOff);
                    p2.z(p2.z() + (double)usedzOff);
                    p2 = trans.multiply(p2);
                    p2 = rotx.multiply(p2);
                    p2 = roty.multiply(p2);
                    p2 = rotz.multiply(p2);
                    p2 = rotax.multiply(p2);
                    p2 = rotay.multiply(p2);
                    p2 = rotaz.multiply(p2);
                    v.end.set(p2);
                }
                double x0 = Scaler.scaleDoubleToInt(p1.x(), this.scale);
                double y0 = -Scaler.scaleDoubleToInt(p1.y(), this.scale);
                double x1 = Scaler.scaleDoubleToInt(p2.x(), this.scale);
                double y1 = -Scaler.scaleDoubleToInt(p2.y(), this.scale);
                double x0v = (double)this.x0Offset + x0;
                double y0v = (double)this.y0Offset + y0;
                double x1v = (double)this.x0Offset + x1;
                double y1v = (double)this.y0Offset + y1;
                if (v.a > 255 || v.a < 0) {
                    v.a = 127;
                }
                g.setColor(new Color(v.r, v.g, v.b, v.a));
                if (v.highlight) {
                    g.setColor(VectorColors.VECCI_VECTOR_HIGHLIGHT_COLOR);
                }
                if (v.selected) {
                    g.setColor(VectorColors.VECCI_VECTOR_SELECTED_COLOR);
                }
                if (v.pattern != 255) {
                    if (v.pattern == 0 && this.vars.drawMoves) {
                        g.setColor(VectorColors.VECCI_MOVE_COLOR);
                        if (this.vars.drawArrows) {
                            this.drawArrow(g, (int)x0v, (int)y0v, (int)x1v, (int)y1v);
                        } else {
                            g.drawLine((int)x0v, (int)y0v, (int)x1v, (int)y1v);
                        }
                    } else {
                        float[] pattern = this.getPattern(v);
                        BasicStroke dashed = new BasicStroke(0.0f, 0, 2, 1.0f, pattern, 0.0f);
                        Graphics2D g2 = g;
                        Stroke saveStroke = g2.getStroke();
                        g2.setStroke(dashed);
                        g2.drawLine((int)x0v, (int)y0v, (int)x1v, (int)y1v);
                        g2.setStroke(saveStroke);
                    }
                } else if (this.vars.drawArrows) {
                    this.drawArrow(g, (int)x0v, (int)y0v, (int)x1v, (int)y1v);
                } else {
                    g.drawLine((int)x0v, (int)y0v, (int)x1v, (int)y1v);
                }
                if (this.vars.drawPositions) {
                    g.setColor(VectorColors.VECCI_POS_COLOR);
                    int xx = (int)x0v + (int)(x1v - x0v) / 2;
                    int yy = (int)y0v + (int)(y1v - y0v) / 2;
                    g.drawString("" + pos, xx, yy);
                }
                if (v.start.highlight) {
                    g.setColor(VectorColors.VECCI_POINT_HIGHLIGHT_COLOR);
                    g.fillRect((int)x0v, (int)y0v, 3, 3);
                }
                if (v.end.highlight) {
                    g.setColor(VectorColors.VECCI_POINT_HIGHLIGHT_COLOR);
                    g.fillRect((int)x1v, (int)y1v, 3, 3);
                }
                if (v.start.selected) {
                    g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                    g.fillRect((int)x0v, (int)y0v, 3, 3);
                }
                if (v.end.selected) {
                    g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                    g.fillRect((int)x1v, (int)y1v, 3, 3);
                }
                ++count;
                ++pos;
            }
            if (!this.dumpMode) {
                this.lastDisplayList.setRelativeWherePossible();
            }
            if (this.vars.hightLightVPoint != null && this.vars.hightLightVPoint.highlight) {
                Vertex s = new Vertex(this.vars.hightLightVPoint);
                s.x(s.x() + (double)usedxOff);
                s.y(s.y() - (double)usedyOff);
                s.z(s.z() + (double)usedzOff);
                s = rotax.multiply(s);
                s = rotay.multiply(s);
                s = rotaz.multiply(s);
                double x0 = Scaler.scaleDoubleToInt(s.x(), this.scale);
                double y0 = -Scaler.scaleDoubleToInt(s.y(), this.scale);
                x0 = (double)this.x0Offset + x0;
                y0 = (double)this.y0Offset + y0;
                g.setColor(VectorColors.VECCI_POINT_HIGHLIGHT_COLOR);
                g.drawOval((int)x0 - this.vars.POINT_HIGHLIGHT_RADIUS, (int)y0 - this.vars.POINT_HIGHLIGHT_RADIUS, this.vars.POINT_HIGHLIGHT_RADIUS * 2, this.vars.POINT_HIGHLIGHT_RADIUS * 2);
            }
            if (this.vars.hightLightVector != null && this.vars.hightLightVector.highlight) {
                GFXVector clone = this.vars.hightLightVector.clone();
                clone.start.x(clone.start.x() + (double)usedxOff);
                clone.start.y(clone.start.y() - (double)usedyOff);
                clone.start.z(clone.start.z() + (double)usedzOff);
                clone.end.x(clone.end.x() + (double)usedxOff);
                clone.end.y(clone.end.y() - (double)usedyOff);
                clone.end.z(clone.end.z() + (double)usedzOff);
                clone.start = rotax.multiply(clone.start);
                clone.start = rotay.multiply(clone.start);
                clone.start = rotaz.multiply(clone.start);
                clone.end = rotax.multiply(clone.end);
                clone.end = rotay.multiply(clone.end);
                clone.end = rotaz.multiply(clone.end);
                double x0 = Scaler.scaleDoubleToInt(clone.start.x(), this.scale);
                double y0 = -Scaler.scaleDoubleToInt(clone.start.y(), this.scale);
                double x1 = Scaler.scaleDoubleToInt(clone.end.x(), this.scale);
                double y1 = -Scaler.scaleDoubleToInt(clone.end.y(), this.scale);
                x0 = (double)this.x0Offset + x0;
                y0 = (double)this.y0Offset + y0;
                x1 = (double)this.x0Offset + x1;
                y1 = (double)this.y0Offset + y1;
                g.setColor(VectorColors.VECCI_VECTOR_HIGHLIGHT_COLOR);
                double py = x0 - x1;
                double px = -(y0 - y1);
                double l = Math.sqrt(Math.pow(py, 2.0) + Math.pow(px, 2.0));
                double transition = this.vars.VECTOR_HIGHLIGHT_RADIUS;
                double px0 = x0 + transition / l * px;
                double py0 = y0 + transition / l * py;
                double px1 = x1 + transition / l * px;
                double py1 = y1 + transition / l * py;
                double transition2 = -this.vars.VECTOR_HIGHLIGHT_RADIUS;
                double px02 = x0 + transition2 / l * px;
                double py02 = y0 + transition2 / l * py;
                double px12 = x1 + transition2 / l * px;
                double py12 = y1 + transition2 / l * py;
                g.drawLine((int)px0, (int)py0, (int)px1, (int)py1);
                g.drawLine((int)px02, (int)py02, (int)px12, (int)py12);
                g.drawLine((int)px0, (int)py0, (int)px02, (int)py02);
                g.drawLine((int)px1, (int)py1, (int)px12, (int)py12);
            }
            ArrayList<GFXVector> arrayList2 = this.vars.foregroundVectors.list;
            synchronized (arrayList2) {
                for (GFXVector v : this.vars.foregroundVectors.list) {
                    double y0;
                    double x0;
                    if (v.selected) {
                        GFXVector clone = v.clone();
                        clone.start.x(clone.start.x() + (double)usedxOff);
                        clone.start.y(clone.start.y() - (double)usedyOff);
                        clone.start.z(clone.start.z() + (double)usedzOff);
                        clone.end.x(clone.end.x() + (double)usedxOff);
                        clone.end.y(clone.end.y() - (double)usedyOff);
                        clone.end.z(clone.end.z() + (double)usedzOff);
                        clone.start = rotax.multiply(clone.start);
                        clone.start = rotay.multiply(clone.start);
                        clone.start = rotaz.multiply(clone.start);
                        clone.end = rotax.multiply(clone.end);
                        clone.end = rotay.multiply(clone.end);
                        clone.end = rotaz.multiply(clone.end);
                        x0 = Scaler.scaleDoubleToInt(clone.start.x(), this.scale);
                        y0 = -Scaler.scaleDoubleToInt(clone.start.y(), this.scale);
                        double x1 = Scaler.scaleDoubleToInt(clone.end.x(), this.scale);
                        double y1 = -Scaler.scaleDoubleToInt(clone.end.y(), this.scale);
                        x0 = (double)this.x0Offset + x0;
                        y0 = (double)this.y0Offset + y0;
                        x1 = (double)this.x0Offset + x1;
                        y1 = (double)this.y0Offset + y1;
                        g.setColor(VectorColors.VECCI_VECTOR_SELECTED_COLOR);
                        double py = x0 - x1;
                        double px = -(y0 - y1);
                        double l = Math.sqrt(Math.pow(py, 2.0) + Math.pow(px, 2.0));
                        double transition = this.vars.VECTOR_SELECTED_RADIUS;
                        double px0 = x0 + transition / l * px;
                        double py0 = y0 + transition / l * py;
                        double px1 = x1 + transition / l * px;
                        double py1 = y1 + transition / l * py;
                        double transition2 = -this.vars.VECTOR_SELECTED_RADIUS;
                        double px02 = x0 + transition2 / l * px;
                        double py02 = y0 + transition2 / l * py;
                        double px12 = x1 + transition2 / l * px;
                        double py12 = y1 + transition2 / l * py;
                        g.drawLine((int)px0, (int)py0, (int)px1, (int)py1);
                        g.drawLine((int)px02, (int)py02, (int)px12, (int)py12);
                        g.drawLine((int)px0, (int)py0, (int)px02, (int)py02);
                        g.drawLine((int)px1, (int)py1, (int)px12, (int)py12);
                    }
                    Vertex s = new Vertex(v.start);
                    if (s.selected) {
                        s.x(s.x() + (double)usedxOff);
                        s.y(s.y() - (double)usedyOff);
                        s.z(s.z() + (double)usedzOff);
                        s = rotax.multiply(s);
                        s = rotay.multiply(s);
                        s = rotaz.multiply(s);
                        x0 = Scaler.scaleDoubleToInt(s.x(), this.scale);
                        y0 = -Scaler.scaleDoubleToInt(s.y(), this.scale);
                        x0 = (double)this.x0Offset + x0;
                        y0 = (double)this.y0Offset + y0;
                        g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                        g.drawOval((int)x0 - this.vars.POINT_SELECTED_RADIUS, (int)y0 - this.vars.POINT_SELECTED_RADIUS, this.vars.POINT_SELECTED_RADIUS * 2, this.vars.POINT_SELECTED_RADIUS * 2);
                    }
                    s = new Vertex(v.end);
                    if (!s.selected) continue;
                    s.x(s.x() + (double)usedxOff);
                    s.y(s.y() - (double)usedyOff);
                    s.z(s.z() + (double)usedzOff);
                    s = rotax.multiply(s);
                    s = rotay.multiply(s);
                    s = rotaz.multiply(s);
                    x0 = Scaler.scaleDoubleToInt(s.x(), this.scale);
                    y0 = -Scaler.scaleDoubleToInt(s.y(), this.scale);
                    x0 = (double)this.x0Offset + x0;
                    y0 = (double)this.y0Offset + y0;
                    g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                    g.drawOval((int)x0 - this.vars.POINT_SELECTED_RADIUS, (int)y0 - this.vars.POINT_SELECTED_RADIUS, this.vars.POINT_SELECTED_RADIUS * 2, this.vars.POINT_SELECTED_RADIUS * 2);
                }
            }
            g.setColor(c);
        }
        this.bufferUsed = nextBuffer;
        super.repaint();
    }

    @Override
    public void repaint() {
        this.updateAndRepaint();
    }

    public void suspendRepaint() {
        this.noRepaint = true;
    }

    public void continueRepaint() {
        this.noRepaint = false;
        this.repaint();
    }

    public void setDumpMode(boolean dp) {
        this.dumpMode = dp;
    }

    public void setGridx(boolean b) {
        this.gridx = b;
        this.repaint();
    }

    public void setGridy(boolean b) {
        this.gridy = b;
        this.repaint();
    }

    public void setGridz(boolean b) {
        this.gridz = b;
        this.repaint();
    }

    void drawGrid(Graphics2D g) {
        Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
        Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
        Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
        GFXVector dot = new GFXVector();
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        int usedzOff = this.usePrivateOffset ? this.zOffset : this.vars.zOffset;
        g.setColor(VectorColors.VECCI_GRID_COLOR);
        double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
        int minx = (int)Scaler.unscaleDoubleToDouble(this.x0Offset, scaleUse);
        int miny = (int)Scaler.unscaleDoubleToDouble(this.y0Offset, scaleUse);
        int minz = minx;
        int gwidth = this.vars.gridWidth;
        if (!this.vars.displayGrid) {
            gwidth = 1;
        }
        if (!this.gridx) {
            minx = gwidth;
        }
        if (!this.gridy) {
            miny = gwidth;
        }
        if (!this.gridz) {
            minz = gwidth;
        }
        if (minx < gwidth) {
            minx = gwidth;
        }
        if (miny < gwidth) {
            miny = gwidth;
        }
        if (minz < gwidth) {
            minz = gwidth;
        }
        long max = minx / gwidth * (miny / gwidth) * (minz / gwidth);
        if (minx != 1) {
            max *= 2L;
        }
        if (miny != 1) {
            max *= 2L;
        }
        if (minz != 1) {
            max *= 2L;
        }
        if (max > 10000L) {
            return;
        }
        if (max < 0L) {
            return;
        }
        if (!this.gridx) {
            minx = 1;
        }
        if (!this.gridy) {
            miny = 1;
        }
        if (!this.gridz) {
            minz = 1;
        }
        for (int x = -(minx / gwidth) * gwidth; x <= minx; x += gwidth) {
            if (minx == 1) {
                x = 0;
            }
            for (int y = -(miny / gwidth) * gwidth; y <= miny; y += gwidth) {
                if (miny == 1) {
                    y = 0;
                }
                for (int z = -(minz / gwidth) * gwidth; z <= minz; z += gwidth) {
                    if (minz == 1) {
                        z = 0;
                    }
                    dot.start.x(x + usedxOff);
                    dot.start.y(y - usedyOff);
                    dot.start.z(z + usedzOff);
                    dot.end = dot.start;
                    dot.start = rotax.multiplyVariant(dot.start);
                    dot.start = rotay.multiplyVariant(dot.start);
                    dot.start = rotaz.multiplyVariant(dot.start);
                    double printx = Scaler.unscaleDoubleToDouble(this.x0Offset, scaleUse) + dot.start.x();
                    double printy = Scaler.unscaleDoubleToDouble(this.y0Offset, scaleUse) - dot.start.y();
                    printx = Scaler.scaleDoubleToInt(printx, scaleUse);
                    printy = Scaler.scaleDoubleToInt(printy, scaleUse);
                    g.drawLine((int)printx, (int)printy, (int)printx, (int)printy);
                    if (minz != 1) continue;
                    z += 1000000;
                }
                if (miny != 1) continue;
                y += 1000000;
            }
            if (minx != 1) continue;
            x += 1000000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMouseMovedEvent(MouseEvent evt) {
        double y0;
        GFXVector clone;
        ArrayList<GFXVector> arrayList;
        double distance;
        this.mX = evt.getX();
        this.mY = evt.getY();
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        int usedzOff = this.usePrivateOffset ? this.zOffset : this.vars.zOffset;
        this.vars.crossColor = VectorColors.VECCI_CROSS_COLOR;
        Matrix4x4 trans = Matrix4x4.getTranslocation(this.transX, this.transY, this.transZ);
        Matrix4x4 rotx = Matrix4x4.getRotationX(Math.toRadians(this.angleX));
        Matrix4x4 roty = Matrix4x4.getRotationY(Math.toRadians(this.angleY));
        Matrix4x4 rotz = Matrix4x4.getRotationZ(Math.toRadians(this.angleZ));
        Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
        Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
        Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
        if (this.vars.workingMode == 2) {
            distance = Double.MAX_VALUE;
            if (this.vars.hightLightVPoint != null) {
                this.vars.hightLightVPoint.highlight = false;
                this.vars.hightLightVPoint = null;
            }
            arrayList = this.vars.foregroundVectors.list;
            synchronized (arrayList) {
                for (GFXVector v : this.vars.foregroundVectors.list) {
                    clone = v.clone();
                    clone.start.x(clone.start.x() + (double)usedxOff);
                    clone.start.y(clone.start.y() - (double)usedyOff);
                    clone.start.z(clone.start.z() + (double)usedzOff);
                    clone.end.x(clone.end.x() + (double)usedxOff);
                    clone.end.y(clone.end.y() - (double)usedyOff);
                    clone.end.z(clone.end.z() + (double)usedzOff);
                    clone.start = rotax.multiplyVariant(clone.start);
                    clone.start = rotay.multiplyVariant(clone.start);
                    clone.start = rotaz.multiplyVariant(clone.start);
                    clone.end = rotax.multiplyVariant(clone.end);
                    clone.end = rotay.multiplyVariant(clone.end);
                    clone.end = rotaz.multiplyVariant(clone.end);
                    Vertex p1 = clone.start;
                    Vertex p2 = clone.end;
                    double x0 = Scaler.scaleDoubleToInt(p1.x(), this.scale);
                    y0 = -Scaler.scaleDoubleToInt(p1.y(), this.scale);
                    double x1 = Scaler.scaleDoubleToInt(p2.x(), this.scale);
                    double y1 = -Scaler.scaleDoubleToInt(p2.y(), this.scale);
                    x0 = (double)this.x0Offset + x0;
                    y0 = (double)this.y0Offset + y0;
                    x1 = (double)this.x0Offset + x1;
                    y1 = (double)this.y0Offset + y1;
                    v.start.highlight = false;
                    v.end.highlight = false;
                    double d = Math.sqrt(((double)this.mX - x0) * ((double)this.mX - x0) + ((double)this.mY - y0) * ((double)this.mY - y0));
                    if (d < distance) {
                        distance = d;
                        this.vars.hightLightVPoint = v.start;
                    }
                    if ((d = Math.sqrt(((double)this.mX - x1) * ((double)this.mX - x1) + ((double)this.mY - y1) * ((double)this.mY - y1))) < distance) {
                        distance = d;
                        this.vars.hightLightVPoint = v.end;
                    }
                    if (distance != 0.0) continue;
                    break;
                }
            }
            if (this.vars.hightLightVPoint != null) {
                if (distance <= (double)this.vars.POINT_HIGHLIGHT_RANGE) {
                    this.vars.hightLightVPoint.highlight = true;
                } else {
                    this.vars.hightLightVPoint = null;
                }
            }
        }
        if (this.vars.workingMode == 1) {
            distance = Double.MAX_VALUE;
            if (this.vars.hightLightVector != null) {
                this.vars.hightLightVector.highlight = false;
                this.vars.hightLightVector = null;
            }
            arrayList = this.vars.foregroundVectors.list;
            synchronized (arrayList) {
                for (GFXVector v : this.vars.foregroundVectors.list) {
                    clone = v.clone();
                    Vertex p1 = clone.start;
                    Vertex p2 = clone.end;
                    p1.x(p1.x() + (double)usedxOff);
                    p1.y(p1.y() - (double)usedyOff);
                    p1.z(p1.z() + (double)usedzOff);
                    p1 = trans.multiply(p1);
                    p1 = rotx.multiply(p1);
                    p1 = roty.multiply(p1);
                    p1 = rotz.multiply(p1);
                    p1 = rotax.multiply(p1);
                    p1 = rotay.multiply(p1);
                    p1 = rotaz.multiply(p1);
                    p1.coords[0] = Math.round(p1.coords[0]);
                    p1.coords[1] = Math.round(p1.coords[1]);
                    p1.coords[2] = Math.round(p1.coords[2]);
                    p2.x(p2.x() + (double)usedxOff);
                    p2.y(p2.y() - (double)usedyOff);
                    p2.z(p2.z() + (double)usedzOff);
                    p2 = trans.multiply(p2);
                    p2 = rotx.multiply(p2);
                    p2 = roty.multiply(p2);
                    p2 = rotz.multiply(p2);
                    p2 = rotax.multiply(p2);
                    p2 = rotay.multiply(p2);
                    p2 = rotaz.multiply(p2);
                    p2.coords[0] = Math.round(p2.coords[0]);
                    p2.coords[1] = Math.round(p2.coords[1]);
                    p2.coords[2] = Math.round(p2.coords[2]);
                    double x0 = Scaler.scaleDoubleToInt(p1.x(), this.scale);
                    y0 = -Scaler.scaleDoubleToInt(p1.y(), this.scale);
                    double x1 = Scaler.scaleDoubleToInt(p2.x(), this.scale);
                    double y1 = -Scaler.scaleDoubleToInt(p2.y(), this.scale);
                    x0 = (double)this.x0Offset + x0;
                    y0 = (double)this.y0Offset + y0;
                    x1 = (double)this.x0Offset + x1;
                    y1 = (double)this.y0Offset + y1;
                    v.highlight = false;
                    double d = SingleVector3dPanel.getDistancePointToVector(this.mX, this.mY, x0, y0, x1, y1);
                    if (d < distance) {
                        distance = d;
                        this.vars.hightLightVector = v;
                    }
                    if (distance != 0.0) continue;
                    break;
                }
            }
            if (this.vars.hightLightVector != null) {
                if (distance <= (double)this.vars.VECTOR_HIGHLIGHT_RANGE) {
                    this.vars.hightLightVector.highlight = true;
                } else {
                    this.vars.hightLightVector = null;
                }
            }
        }
        this.sharedRepaint();
        this.fireMouseMoved(evt);
    }

    @Override
    protected void handleMousePressed(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        if (evt.getButton() == 1) {
            if (this.vars.continueMode) {
                this.vars.pressed = true;
                return;
            }
            this.vars.shiftPressed = false;
            this.vars.ctrlPressed = false;
            this.vars.pressed = true;
            this.mXPressStart = evt.getX();
            this.mYPressStart = evt.getY();
            double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
            Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
            Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
            Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
            rotax.transpose();
            rotay.transpose();
            rotaz.transpose();
            Vertex start = new Vertex(this.mXPressStart - this.x0Offset, -(this.mYPressStart - this.y0Offset), 0.0);
            start = rotax.multiply(start);
            start = rotay.multiply(start);
            start = rotaz.multiply(start);
            double xStart = Scaler.unscaleDoubleToDouble(start.x(), scaleUse);
            double yStart = Scaler.unscaleDoubleToDouble(start.y(), scaleUse);
            double zStart = Scaler.unscaleDoubleToDouble(start.z(), scaleUse);
            if (this.isGrid()) {
                this.mDragOriginX = this.lastCrossX = (int)((double)((int)(xStart / (double)this.vars.gridWidth + 0.5)) * (double)this.vars.gridWidth);
                this.mDragOriginY = this.lastCrossY = (int)((double)((int)(yStart / (double)this.vars.gridWidth + 0.5)) * (double)this.vars.gridWidth);
                this.mDragOriginZ = this.lastCrossZ = (int)((double)((int)(zStart / (double)this.vars.gridWidth + 0.5)) * (double)this.vars.gridWidth);
            } else {
                this.mDragOriginX = this.lastCrossX = (int)xStart;
                this.mDragOriginY = this.lastCrossY = (int)yStart;
                this.mDragOriginZ = this.lastCrossZ = (int)zStart;
            }
            this.vars.shiftPressed = (evt.getModifiers() & 1) == 1;
            this.vars.ctrlPressed = (evt.getModifiers() & 2) == 2;
        }
        this.fireMousePressed(evt);
        this.vars.crossColor = VectorColors.VECCI_CROSS_DRAG_COLOR;
        this.sharedRepaint();
    }

    @Override
    protected void handleMouseDraggedEvent(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        this.mX = evt.getX();
        this.mY = evt.getY();
        int x = this.mXPressStart;
        int y = this.mYPressStart;
        int w = this.mX - this.mXPressStart;
        int h = this.mY - this.mYPressStart;
        Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
        Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
        Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
        rotax.transpose();
        rotay.transpose();
        rotaz.transpose();
        if (this.vars.pressed && this.vars.ctrlPressed) {
            this.vars.dragging = true;
            double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
            Vertex start = new Vertex(0.0, 0.0, 0.0);
            Vertex end2 = new Vertex(w, -h, 0.0);
            start = rotaz.multiply(start);
            start = rotay.multiply(start);
            start = rotax.multiply(start);
            end2 = rotaz.multiply(end2);
            end2 = rotay.multiply(end2);
            end2 = rotax.multiply(end2);
            double xStart = Scaler.unscaleDoubleToDouble(start.x(), scaleUse);
            double yStart = Scaler.unscaleDoubleToDouble(start.y(), scaleUse);
            double zStart = Scaler.unscaleDoubleToDouble(start.z(), scaleUse);
            double xEnd = Scaler.unscaleDoubleToDouble(end2.x(), scaleUse);
            double yEnd = Scaler.unscaleDoubleToDouble(end2.y(), scaleUse);
            double zEnd = Scaler.unscaleDoubleToDouble(end2.z(), scaleUse);
            this.addXOffset((int)(xEnd - xStart));
            this.addYOffset((int)(-(yEnd - yStart)));
            this.addZOffset((int)(zEnd - zStart));
            this.mXPressStart = this.mX;
            this.mYPressStart = this.mY;
            this.sharedRepaint();
            this.fireMouseMoved(evt);
            return;
        }
        if (!this.vars.continueMode) {
            if (this.vars.pressed) {
                this.vars.dragging = true;
            }
            this.vars.crossColor = VectorColors.VECCI_CROSS_DRAG_COLOR;
        }
        if (!this.vars.displayDragSelection || this.vars.workingMode != 2 && this.vars.workingMode != 1 || this.vars.dragging || this.vars.pressed) {
            // empty if block
        }
        this.sharedRepaint();
        if (this.vars.pressed) {
            this.fireMouseMoved(evt);
        }
    }

    protected void handleMouseDraggedEventNew(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        int usedzOff = this.usePrivateOffset ? this.zOffset : this.vars.zOffset;
        Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
        Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
        Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
        Vertex p1x = new Vertex(1.0, 0.0, 0.0);
        Vertex p1y = new Vertex(0.0, 1.0, 0.0);
        Vertex p1z = new Vertex(0.0, 0.0, 1.0);
        p1x.x(p1x.x() + (double)usedxOff);
        p1x.y(p1x.y() - (double)usedyOff);
        p1x.z(p1x.z() + (double)usedzOff);
        p1x = rotax.multiply(p1x);
        p1x = rotay.multiply(p1x);
        p1x = rotaz.multiply(p1x);
        p1y.x(p1y.x() + (double)usedxOff);
        p1y.y(p1y.y() - (double)usedyOff);
        p1y.z(p1y.z() + (double)usedzOff);
        p1y = rotax.multiply(p1y);
        p1y = rotay.multiply(p1y);
        p1y = rotaz.multiply(p1y);
        p1z.x(p1z.x() + (double)usedxOff);
        p1z.y(p1z.y() - (double)usedyOff);
        p1z.z(p1z.z() + (double)usedzOff);
        p1z = rotax.multiply(p1z);
        p1z = rotay.multiply(p1z);
        p1z = rotaz.multiply(p1z);
        Vertex startDrag = new Vertex(Scaler.unscaleDoubleToInt(this.mXPressStart - this.x0Offset, this.scale), Scaler.unscaleDoubleToInt(this.mYPressStart - this.y0Offset, this.scale), 0.0);
        Vertex endDrag = new Vertex(Scaler.unscaleDoubleToInt(this.mX - this.x0Offset, this.scale), Scaler.unscaleDoubleToInt(this.mY - this.y0Offset, this.scale), 0.0);
        this.mX = evt.getX();
        this.mY = evt.getY();
        int x = this.mXPressStart;
        int y = this.mYPressStart;
        int w = this.mX - this.mXPressStart;
        int h = this.mY - this.mYPressStart;
        Matrix4x4 rotaxI = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
        Matrix4x4 rotayI = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
        Matrix4x4 rotazI = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
        rotaxI.transpose();
        rotayI.transpose();
        rotazI.transpose();
        if (this.vars.pressed && this.vars.ctrlPressed) {
            this.vars.dragging = true;
            double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
            Vertex start = new Vertex(0.0, 0.0, 0.0);
            Vertex end2 = new Vertex(Scaler.unscaleDoubleToDouble(w, scaleUse), Scaler.unscaleDoubleToDouble(h, scaleUse), 0.0);
            start = rotazI.multiply(start);
            start = rotayI.multiply(start);
            start = rotaxI.multiply(start);
            end2.y(-end2.y());
            end2 = rotazI.multiply(end2);
            end2 = rotayI.multiply(end2);
            end2 = rotaxI.multiply(end2);
            this.addXOffset((int)(end2.x() - start.x()));
            this.addYOffset((int)(-(end2.y() - start.y())));
            this.addZOffset((int)(end2.z() - start.z()));
            this.mXPressStart = this.mX;
            this.mYPressStart = this.mY;
            this.sharedRepaint();
            this.fireMouseMoved(evt);
            return;
        }
        if (!this.vars.continueMode) {
            if (this.vars.pressed) {
                this.vars.dragging = true;
            }
            this.vars.crossColor = VectorColors.VECCI_CROSS_DRAG_COLOR;
        }
        if (!this.vars.displayDragSelection || this.vars.workingMode != 2 && this.vars.workingMode != 1 || this.vars.dragging || this.vars.pressed) {
            // empty if block
        }
        this.sharedRepaint();
        if (this.vars.pressed) {
            this.fireMouseMoved(evt);
        }
    }

    @Override
    public boolean is3d() {
        return true;
    }

    @Override
    public void fireMouseMoved(MouseEvent evt) {
        EditMouseEvent e = new EditMouseEvent();
        e.evt = evt;
        e.panel = this;
        e.mouseExited = this.mouseExited;
        e.dragging = this.vars.dragging;
        e.shiftPressed = this.vars.shiftPressed;
        e.ctrlPressed = this.vars.ctrlPressed;
        this.vars.pressed = true;
        if (this.vars.dragging) {
            e.dragOriginX = this.mDragOriginX;
            e.dragOriginY = this.mDragOriginY;
            e.dragOriginZ = this.mDragOriginZ;
            double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
            Matrix4x4 rotax = Matrix4x4.getRotationX(Math.toRadians(this.axisXAngle));
            Matrix4x4 rotay = Matrix4x4.getRotationY(Math.toRadians(this.axisYAngle));
            Matrix4x4 rotaz = Matrix4x4.getRotationZ(Math.toRadians(this.axisZAngle));
            rotax.transpose();
            rotay.transpose();
            rotaz.transpose();
            Vertex start = new Vertex(evt.getX() - this.x0Offset, -(evt.getY() - this.y0Offset), 0.0);
            start = rotaz.multiply(start);
            start = rotay.multiply(start);
            start = rotax.multiply(start);
            double xStart = Scaler.unscaleDoubleToDouble(start.x(), scaleUse);
            double yStart = Scaler.unscaleDoubleToDouble(start.y(), scaleUse);
            double zStart = Scaler.unscaleDoubleToDouble(start.z(), scaleUse);
            if (this.isGrid()) {
                this.lastCrossX = (int)((double)((int)(xStart / (double)this.vars.gridWidth + 0.5)) * (double)this.vars.gridWidth);
                this.lastCrossY = (int)((double)((int)(yStart / (double)this.vars.gridWidth + 0.5)) * (double)this.vars.gridWidth);
                this.lastCrossZ = (int)((double)((int)(zStart / (double)this.vars.gridWidth + 0.5)) * (double)this.vars.gridWidth);
            } else {
                this.lastCrossX = (int)xStart;
                this.lastCrossY = (int)yStart;
                this.lastCrossZ = (int)zStart;
            }
            e.dragNowX = this.lastCrossX;
            e.dragNowY = this.lastCrossY;
            e.dragNowZ = this.lastCrossZ;
            this.mDragOriginX = this.lastCrossX;
            this.mDragOriginY = this.lastCrossY;
            this.mDragOriginZ = this.lastCrossZ;
        }
        if (!this.vars.dragging && !this.vars.continueMode) {
            this.mXPressStart = evt.getX();
            this.mYPressStart = evt.getY();
            this.mXPressStart = this.lastCrossX;
            this.mYPressStart = this.lastCrossY;
        }
        Vertex trans = new Vertex();
        if (this.moveXAllowed) {
            trans.x(e.dragOriginX - e.dragNowX);
        }
        if (this.moveYAllowed) {
            trans.y(e.dragOriginY - e.dragNowY);
        }
        if (this.moveZAllowed) {
            trans.z(e.dragOriginZ - e.dragNowZ);
        }
        e.translocationInVectrexPoint = trans;
        e.currentVectrexPoint = this.convertToVectrex(this.getCurrentPoint());
        e.highlightedPoint = this.vars.hightLightVPoint;
        e.highlightedVector = this.vars.hightLightVector;
        for (int i = 0; i < this.vars.mMovedListener.size(); ++i) {
            this.vars.mMovedListener.elementAt(i).moved(e);
        }
    }
}

