/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.event.EditMouseEvent;
import de.malban.graphics.GFXVector;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.MouseMovedListener;
import de.malban.graphics.MousePressedListener;
import de.malban.graphics.MouseReleasedListener;
import de.malban.graphics.VectorChangedListener;
import de.malban.graphics.VectorColors;
import de.malban.graphics.Vertex;
import de.malban.gui.Scaler;
import de.malban.util.UtilityImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;

public class SingleVectorPanel
extends JPanel {
    public static int ARR_SIZE = 10;
    protected boolean usePrivateOffset = false;
    protected boolean usePrivateScale = false;
    double scale = 1.0;
    int xOffset = 0;
    int yOffset = 0;
    int zOffset = 0;
    int selWidth = 0;
    int selHeight = 0;
    SharedVars vars = new SharedVars(this);
    public static final int SVP_SET = 0;
    public static final int SVP_SELECT_LINE = 1;
    public static final int SVP_SELECT_POINT = 2;
    public static final int SVP_DRAG_POINT = 3;
    public static final int HORIZONTAL_AXIS_X = 0;
    public static final int HORIZONTAL_AXIS_Y = 1;
    public static final int HORIZONTAL_AXIS_Z = 2;
    public static final int VERTICAL_AXIS_X = 0;
    public static final int VERTICAL_AXIS_Y = 1;
    public static final int VERTICAL_AXIS_Z = 2;
    int horizontalAxis = 0;
    int verticalAxis = 1;
    int inSetting = 0;
    int mX = 0;
    int mY = 0;
    int mXPressStart = 0;
    int mYPressStart = 0;
    int mXRelease = 0;
    int mYRelease = 0;
    int lastCrossX = 0;
    int lastCrossY = 0;
    int lastCrossZ = 0;
    int mDragOriginX = 0;
    int mDragOriginY = 0;
    int mDragOriginZ = 0;
    boolean noCross = true;
    boolean mouseExited = false;
    int x0Offset = 150;
    int y0Offset = 150;
    public static boolean displayLen = true;
    int old_x1 = Integer.MAX_VALUE;
    int old_y1 = Integer.MAX_VALUE;
    BufferedImage[] paintBufferImage = new BufferedImage[2];
    int bufferUsed = -1;

    public void setUsePrivateOffset(boolean b) {
        this.usePrivateOffset = b;
    }

    public void setUsePrivateScale(boolean b) {
        this.usePrivateScale = b;
    }

    public void resetSharedVars() {
        SharedVars oldVars = this.vars;
        this.vars = new SharedVars(this);
        this.vars.gridWidth = oldVars.gridWidth;
        this.vars.displayGrid = oldVars.displayGrid;
        this.vars.workingMode = oldVars.workingMode;
        this.vars.VECTOR_SELECTED_RADIUS = oldVars.VECTOR_SELECTED_RADIUS;
        this.vars.VECTOR_HIGHLIGHT_RADIUS = oldVars.VECTOR_HIGHLIGHT_RADIUS;
        this.vars.VECTOR_HIGHLIGHT_RANGE = oldVars.VECTOR_HIGHLIGHT_RANGE;
        this.vars.POINT_SELECTED_RADIUS = oldVars.POINT_SELECTED_RADIUS;
        this.vars.POINT_HIGHLIGHT_RADIUS = oldVars.POINT_HIGHLIGHT_RADIUS;
        this.vars.POINT_HIGHLIGHT_RANGE = oldVars.POINT_HIGHLIGHT_RANGE;
        this.vars.crossColor = oldVars.crossColor;
        this.vars.isScale = oldVars.isScale;
        this.vars.crossDrawn = oldVars.crossDrawn;
        this.vars.noMouseReaction = oldVars.noMouseReaction;
        this.vars.drawArrows = oldVars.drawArrows;
        this.vars.realyBigEnd = oldVars.realyBigEnd;
        this.vars.scale = oldVars.scale;
        this.vars.vectorWidth = oldVars.vectorWidth;
        this.vars.drawByteFrame = oldVars.drawByteFrame;
    }

    public int getGridWidth() {
        return this.vars.gridWidth;
    }

    public void setSharedVars(SharedVars vv) {
        this.vars = vv;
    }

    public SharedVars getSharedVars() {
        return this.vars;
    }

    public void addSibbling(SingleVectorPanel s) {
        this.vars.siblings.add(s);
        s.setSharedVars(this.getSharedVars());
    }

    public void removeSibbling(SingleVectorPanel s) {
        this.vars.siblings.remove(s);
        s.resetSharedVars();
    }

    public void setDrawVectorEnds(boolean b) {
        this.vars.realyBigEnd = b;
        this.sharedRepaint();
    }

    public SingleVectorPanel() {
        this.initComponents();
    }

    public void deinit() {
        this.setVisible(false);
        this.vars.mMovedListener.clear();
        this.vars.mPressedListener.clear();
        this.unsetImage();
    }

    public MyTableModel getTableModel() {
        return this.vars.dataModel;
    }

    public void setDrawArrows(boolean a) {
        this.vars.drawArrows = a;
        this.sharedRepaint();
    }

    public void setDrawPosition(boolean p) {
        this.vars.drawPositions = p;
        this.sharedRepaint();
    }

    public void setMovesVisible(boolean m) {
        this.vars.drawMoves = m;
        this.sharedRepaint();
    }

    public int getHorizontalAxis() {
        return this.horizontalAxis;
    }

    public int getVerticalAxis() {
        return this.verticalAxis;
    }

    public void setXMain() {
        this.horizontalAxis = 0;
        this.verticalAxis = 1;
    }

    public void setYMain() {
        this.horizontalAxis = 1;
        this.verticalAxis = 2;
    }

    public void setZMain() {
        this.horizontalAxis = 2;
        this.verticalAxis = 0;
    }

    public void setMode(int m) {
        this.vars.workingMode = m;
        if (this.vars.hightLightVPoint != null) {
            this.vars.hightLightVPoint.highlight = false;
            this.vars.hightLightVPoint = null;
        }
        this.unselectAll();
    }

    public void setSharedRepaint(boolean doSharedRepaint) {
        this.vars.shareRepaintEnabled = doSharedRepaint;
        if (doSharedRepaint) {
            this.sharedRepaint();
        }
    }

    void allwaysInt() {
        if (this.vars.allwaysInt) {
            GFXVectorList vl = this.getForegroundVectorList();
            vl.intAll();
        }
    }

    public void sharedRepaint() {
        if (!this.vars.shareRepaintEnabled) {
            return;
        }
        this.allwaysInt();
        for (SingleVectorPanel svp : this.vars.siblings) {
            svp.updateAndRepaint();
        }
    }

    public GFXVectorList getForegroundVectorList() {
        return this.vars.foregroundVectors;
    }

    public void clearForegroundVectorList() {
        this.vars.foregroundVectors.clear();
        this.clearSelectedVertice();
        this.sharedRepaint();
    }

    public void joinAllPointsAtHighlight() {
        if (this.vars.hightLightVPoint == null) {
            return;
        }
        for (GFXVector v : this.vars.foregroundVectors.list) {
            if (v.start.equals(this.vars.hightLightVPoint)) {
                v.start = this.vars.hightLightVPoint;
            }
            if (!v.end.equals(this.vars.hightLightVPoint)) continue;
            v.end = this.vars.hightLightVPoint;
        }
        this.fixRelatives();
        this.sharedRepaint();
    }

    public void clearVectors() {
        this.vars.foregroundVectors.clear();
        this.clearSelectedVertice();
        this.sharedRepaint();
    }

    public void deleteHighlitedVector() {
        this.vars.foregroundVectors.remove(this.vars.hightLightVector);
        if (this.vars.hightLightVector.start_connect != null) {
            this.vars.hightLightVector.start_connect.end_connect = null;
            this.vars.hightLightVector.start_connect.uid_end_connect = -1;
            this.vars.hightLightVector.start_connect.setRelativ(false);
        }
        if (this.vars.hightLightVector.end_connect != null) {
            this.vars.hightLightVector.end_connect.start_connect = null;
            this.vars.hightLightVector.end_connect.uid_start_connect = -1;
            this.vars.hightLightVector.end_connect.setRelativ(false);
        }
        this.vars.hightLightVector = null;
        this.clearSelectedVertice();
        this.sharedRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedVector() {
        ArrayList<GFXVector> toDelete = new ArrayList<GFXVector>();
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                if (!v.selected) continue;
                toDelete.add(v);
            }
        }
        for (GFXVector v : toDelete) {
            if (v.start_connect != null) {
                v.start_connect.end_connect = null;
                v.start_connect.uid_end_connect = -1;
                v.start_connect.setRelativ(false);
            }
            if (v.end_connect != null) {
                v.end_connect.start_connect = null;
                v.end_connect.uid_start_connect = -1;
                v.end_connect.setRelativ(false);
            }
            this.vars.foregroundVectors.remove(v);
        }
        this.vars.foregroundVectors.remove(this.vars.hightLightVector);
        this.vars.hightLightVector = null;
        this.clearSelectedVertice();
        this.sharedRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNotSelectedVector() {
        ArrayList<GFXVector> toDelete = new ArrayList<GFXVector>();
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                if (v.selected) continue;
                toDelete.add(v);
            }
        }
        for (GFXVector v : toDelete) {
            if (v.start_connect != null) {
                v.start_connect.end_connect = null;
                v.start_connect.uid_end_connect = -1;
                v.start_connect.setRelativ(false);
            }
            if (v.end_connect != null) {
                v.end_connect.start_connect = null;
                v.end_connect.uid_start_connect = -1;
                v.end_connect.setRelativ(false);
            }
            this.vars.foregroundVectors.remove(v);
        }
        this.sharedRepaint();
    }

    public void addForegroundVectorList(ArrayList<GFXVector> fv) {
        for (GFXVector v : fv) {
            this.vars.foregroundVectors.add(v);
        }
        this.sharedRepaint();
    }

    public void setForegroundVectorList(GFXVectorList fv) {
        this.vars.foregroundVectors.clear();
        this.clearSelectedVertice();
        this.addForegroundVectorList(fv.list);
    }

    public void addForegroundVectorList(GFXVectorList fv) {
        this.addForegroundVectorList(fv.list);
    }

    public void addForegroundVector(GFXVector v) {
        this.vars.foregroundVectors.add(v);
        this.sharedRepaint();
    }

    public void clearBackgroundVectorList() {
        this.vars.backgroundVectors.clear();
        this.sharedRepaint();
    }

    public void addBackgroundVectorList(ArrayList<GFXVector> bv) {
        for (GFXVector v : bv) {
            this.vars.backgroundVectors.add(v);
        }
        this.sharedRepaint();
    }

    public void addBackgroundVectorList(GFXVectorList fv) {
        this.addBackgroundVectorList(fv.list);
    }

    public void addBackgroundVector(GFXVector v) {
        this.vars.backgroundVectors.add(v);
        this.sharedRepaint();
    }

    public void setDrawCross(boolean cd) {
        this.vars.crossDrawn = cd;
        this.sharedRepaint();
    }

    public void setNoMouseRection(boolean mr) {
        this.vars.noMouseReaction = mr;
        this.sharedRepaint();
    }

    public boolean isShiftPressedOnClick() {
        return this.vars.shiftPressed;
    }

    public int getXOffset() {
        if (!this.usePrivateOffset) {
            return this.vars.xOffset;
        }
        return this.xOffset;
    }

    public int getYOffset() {
        if (!this.usePrivateOffset) {
            return this.vars.yOffset;
        }
        return this.yOffset;
    }

    public int getZOffset() {
        if (!this.usePrivateOffset) {
            return this.vars.zOffset;
        }
        return this.zOffset;
    }

    public void setOffsets(int x, int y, int z) {
        if (!this.usePrivateOffset) {
            this.vars.xOffset = x;
            this.vars.yOffset = y;
            this.vars.zOffset = z;
            this.xOffset = x;
            this.yOffset = y;
            this.zOffset = z;
            this.sharedRepaint();
            return;
        }
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
        this.repaint();
    }

    public double getScale() {
        if (!this.usePrivateScale) {
            return this.vars.scale;
        }
        return this.scale;
    }

    public boolean is3d() {
        return false;
    }

    public void setScale(double s) {
        if (this.inSetting > 0) {
            return;
        }
        ++this.inSetting;
        this.vars.isScale = true;
        if (!this.usePrivateScale) {
            this.scale = s;
            this.vars.scale = s;
            this.sharedRepaint();
        } else {
            this.scale = s;
            this.repaint();
        }
        --this.inSetting;
    }

    public void setGrid(boolean g, int w) {
        if (w <= 0) {
            w = 1;
        }
        this.vars.displayGrid = g;
        this.vars.gridWidth = w;
        this.sharedRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scaleToFit() {
        double max = 0.0;
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                if (Math.abs(v.start.x()) > max) {
                    max = Math.abs(v.start.x());
                }
                if (Math.abs(v.start.y()) > max) {
                    max = Math.abs(v.start.y());
                }
                if (Math.abs(v.start.z()) > max) {
                    max = Math.abs(v.start.z());
                }
                if (Math.abs(v.end.x()) > max) {
                    max = Math.abs(v.end.x());
                }
                if (Math.abs(v.end.y()) > max) {
                    max = Math.abs(v.end.y());
                }
                if (!(Math.abs(v.end.z()) > max)) continue;
                max = Math.abs(v.end.z());
            }
        }
        double dif = max * 2.0;
        if (dif == 0.0) {
            return;
        }
        double w = this.getWidth();
        double s = w / dif;
        this.setScale(s);
    }

    private void initComponents() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SingleVectorPanel.this.formMouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                SingleVectorPanel.this.formMouseDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SingleVectorPanel.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SingleVectorPanel.this.formMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SingleVectorPanel.this.formMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SingleVectorPanel.this.formMouseEntered(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SingleVectorPanel.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static double getDistancePointToVector(double x0, double y0, double x1, double y1) {
        return Math.sqrt((x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1));
    }

    public static double getDistancePointToVector(double x0, double y0, double x1, double y1, double x2, double y2) {
        double lineEndDistance = Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0);
        if (lineEndDistance == 0.0) {
            return Math.pow(x0 - x1, 2.0) + Math.pow(y0 - y1, 2.0);
        }
        double t = ((x0 - x1) * (x2 - x1) + (y0 - y1) * (y2 - y1)) / lineEndDistance;
        if (t < 0.0) {
            return Math.pow(x0 - x1, 2.0) + Math.pow(y0 - y1, 2.0);
        }
        if (t > 1.0) {
            return Math.pow(x0 - x2, 2.0) + Math.pow(y0 - y2, 2.0);
        }
        double xt = x1 + t * (x2 - x1);
        double yt = y1 + t * (y2 - y1);
        double t2 = Math.pow(x0 - xt, 2.0) + Math.pow(y0 - yt, 2.0);
        return Math.sqrt(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMouseMovedEvent(MouseEvent evt) {
        ArrayList<GFXVector> arrayList;
        double distance;
        this.mX = evt.getX();
        this.mY = evt.getY();
        this.vars.crossColor = VectorColors.VECCI_CROSS_COLOR;
        if (this.vars.workingMode == 2) {
            distance = Double.MAX_VALUE;
            if (this.vars.hightLightVPoint != null) {
                this.vars.hightLightVPoint.highlight = false;
                this.vars.hightLightVPoint = null;
            }
            arrayList = this.vars.foregroundVectors.list;
            synchronized (arrayList) {
                for (GFXVector v : this.vars.foregroundVectors.list) {
                    double y;
                    v.start.highlight = false;
                    v.end.highlight = false;
                    Vertex p = this.convertFromVectrex(v.start);
                    double x = p.coord()[this.horizontalAxis];
                    double d = Math.sqrt(((double)this.mX - x) * ((double)this.mX - x) + ((double)this.mY - (y = p.coord()[this.verticalAxis])) * ((double)this.mY - y));
                    if (d < distance) {
                        distance = d;
                        this.vars.hightLightVPoint = v.start;
                    }
                    if ((d = Math.sqrt(((double)this.mX - (x = (p = this.convertFromVectrex(v.end)).coord()[this.horizontalAxis])) * ((double)this.mX - x) + ((double)this.mY - (y = p.coord()[this.verticalAxis])) * ((double)this.mY - y))) < distance) {
                        distance = d;
                        this.vars.hightLightVPoint = v.end;
                    }
                    if (distance != 0.0) continue;
                    break;
                }
            }
            if (this.vars.hightLightVPoint != null) {
                if (distance <= (double)this.vars.POINT_HIGHLIGHT_RANGE) {
                    this.vars.hightLightVPoint.highlight = true;
                } else {
                    this.vars.hightLightVPoint = null;
                }
            }
        }
        if (this.vars.workingMode == 1) {
            distance = Double.MAX_VALUE;
            if (this.vars.hightLightVector != null) {
                this.vars.hightLightVector.highlight = false;
                this.vars.hightLightVector = null;
            }
            arrayList = this.vars.foregroundVectors.list;
            synchronized (arrayList) {
                for (GFXVector v : this.vars.foregroundVectors.list) {
                    double y2;
                    Vertex p2;
                    double x2;
                    double y1;
                    v.highlight = false;
                    Vertex p1 = this.convertFromVectrex(v.start);
                    double x1 = p1.coord()[this.horizontalAxis];
                    double d = SingleVectorPanel.getDistancePointToVector(this.mX, this.mY, x1, y1 = p1.coord()[this.verticalAxis], x2 = (p2 = this.convertFromVectrex(v.end)).coord()[this.horizontalAxis], y2 = p2.coord()[this.verticalAxis]);
                    if (d < distance) {
                        distance = d;
                        this.vars.hightLightVector = v;
                    }
                    if (distance != 0.0) continue;
                    break;
                }
            }
            if (this.vars.hightLightVector != null) {
                if (distance <= (double)this.vars.VECTOR_HIGHLIGHT_RANGE) {
                    this.vars.hightLightVector.highlight = true;
                } else {
                    this.vars.hightLightVector = null;
                }
            }
        }
        this.sharedRepaint();
        this.fireMouseMoved(evt);
    }

    private void formMouseMoved(MouseEvent evt) {
        this.handleMouseMovedEvent(evt);
    }

    protected void handleMousePressed(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        if (evt.getButton() == 1) {
            if (this.vars.continueMode) {
                this.vars.pressed = true;
                return;
            }
            this.vars.shiftPressed = false;
            this.vars.ctrlPressed = false;
            this.vars.pressed = true;
            this.mXPressStart = evt.getX();
            this.mYPressStart = evt.getY();
            this.mXPressStart = this.lastCrossX;
            this.mYPressStart = this.lastCrossY;
            this.mDragOriginX = this.lastCrossX;
            this.mDragOriginY = this.lastCrossY;
            if (evt != null) {
                this.vars.shiftPressed = (evt.getModifiers() & 1) == 1;
                this.vars.ctrlPressed = (evt.getModifiers() & 2) == 2;
            }
        }
        this.fireMousePressed(evt);
        this.vars.crossColor = VectorColors.VECCI_CROSS_DRAG_COLOR;
        this.sharedRepaint();
    }

    private void formMousePressed(MouseEvent evt) {
        this.handleMousePressed(evt);
    }

    private void formMouseReleased(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        this.mXRelease = this.lastCrossX;
        this.mYRelease = this.lastCrossY;
        this.vars.shiftPressed = false;
        this.vars.ctrlPressed = false;
        if (evt != null) {
            this.vars.shiftPressed = (evt.getModifiers() & 1) == 1;
            this.vars.ctrlPressed = (evt.getModifiers() & 2) == 2;
        }
        this.fireMouseReleased(evt);
        this.vars.pressed = false;
        this.vars.dragging = false;
        this.vars.selecting = true;
        this.vars.crossColor = VectorColors.VECCI_CROSS_COLOR;
        for (SingleVectorPanel svp : this.vars.siblings) {
            svp.repaint();
        }
    }

    private void formMouseExited(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        this.vars.pressed = false;
        this.noCross = true;
        this.mouseExited = true;
        this.fireMouseMoved(evt);
        this.mouseExited = false;
        this.sharedRepaint();
    }

    public boolean isDragging() {
        return this.vars.pressed && this.vars.dragging;
    }

    protected void handleMouseDraggedEvent(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        this.mX = evt.getX();
        this.mY = evt.getY();
        if (this.vars.pressed && this.vars.ctrlPressed) {
            int x = this.mXPressStart;
            int y = this.mYPressStart;
            int w = this.mX - this.mXPressStart;
            int h = this.mY - this.mYPressStart;
            this.vars.dragging = true;
            double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
            w = Scaler.unscaleDoubleToInt(w, scaleUse);
            h = Scaler.unscaleDoubleToInt(h, scaleUse);
            this.addXOffset(w);
            this.addYOffset(h);
            this.mXPressStart = this.mX;
            this.mYPressStart = this.mY;
            this.sharedRepaint();
            this.fireMouseMoved(evt);
            return;
        }
        if (!this.vars.continueMode) {
            if (this.vars.pressed) {
                this.vars.dragging = true;
            }
            this.vars.crossColor = VectorColors.VECCI_CROSS_DRAG_COLOR;
        }
        if (this.vars.displayDragSelection && (this.vars.workingMode == 2 || this.vars.workingMode == 1) && (this.vars.dragging || this.vars.pressed)) {
            int x = this.mXPressStart;
            int y = this.mYPressStart;
            int w = this.mX - this.mXPressStart;
            int h = this.mY - this.mYPressStart;
            if (this.mX < this.mXPressStart) {
                x = this.mX;
                w = this.mXPressStart - this.mX;
            }
            if (this.mY < this.mYPressStart) {
                y = this.mY;
                h = this.mYPressStart - this.mY;
            }
            this.selectAllInArea(x, y, w, h);
        }
        this.sharedRepaint();
        if (this.vars.pressed) {
            this.fireMouseMoved(evt);
        }
    }

    private void formMouseDragged(MouseEvent evt) {
        this.handleMouseDraggedEvent(evt);
    }

    private void formMouseEntered(MouseEvent evt) {
        if (this.vars.noMouseReaction) {
            return;
        }
        if (evt.getButton() == 1) {
            this.vars.pressed = true;
        }
        this.noCross = false;
        this.sharedRepaint();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.x0Offset = this.getWidth() / 2;
        this.y0Offset = this.getHeight() / 2;
        this.repaint();
    }

    final void drawVectrexScaledLine(Graphics g, int x0, int y0, int x1, int y1, boolean bigEnd, Stroke stroke, boolean drawArrows, boolean drawPositions, int pos, GFXVector v) {
        int y_1;
        int y_0;
        int x_1;
        int x_0;
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        x0 += usedxOff;
        x1 += usedxOff;
        y0 += usedyOff;
        y1 += usedyOff;
        if (this.vars.isScale) {
            double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
            x_0 = this.x0Offset + Scaler.scaleDoubleToInt(x0, scaleUse);
            x_1 = this.x0Offset + Scaler.scaleDoubleToInt(x1, scaleUse);
            y_0 = this.y0Offset + Scaler.scaleDoubleToInt(y0, scaleUse);
            y_1 = this.y0Offset + Scaler.scaleDoubleToInt(y1, scaleUse);
        } else {
            x_0 = this.x0Offset + x0;
            x_1 = this.x0Offset + x1;
            y_0 = this.y0Offset + y0;
            y_1 = this.y0Offset + y1;
        }
        if (!this.vars.realyBigEnd && this.old_x1 == x_0 && this.old_y1 == y_0) {
            int SHORTEN = this.vars.vectorWidth;
            double dx = x_1 - x_0;
            double dy = y_1 - y_0;
            double length = Math.sqrt(dx * dx + dy * dy);
            if (length <= (double)this.vars.vectorWidth) {
                return;
            }
            if (length > 0.0) {
                dx /= length;
                dy /= length;
            }
            x_0 = (int)((double)x_1 - (dx *= length - (double)SHORTEN));
            y_0 = (int)((double)y_1 - (dy *= length - (double)SHORTEN));
        }
        this.old_x1 = x_1;
        this.old_y1 = y_1;
        if (stroke != null) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke saveStroke = g2.getStroke();
            g2.setStroke(stroke);
            if (drawArrows) {
                this.drawArrow(g2, x_0, y_0, x_1, y_1);
            } else {
                g.drawLine(x_0, y_0, x_1, y_1);
            }
            g2.setStroke(saveStroke);
        } else if (drawArrows) {
            this.drawArrow(g, x_0, y_0, x_1, y_1);
        } else {
            g.drawLine(x_0, y_0, x_1, y_1);
        }
        if (drawPositions) {
            g.setColor(VectorColors.VECCI_POS_COLOR);
            int xx = x_0 + (x_1 - x_0) / 2;
            int yy = y_0 + (y_1 - y_0) / 2;
            g.drawString("" + pos, xx, yy);
        }
        if (bigEnd && this.vars.realyBigEnd) {
            Color cstart = VectorColors.VECCI_VECTOR_ENDPOINT_COLOR;
            Color cend = VectorColors.VECCI_VECTOR_ENDPOINT_COLOR;
            if (v != null) {
                if (v.start_connect != null) {
                    cstart = VectorColors.VECCI_POINT_JOINED_COLOR;
                }
                if (v.end_connect != null) {
                    cend = VectorColors.VECCI_POINT_JOINED_COLOR;
                }
            }
            g.setColor(cstart);
            g.fillRect(x_0 - 1, y_0 - 1, 3, 3);
            g.setColor(cend);
            g.fillRect(x_1 - 1, y_1 - 1, 3, 3);
        }
    }

    public Vertex convertToVectrex(Vertex p) {
        double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
        Vertex np = new Vertex();
        np.coord()[this.horizontalAxis] = p.coords[this.horizontalAxis] - (double)this.x0Offset;
        np.coord()[this.verticalAxis] = (double)this.y0Offset - p.coords[this.verticalAxis];
        np.coord()[this.horizontalAxis] = Scaler.unscaleDoubleToDouble(np.coord()[this.horizontalAxis], scaleUse);
        np.coord()[this.verticalAxis] = Scaler.unscaleDoubleToDouble(np.coord()[this.verticalAxis], scaleUse);
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        double[] dArray = np.coord();
        int n = this.horizontalAxis;
        dArray[n] = dArray[n] - (double)usedxOff;
        double[] dArray2 = np.coord();
        int n2 = this.verticalAxis;
        dArray2[n2] = dArray2[n2] + (double)usedyOff;
        return np;
    }

    public Vertex convertFromVectrex(Vertex p) {
        double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
        Vertex np = new Vertex();
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        np.coord()[this.horizontalAxis] = Scaler.scaleDoubleToInt(p.coord()[this.horizontalAxis] + (double)usedxOff, scaleUse);
        np.coord()[this.verticalAxis] = Scaler.scaleDoubleToInt(p.coord()[this.verticalAxis] - (double)usedyOff, scaleUse);
        np.coord()[this.horizontalAxis] = np.coords[this.horizontalAxis] + (double)this.x0Offset;
        np.coord()[this.verticalAxis] = -np.coords[this.verticalAxis] + (double)this.y0Offset;
        return np;
    }

    public double convertFromVectrexX(int x) {
        double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
        double newX = 0.0;
        newX = Scaler.scaleDoubleToInt(x, scaleUse);
        return newX;
    }

    public double convertFromVectrexY(int y) {
        double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
        double newY = 0.0;
        newY = Scaler.scaleDoubleToInt(y, scaleUse);
        return newY;
    }

    float[] getPattern(GFXVector v) {
        ArrayList<Float> pattern = new ArrayList<Float>();
        boolean visible = false;
        float current = 0.0f;
        if ((v.pattern & 1) == 1) {
            current += 1.0f;
            visible = true;
        } else {
            current += 1.0f;
            pattern.add(Float.valueOf(0.0f));
            visible = false;
        }
        for (int t = 2; t <= 128; t *= 2) {
            if ((v.pattern & t) == t) {
                if (!visible) {
                    pattern.add(Float.valueOf(current));
                    current = 1.0f;
                    visible = true;
                    continue;
                }
                current += 1.0f;
                continue;
            }
            if (visible) {
                pattern.add(Float.valueOf(current));
                current = 1.0f;
                visible = false;
                continue;
            }
            current += 1.0f;
        }
        pattern.add(Float.valueOf(current));
        float[] ret = new float[pattern.size()];
        int i = 0;
        for (Float f : pattern) {
            ret[i++] = f.floatValue();
        }
        return ret;
    }

    void drawArrow(Graphics g1, int x1, int y1, int x2, int y2) {
        Graphics2D g = (Graphics2D)g1.create();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(at);
        g.drawLine(0, 0, len, 0);
        g.fillPolygon(new int[]{len, len - ARR_SIZE, len - ARR_SIZE, len}, new int[]{0, -ARR_SIZE / 3, ARR_SIZE / 3, 0}, 4);
    }

    public void setByteFrame(boolean b) {
        this.vars.drawByteFrame = b;
        this.sharedRepaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.doPaint((Graphics2D)g);
    }

    public void setSelection(int x, int y, int w, int h) {
        this.repaint();
    }

    public void removeAllListeners() {
        this.vars.mMovedListener.clear();
        this.vars.mPressedListener.clear();
        this.vars.mReleasedListener.clear();
    }

    public void addMousePressedListener(MousePressedListener listener) {
        this.vars.mPressedListener.removeElement(listener);
        this.vars.mPressedListener.addElement(listener);
    }

    public void removeMousePressedListener(MousePressedListener listener) {
        this.vars.mPressedListener.removeElement(listener);
    }

    public void addMouseReleasedListener(MouseReleasedListener listener) {
        this.vars.mReleasedListener.removeElement(listener);
        this.vars.mReleasedListener.addElement(listener);
    }

    public void removeMouseReleasedListener(MouseReleasedListener listener) {
        this.vars.mReleasedListener.removeElement(listener);
    }

    public void addMouseMovedListener(MouseMovedListener listener) {
        this.vars.mMovedListener.removeElement(listener);
        this.vars.mMovedListener.addElement(listener);
    }

    public void removeMouseMovedListener(MouseMovedListener listener) {
        this.vars.mMovedListener.removeElement(listener);
    }

    public void addVectorChangeListener(VectorChangedListener listener) {
        this.vars.mVectorListener.removeElement(listener);
        this.vars.mVectorListener.addElement(listener);
    }

    public void removeVectorChangeListener(VectorChangedListener listener) {
        this.vars.mVectorListener.removeElement(listener);
    }

    public void fireVectorPreChange() {
        for (int i = 0; i < this.vars.mVectorListener.size(); ++i) {
            this.vars.mVectorListener.elementAt(i).preVectorChange();
        }
    }

    public void fireVectorPostChange() {
        for (int i = 0; i < this.vars.mVectorListener.size(); ++i) {
            this.vars.mVectorListener.elementAt(i).postVectorChange();
        }
    }

    public void fireMouseMoved(MouseEvent evt) {
        EditMouseEvent e = new EditMouseEvent();
        e.evt = evt;
        e.panel = this;
        e.mouseExited = this.mouseExited;
        e.dragging = this.vars.dragging;
        e.shiftPressed = this.vars.shiftPressed;
        e.ctrlPressed = this.vars.ctrlPressed;
        this.vars.pressed = true;
        if (this.vars.dragging) {
            e.dragOriginX = this.mDragOriginX;
            e.dragOriginY = this.mDragOriginY;
            e.dragNowX = this.lastCrossX;
            e.dragNowY = this.lastCrossY;
            this.mDragOriginX = this.lastCrossX;
            this.mDragOriginY = this.lastCrossY;
        }
        if (!this.vars.dragging && !this.vars.continueMode) {
            this.mXPressStart = evt.getX();
            this.mYPressStart = evt.getY();
            this.mXPressStart = this.lastCrossX;
            this.mYPressStart = this.lastCrossY;
        }
        e.translocationInVectrexPoint = this.getDragTranslocation(e.dragOriginX, e.dragOriginY, e.dragNowX, e.dragNowY);
        e.currentVectrexPoint = this.convertToVectrex(this.getCurrentPoint());
        e.highlightedPoint = this.vars.hightLightVPoint;
        e.highlightedVector = this.vars.hightLightVector;
        for (int i = 0; i < this.vars.mMovedListener.size(); ++i) {
            this.vars.mMovedListener.elementAt(i).moved(e);
        }
    }

    private Vertex getDragTranslocation(int x0, int y0, int x1, int y1) {
        Vertex p1 = new Vertex();
        p1.coord()[this.horizontalAxis] = x0;
        p1.coord()[this.verticalAxis] = y0;
        Vertex p2 = new Vertex();
        p2.coord()[this.horizontalAxis] = x1;
        p2.coord()[this.verticalAxis] = y1;
        p1 = this.convertToVectrex(p1);
        p2 = this.convertToVectrex(p2);
        Vertex p3 = new Vertex();
        p3.coord()[this.horizontalAxis] = p1.coord()[this.horizontalAxis] - p2.coord()[this.horizontalAxis];
        p3.coord()[this.verticalAxis] = p1.coord()[this.verticalAxis] - p2.coord()[this.verticalAxis];
        return p3;
    }

    public void fireMousePressed(MouseEvent evt) {
        EditMouseEvent e = new EditMouseEvent();
        e.evt = evt;
        e.panel = this;
        e.shiftPressed = this.vars.shiftPressed;
        e.ctrlPressed = this.vars.ctrlPressed;
        e.lastClickedVectrexPoint = this.convertToVectrex(this.getLastClickPoint());
        for (int i = 0; i < this.vars.mPressedListener.size(); ++i) {
            this.vars.mPressedListener.elementAt(i).pressed(e);
        }
    }

    public void fireMouseReleased(MouseEvent evt) {
        if (!this.vars.pressed) {
            return;
        }
        EditMouseEvent e = new EditMouseEvent();
        e.evt = evt;
        e.shiftPressed = this.vars.shiftPressed;
        e.ctrlPressed = this.vars.ctrlPressed;
        e.panel = this;
        for (int i = 0; i < this.vars.mReleasedListener.size(); ++i) {
            this.vars.mReleasedListener.elementAt(i).released(e);
        }
    }

    public void unsetImage() {
        this.vars.scale = 1.0;
        this.scale = 1.0;
        this.inSetting = 0;
        this.vars.crossColor = VectorColors.VECCI_CROSS_COLOR;
        this.mX = 0;
        this.mY = 0;
        this.mXPressStart = 0;
        this.mYPressStart = 0;
        this.vars.pressed = false;
        this.noCross = true;
        this.vars.dragging = false;
        this.vars.gridWidth = 10;
        this.vars.displayGrid = false;
        this.vars.noMouseReaction = false;
        this.vars.foregroundVectors.clear();
        this.vars.backgroundVectors.clear();
        this.sharedRepaint();
    }

    public Vertex getHighlightedVPoint() {
        return this.vars.hightLightVPoint;
    }

    public void setHighlightedVPoint(Vertex h) {
        this.vars.hightLightVPoint = h;
        this.vars.hightLightVPoint.highlight = true;
        this.sharedRepaint();
    }

    public boolean setHighlightedToSelectedVPoint() {
        this.unselectAll();
        if (this.vars.hightLightVPoint != null) {
            this.vars.hightLightVPoint.selected = true;
            this.sharedRepaint();
            this.vars.selecting = false;
            this.clearSelectedVertice();
            this.addVertexSelection(this.vars.hightLightVPoint);
            return true;
        }
        this.vars.selecting = true;
        this.sharedRepaint();
        return false;
    }

    public boolean addHighlightedToSelectedVPoint() {
        if (this.vars.hightLightVPoint != null) {
            this.vars.hightLightVPoint.selected = true;
            this.sharedRepaint();
            this.addVertexSelection(this.vars.hightLightVPoint);
            this.vars.selecting = false;
            return true;
        }
        this.vars.selecting = true;
        this.sharedRepaint();
        return false;
    }

    public boolean setToSelectedVPoint(Vertex point) {
        this.unselectAll();
        point.selected = true;
        this.vars.selecting = true;
        this.clearSelectedVertice();
        this.addVertexSelection(point);
        this.sharedRepaint();
        return false;
    }

    public boolean addToSelectedVPoint(Vertex point) {
        point.selected = true;
        this.vars.selecting = true;
        this.addVertexSelection(point);
        this.sharedRepaint();
        return false;
    }

    public boolean removeToSelectedVPoint(Vertex point) {
        point.selected = false;
        this.vars.selecting = true;
        this.sharedRepaint();
        this.removeVertexSelection(point);
        return false;
    }

    public boolean removeHighlightedToSelectedVPoint() {
        if (this.vars.hightLightVPoint != null) {
            this.vars.hightLightVPoint.selected = false;
            this.removeVertexSelection(this.vars.hightLightVPoint);
        }
        this.sharedRepaint();
        return true;
    }

    public boolean setHighlightedToSelectedVector() {
        this.unselectAllVectors();
        if (this.vars.hightLightVector != null) {
            this.vars.hightLightVector.selected = true;
            this.sharedRepaint();
            this.vars.selecting = false;
            return true;
        }
        this.vars.selecting = true;
        this.sharedRepaint();
        return false;
    }

    public GFXVector getHighlightedVector() {
        return this.vars.hightLightVector;
    }

    public boolean addHighlightedToSelectedVector() {
        if (this.vars.hightLightVector != null) {
            this.vars.hightLightVector.selected = true;
            this.sharedRepaint();
            this.vars.selecting = false;
            return true;
        }
        this.vars.selecting = true;
        this.sharedRepaint();
        return false;
    }

    public void removeHighlightedToSelectedVector() {
        if (this.vars.hightLightVector != null) {
            this.vars.hightLightVector.selected = false;
        }
        this.sharedRepaint();
    }

    public Vertex getLastClickPoint() {
        Vertex vp = new Vertex();
        vp.coord()[this.horizontalAxis] = this.mXPressStart;
        vp.coord()[this.verticalAxis] = this.mYPressStart;
        return vp;
    }

    public Vertex getCurrentPoint() {
        Vertex vp = new Vertex();
        vp.coord()[this.horizontalAxis] = this.lastCrossX;
        vp.coord()[this.verticalAxis] = this.lastCrossY;
        return vp;
    }

    public Vertex getLastReleasePoint() {
        Vertex vp = new Vertex();
        vp.coord()[this.horizontalAxis] = this.mXRelease;
        vp.coord()[this.verticalAxis] = this.mYRelease;
        return vp;
    }

    public void continueVector(GFXVector old) {
        if (old == null) {
            this.vars.continueMode = false;
            this.mXPressStart = this.lastCrossX;
            this.mYPressStart = this.lastCrossY;
            return;
        }
        this.vars.continueMode = true;
        this.vars.continueStart = new Vertex(old.end);
        for (SingleVectorPanel svp : this.vars.siblings) {
            Vertex p = svp.convertFromVectrex(this.vars.continueStart);
            svp.mXPressStart = (int)p.coord()[svp.horizontalAxis];
            svp.mYPressStart = (int)p.coord()[svp.verticalAxis];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<GFXVector> getSelectedPointVectors() {
        ArrayList<GFXVector> vec = new ArrayList<GFXVector>();
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                if (v.start.selected) {
                    vec.add(v);
                    continue;
                }
                if (!v.end.selected) continue;
                vec.add(v);
            }
        }
        return vec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unselectAll() {
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                v.start.selected = false;
                v.end.selected = false;
                v.selected = false;
            }
            this.clearSelectedVertice();
        }
        this.sharedRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unselectAllVectors() {
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                v.selected = false;
            }
        }
        this.sharedRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<GFXVector> getSelectedVectors() {
        ArrayList<GFXVector> ret = new ArrayList<GFXVector>();
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                if (!v.selected) continue;
                ret.add(v);
            }
        }
        return ret;
    }

    public GFXVectorList getSelectedVectorList() {
        GFXVectorList ret = this.getForegroundVectorList().clone();
        ArrayList<GFXVector> toRemove = new ArrayList<GFXVector>();
        for (int i = 0; i < ret.size(); ++i) {
            if (ret.get((int)i).selected) continue;
            toRemove.add(ret.get(i));
        }
        for (GFXVector v : toRemove) {
            ret.remove(v);
        }
        return ret;
    }

    private void fixRelativeByUID(int row, int uid) {
        GFXVector vector = this.vars.foregroundVectors.get(row);
        GFXVector other = null;
        for (int i = 0; i < this.vars.foregroundVectors.size(); ++i) {
            if (this.vars.foregroundVectors.get((int)i).uid != uid) continue;
            other = this.vars.foregroundVectors.get(i);
            break;
        }
        if (other == null) {
            System.out.println("UID of other vector not known - cannot connect!");
            return;
        }
        if (vector.uid_start_connect == uid) {
            vector.start_connect = other;
        } else if (vector.uid_end_connect == uid) {
            vector.end_connect = other;
        }
        if (other.uid_start_connect == -1) {
            other.uid_start_connect = vector.uid;
            other.start_connect = vector;
        } else if (other.uid_end_connect == -1) {
            other.uid_end_connect = vector.uid;
            other.end_connect = vector;
        }
    }

    private void fixRelatives() {
        for (int i = 0; i < this.vars.foregroundVectors.size(); ++i) {
            Vertex start = this.vars.foregroundVectors.get((int)i).start;
            Vertex end2 = this.vars.foregroundVectors.get((int)i).end;
            boolean foundStart = false;
            boolean foundEnd = false;
            this.vars.foregroundVectors.get((int)i).start_connect = null;
            this.vars.foregroundVectors.get((int)i).uid_start_connect = -1;
            this.vars.foregroundVectors.get((int)i).end_connect = null;
            this.vars.foregroundVectors.get((int)i).uid_end_connect = -1;
            for (int j = 0; j < this.vars.foregroundVectors.size(); ++j) {
                if (j == i) continue;
                if (start.uid == this.vars.foregroundVectors.get((int)j).start.uid) {
                    this.vars.foregroundVectors.get((int)i).start_connect = this.vars.foregroundVectors.get(j);
                    this.vars.foregroundVectors.get((int)i).uid_start_connect = this.vars.foregroundVectors.get((int)j).uid;
                    foundStart = true;
                }
                if (start.uid == this.vars.foregroundVectors.get((int)j).end.uid) {
                    this.vars.foregroundVectors.get((int)i).start_connect = this.vars.foregroundVectors.get(j);
                    this.vars.foregroundVectors.get((int)i).uid_start_connect = this.vars.foregroundVectors.get((int)j).uid;
                    foundStart = true;
                }
                if (end2.uid == this.vars.foregroundVectors.get((int)j).start.uid) {
                    this.vars.foregroundVectors.get((int)i).end_connect = this.vars.foregroundVectors.get(j);
                    this.vars.foregroundVectors.get((int)i).uid_end_connect = this.vars.foregroundVectors.get((int)j).uid;
                    foundEnd = true;
                }
                if (end2.uid != this.vars.foregroundVectors.get((int)j).end.uid) continue;
                this.vars.foregroundVectors.get((int)i).end_connect = this.vars.foregroundVectors.get(j);
                this.vars.foregroundVectors.get((int)i).uid_end_connect = this.vars.foregroundVectors.get((int)j).uid;
                foundEnd = true;
            }
            if (foundStart && foundEnd) {
                this.vars.foregroundVectors.get(i).setRelativ(true);
                continue;
            }
            this.vars.foregroundVectors.get(i).setRelativ(false);
        }
    }

    public boolean isSelecting() {
        return this.vars.selecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectAllInArea(int x, int y, int w, int h) {
        ArrayList<GFXVector> arrayList;
        if (!this.vars.selecting) {
            return;
        }
        Vertex startOrg = new Vertex();
        Vertex endOrg = new Vertex();
        startOrg.coord()[this.horizontalAxis] = x;
        startOrg.coord()[this.verticalAxis] = y;
        endOrg.coord()[this.horizontalAxis] = x + w;
        endOrg.coord()[this.verticalAxis] = y + h;
        Vertex startVec = this.convertToVectrex(startOrg);
        Vertex endVec = this.convertToVectrex(endOrg);
        double minX = startVec.coord()[this.horizontalAxis];
        double maxX = endVec.coord()[this.horizontalAxis];
        double maxY = startVec.coord()[this.verticalAxis];
        double minY = endVec.coord()[this.verticalAxis];
        this.clearSelectedVertice();
        if (this.vars.workingMode == 2) {
            arrayList = this.vars.foregroundVectors.list;
            synchronized (arrayList) {
                for (GFXVector v : this.vars.foregroundVectors.list) {
                    if (v.start.coord()[this.horizontalAxis] > minX && v.start.coord()[this.horizontalAxis] < maxX && v.start.coord()[this.verticalAxis] > minY && v.start.coord()[this.verticalAxis] < maxY) {
                        v.start.selected = true;
                        this.addVertexSelection(v.start);
                    } else {
                        v.start.selected = false;
                    }
                    if (v.end.coord()[this.horizontalAxis] > minX && v.end.coord()[this.horizontalAxis] < maxX && v.end.coord()[this.verticalAxis] > minY && v.end.coord()[this.verticalAxis] < maxY) {
                        v.end.selected = true;
                        this.addVertexSelection(v.end);
                        continue;
                    }
                    v.end.selected = false;
                }
            }
        }
        if (this.vars.workingMode == 1) {
            arrayList = this.vars.foregroundVectors.list;
            synchronized (arrayList) {
                for (GFXVector v : this.vars.foregroundVectors.list) {
                    boolean in = true;
                    in = v.start.coord()[this.horizontalAxis] > minX && v.start.coord()[this.horizontalAxis] < maxX && v.start.coord()[this.verticalAxis] > minY && v.start.coord()[this.verticalAxis] < maxY;
                    in = v.end.coord()[this.horizontalAxis] > minX && v.end.coord()[this.horizontalAxis] < maxX && v.end.coord()[this.verticalAxis] > minY && v.end.coord()[this.verticalAxis] < maxY ? (in &= true) : false;
                    v.selected = in;
                }
            }
        }
    }

    public void addZOffset(int v) {
        if (this.usePrivateOffset) {
            this.zOffset += v;
            this.repaint();
            return;
        }
        this.zOffset += v;
        this.vars.zOffset += v;
        this.sharedRepaint();
    }

    public void addYOffset(int v) {
        if (this.usePrivateOffset) {
            this.yOffset += v;
            this.repaint();
            return;
        }
        this.yOffset += v;
        this.vars.yOffset += v;
        this.sharedRepaint();
    }

    public void addXOffset(int v) {
        if (this.usePrivateOffset) {
            this.xOffset += v;
            this.repaint();
            return;
        }
        this.xOffset += v;
        this.vars.xOffset += v;
        this.sharedRepaint();
    }

    void updateAndRepaint() {
        int width = this.getWidth();
        int height = this.getHeight();
        int nextBuffer = (this.bufferUsed + 1) % 2;
        this.paintBufferImage[nextBuffer] = UtilityImage.getNewImage(width, height);
        if (this.paintBufferImage[nextBuffer] == null) {
            return;
        }
        Graphics2D g = this.paintBufferImage[nextBuffer].createGraphics();
        this.doPaint(g);
        this.bufferUsed = nextBuffer;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaint(Graphics2D g) {
        double x0;
        int usedxOff = this.usePrivateOffset ? this.xOffset : this.vars.xOffset;
        int usedyOff = this.usePrivateOffset ? this.yOffset : this.vars.yOffset;
        Color c = g.getColor();
        g.setColor(VectorColors.VECCI_BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if ((this.vars.workingMode == 2 || this.vars.workingMode == 1) && this.vars.displayDragSelection && this.vars.selecting) {
            if (this.vars.dragging || this.vars.pressed) {
                Color dragArea = VectorColors.VECCI_DRAG_AREA_COLOR;
                g.setColor(dragArea);
                int x = this.mXPressStart;
                int y = this.mYPressStart;
                int w = this.mX - this.mXPressStart;
                int h = this.mY - this.mYPressStart;
                if (this.mX < this.mXPressStart) {
                    x = this.mX;
                    w = this.mXPressStart - this.mX;
                }
                if (this.mY < this.mYPressStart) {
                    y = this.mY;
                    h = this.mYPressStart - this.mY;
                }
                g.fillRect(x, y, w, h);
                this.selWidth = w;
                this.selHeight = h;
            } else {
                this.selWidth = 0;
                this.selHeight = 0;
            }
        }
        int potentialCrossX = 10000000;
        int potentialCrossY = 10000000;
        g.setColor(VectorColors.VECCI_GRID_COLOR);
        double scaleUse = this.usePrivateScale ? this.scale : this.vars.scale;
        int xg0 = Scaler.unscaleDoubleToInt(this.x0Offset, scaleUse) - usedxOff;
        int xg1 = Scaler.unscaleDoubleToInt(-this.x0Offset, scaleUse) - usedxOff;
        int yg0 = Scaler.unscaleDoubleToInt(this.y0Offset, scaleUse) - usedyOff;
        int yg1 = Scaler.unscaleDoubleToInt(-this.y0Offset, scaleUse) - usedyOff;
        if (this.vars.displayGrid) {
            int counter = 0;
            int GRID_NOW = this.vars.gridWidth;
            do {
                int yPositive;
                if (Math.abs((yPositive = this.y0Offset + Scaler.scaleDoubleToInt(counter * GRID_NOW, scaleUse)) - this.mY) >= Math.abs(potentialCrossY)) continue;
                potentialCrossY = yPositive - this.mY;
            } while (this.y0Offset + Scaler.scaleDoubleToInt(++counter * GRID_NOW, scaleUse) < this.getHeight());
            boolean drawGrid = (counter *= 2) < this.getHeight() / 2;
            counter = 0;
            do {
                int yPositive;
                if (Math.abs((yPositive = this.y0Offset + Scaler.scaleDoubleToInt(counter * GRID_NOW + usedyOff, scaleUse)) - this.mY) < Math.abs(potentialCrossY)) {
                    potentialCrossY = yPositive - this.mY;
                }
                if (!drawGrid) continue;
                this.drawVectrexScaledLine(g, xg0, counter * GRID_NOW, xg1, counter * GRID_NOW, false, null, false, false, 0, null);
            } while (this.y0Offset + Scaler.scaleDoubleToInt(++counter * GRID_NOW + usedyOff, scaleUse) < this.getHeight());
            counter = 0;
            do {
                int yNegative;
                if (Math.abs((yNegative = this.y0Offset - Scaler.scaleDoubleToInt(counter * GRID_NOW - usedyOff, scaleUse)) - this.mY) < Math.abs(potentialCrossY)) {
                    potentialCrossY = yNegative - this.mY;
                }
                if (!drawGrid) continue;
                this.drawVectrexScaledLine(g, xg0, -(counter * GRID_NOW), xg1, -(counter * GRID_NOW), false, null, false, false, 0, null);
            } while (this.y0Offset - Scaler.scaleDoubleToInt(++counter * GRID_NOW - usedyOff, scaleUse) > 0);
            counter = 0;
            do {
                int xPositive;
                if (Math.abs((xPositive = this.x0Offset + Scaler.scaleDoubleToInt(counter * GRID_NOW + usedxOff, scaleUse)) - this.mX) < Math.abs(potentialCrossX)) {
                    potentialCrossX = xPositive - this.mX;
                }
                if (!drawGrid) continue;
                this.drawVectrexScaledLine(g, counter * GRID_NOW, yg0, counter * GRID_NOW, yg1, false, null, false, false, 0, null);
            } while (this.x0Offset + Scaler.scaleDoubleToInt(++counter * GRID_NOW + usedxOff, scaleUse) < this.getWidth());
            counter = 0;
            do {
                int xNegative;
                if (Math.abs((xNegative = this.x0Offset - Scaler.scaleDoubleToInt(counter * GRID_NOW - usedxOff, scaleUse)) - this.mX) < Math.abs(potentialCrossX)) {
                    potentialCrossX = xNegative - this.mX;
                }
                if (!drawGrid) continue;
                this.drawVectrexScaledLine(g, -(counter * GRID_NOW), yg0, -(counter * GRID_NOW), yg1, false, null, false, false, 0, null);
            } while (this.x0Offset - Scaler.scaleDoubleToInt(++counter * GRID_NOW - usedxOff, scaleUse) > 0);
        }
        if (this.vars.drawByteFrame) {
            g.setColor(VectorColors.VECCI_FRAME_COLOR);
            int x02 = -128;
            int x1 = 127;
            int y0 = -128;
            int y1 = 127;
            this.drawVectrexScaledLine(g, x02, y0, x1, y0, false, null, false, false, 0, null);
            this.drawVectrexScaledLine(g, x02, y0, x02, y1, false, null, false, false, 0, null);
            this.drawVectrexScaledLine(g, x1, y0, x1, y1, false, null, false, false, 0, null);
            this.drawVectrexScaledLine(g, x02, y1, x1, y1, false, null, false, false, 0, null);
        }
        potentialCrossX += this.mX;
        potentialCrossY += this.mY;
        for (GFXVector x1 : this.vars.backgroundVectors.list) {
        }
        ArrayList<GFXVector> x02 = this.vars.foregroundVectors.list;
        synchronized (x02) {
            int pos = 0;
            for (GFXVector v : this.vars.foregroundVectors.list) {
                x0 = v.start.coord()[this.horizontalAxis];
                double y0 = v.start.coord()[this.verticalAxis] * -1.0;
                double x1 = v.end.coord()[this.horizontalAxis];
                double y1 = v.end.coord()[this.verticalAxis] * -1.0;
                g.setColor(new Color(v.r, v.g, v.b, v.a));
                if (v.pattern != 255) {
                    if (v.pattern != 0 || !this.vars.drawMoves) {
                        if (v.pattern == 0) {
                            g.setColor(VectorColors.VECCI_MOVE_COLOR);
                        }
                        float[] pattern = this.getPattern(v);
                        BasicStroke dashed = new BasicStroke(0.0f, 0, 2, 1.0f, pattern, 0.0f);
                        this.drawVectrexScaledLine(g, (int)x0, (int)y0, (int)x1, (int)y1, true, dashed, this.vars.drawArrows, this.vars.drawPositions, pos++, v);
                        continue;
                    }
                    g.setColor(VectorColors.VECCI_MOVE_COLOR);
                    this.drawVectrexScaledLine(g, (int)x0, (int)y0, (int)x1, (int)y1, true, null, this.vars.drawArrows, this.vars.drawPositions, pos++, v);
                    continue;
                }
                this.drawVectrexScaledLine(g, (int)x0, (int)y0, (int)x1, (int)y1, true, null, this.vars.drawArrows, this.vars.drawPositions, pos++, v);
            }
        }
        if (this.vars.hightLightVPoint != null && this.vars.hightLightVPoint.highlight) {
            double x03 = this.vars.hightLightVPoint.coord()[this.horizontalAxis] + (double)usedxOff;
            double y0 = (this.vars.hightLightVPoint.coord()[this.verticalAxis] - (double)usedyOff) * -1.0;
            if (this.vars.isScale) {
                x03 = this.x0Offset + Scaler.scaleDoubleToInt(x03, scaleUse);
                y0 = this.y0Offset + Scaler.scaleDoubleToInt(y0, scaleUse);
            } else {
                x03 = (double)this.x0Offset + x03;
                y0 = (double)this.x0Offset + y0;
            }
            g.setColor(VectorColors.VECCI_POINT_HIGHLIGHT_COLOR);
            g.drawOval((int)x03 - this.vars.POINT_HIGHLIGHT_RADIUS, (int)y0 - this.vars.POINT_HIGHLIGHT_RADIUS, this.vars.POINT_HIGHLIGHT_RADIUS * 2, this.vars.POINT_HIGHLIGHT_RADIUS * 2);
        }
        if (this.vars.hightLightVector != null && this.vars.hightLightVector.highlight) {
            double x04 = this.vars.hightLightVector.start.coord()[this.horizontalAxis] + (double)usedxOff;
            double y0 = (this.vars.hightLightVector.start.coord()[this.verticalAxis] - (double)usedyOff) * -1.0;
            double x1 = this.vars.hightLightVector.end.coord()[this.horizontalAxis] + (double)usedxOff;
            double y1 = (this.vars.hightLightVector.end.coord()[this.verticalAxis] - (double)usedyOff) * -1.0;
            if (this.vars.isScale) {
                x04 = this.x0Offset + Scaler.scaleDoubleToInt(x04, scaleUse);
                y0 = this.y0Offset + Scaler.scaleDoubleToInt(y0, scaleUse);
                x1 = this.x0Offset + Scaler.scaleDoubleToInt(x1, scaleUse);
                y1 = this.y0Offset + Scaler.scaleDoubleToInt(y1, scaleUse);
            } else {
                x04 = (double)this.x0Offset + x04;
                y0 = (double)this.x0Offset + y0;
                x1 = (double)this.x0Offset + x1;
                y1 = (double)this.x0Offset + y1;
            }
            g.setColor(VectorColors.VECCI_VECTOR_HIGHLIGHT_COLOR);
            double py = x04 - x1;
            double px = -(y0 - y1);
            double l = Math.sqrt(Math.pow(py, 2.0) + Math.pow(px, 2.0));
            double transition = this.vars.VECTOR_HIGHLIGHT_RADIUS;
            double px0 = x04 + transition / l * px;
            double py0 = y0 + transition / l * py;
            double px1 = x1 + transition / l * px;
            double py1 = y1 + transition / l * py;
            double transition2 = -this.vars.VECTOR_HIGHLIGHT_RADIUS;
            double px02 = x04 + transition2 / l * px;
            double py02 = y0 + transition2 / l * py;
            double px12 = x1 + transition2 / l * px;
            double py12 = y1 + transition2 / l * py;
            g.drawLine((int)px0, (int)py0, (int)px1, (int)py1);
            g.drawLine((int)px02, (int)py02, (int)px12, (int)py12);
            g.drawLine((int)px0, (int)py0, (int)px02, (int)py02);
            g.drawLine((int)px1, (int)py1, (int)px12, (int)py12);
        }
        ArrayList<GFXVector> arrayList = this.vars.foregroundVectors.list;
        synchronized (arrayList) {
            for (GFXVector v : this.vars.foregroundVectors.list) {
                double y0;
                if (v.selected) {
                    double x05 = v.start.coord()[this.horizontalAxis] + (double)usedxOff;
                    double y02 = (v.start.coord()[this.verticalAxis] - (double)usedyOff) * -1.0;
                    double x1 = v.end.coord()[this.horizontalAxis] + (double)usedxOff;
                    double y1 = (v.end.coord()[this.verticalAxis] - (double)usedyOff) * -1.0;
                    if (this.vars.isScale) {
                        x05 = this.x0Offset + Scaler.scaleDoubleToInt(x05, scaleUse);
                        y02 = this.y0Offset + Scaler.scaleDoubleToInt(y02, scaleUse);
                        x1 = this.x0Offset + Scaler.scaleDoubleToInt(x1, scaleUse);
                        y1 = this.y0Offset + Scaler.scaleDoubleToInt(y1, scaleUse);
                    } else {
                        x05 = (double)this.x0Offset + x05;
                        y02 = (double)this.x0Offset + y02;
                        x1 = (double)this.x0Offset + x1;
                        y1 = (double)this.x0Offset + y1;
                    }
                    g.setColor(VectorColors.VECCI_VECTOR_SELECTED_COLOR);
                    double py = x05 - x1;
                    double px = -(y02 - y1);
                    double l = Math.sqrt(Math.pow(py, 2.0) + Math.pow(px, 2.0));
                    double transition = this.vars.VECTOR_SELECTED_RADIUS;
                    double px0 = x05 + transition / l * px;
                    double py0 = y02 + transition / l * py;
                    double px1 = x1 + transition / l * px;
                    double py1 = y1 + transition / l * py;
                    double transition2 = -this.vars.VECTOR_SELECTED_RADIUS;
                    double px02 = x05 + transition2 / l * px;
                    double py02 = y02 + transition2 / l * py;
                    double px12 = x1 + transition2 / l * px;
                    double py12 = y1 + transition2 / l * py;
                    g.drawLine((int)px0, (int)py0, (int)px1, (int)py1);
                    g.drawLine((int)px02, (int)py02, (int)px12, (int)py12);
                    g.drawLine((int)px0, (int)py0, (int)px02, (int)py02);
                    g.drawLine((int)px1, (int)py1, (int)px12, (int)py12);
                }
                Vertex s = v.start;
                if (s.selected) {
                    x0 = s.coord()[this.horizontalAxis] + (double)usedxOff;
                    y0 = (s.coord()[this.verticalAxis] - (double)usedyOff) * -1.0;
                    if (this.vars.isScale) {
                        x0 = this.x0Offset + Scaler.scaleDoubleToInt(x0, scaleUse);
                        y0 = this.y0Offset + Scaler.scaleDoubleToInt(y0, scaleUse);
                    } else {
                        x0 = (double)this.x0Offset + x0;
                        y0 = (double)this.x0Offset + y0;
                    }
                    g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                    g.drawOval((int)x0 - this.vars.POINT_SELECTED_RADIUS, (int)y0 - this.vars.POINT_SELECTED_RADIUS, this.vars.POINT_SELECTED_RADIUS * 2, this.vars.POINT_SELECTED_RADIUS * 2);
                }
                s = v.end;
                if (!s.selected) continue;
                x0 = s.coord()[this.horizontalAxis] + (double)usedxOff;
                y0 = (s.coord()[this.verticalAxis] - (double)usedyOff) * -1.0;
                if (this.vars.isScale) {
                    x0 = this.x0Offset + Scaler.scaleDoubleToInt(x0, scaleUse);
                    y0 = this.y0Offset + Scaler.scaleDoubleToInt(y0, scaleUse);
                } else {
                    x0 = (double)this.x0Offset + x0;
                    y0 = (double)this.x0Offset + y0;
                }
                g.setColor(VectorColors.VECCI_POINT_SELECTED_COLOR);
                g.drawOval((int)x0 - this.vars.POINT_SELECTED_RADIUS, (int)y0 - this.vars.POINT_SELECTED_RADIUS, this.vars.POINT_SELECTED_RADIUS * 2, this.vars.POINT_SELECTED_RADIUS * 2);
            }
        }
        if (!this.noCross && this.vars.crossDrawn) {
            if (this.vars.displayGrid) {
                this.lastCrossX = potentialCrossX;
                this.lastCrossY = potentialCrossY;
            } else {
                this.lastCrossX = this.mX;
                this.lastCrossY = this.mY;
            }
            g.setColor(this.vars.crossColor);
            g.drawLine(0, this.lastCrossY, this.getWidth(), this.lastCrossY);
            g.drawLine(this.lastCrossX, 0, this.lastCrossX, this.getHeight());
        }
        if (!this.noCross && this.vars.workingMode == 0 && (this.vars.dragging || this.vars.continueMode)) {
            g.setColor(VectorColors.VECCI_VECTOR_DRAG_COLOR);
            g.drawLine(this.mXPressStart, this.mYPressStart, this.lastCrossX, this.lastCrossY);
        }
        g.setColor(c);
    }

    void clearSelectedVertice() {
        this.vars.selectedVertexOrder.clear();
    }

    void addVertexSelection(Vertex v) {
        if (v == null) {
            return;
        }
        this.vars.selectedVertexOrder.remove(v);
        this.vars.selectedVertexOrder.add(v);
    }

    void removeVertexSelection(Vertex v) {
        if (v == null) {
            return;
        }
        this.vars.selectedVertexOrder.remove(v);
    }

    public ArrayList<Vertex> getPointSelectionOrder() {
        return this.vars.selectedVertexOrder;
    }

    public boolean isGrid() {
        return this.vars.displayGrid;
    }

    public class MyTableModel
    extends AbstractTableModel {
        public final String[] NAMES = new String[]{"uid", "x0", "y0", "z0", "x1", "y1", "z1", "relativ", "next", "previous", "order", "pattern", "intensity", "x_len", "y_len", "z_len", "factor", "R", "G", "B"};

        @Override
        public int getColumnCount() {
            if (displayLen) {
                return 16;
            }
            return 13;
        }

        @Override
        public int getRowCount() {
            return SingleVectorPanel.this.vars.foregroundVectors.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).uid;
            }
            if (col == 1) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.x();
            }
            if (col == 2) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.y();
            }
            if (col == 3) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.z();
            }
            if (col == 4) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.x();
            }
            if (col == 5) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.y();
            }
            if (col == 6) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.z();
            }
            if (col == 7) {
                return SingleVectorPanel.this.vars.foregroundVectors.get(row).isRelativ();
            }
            if (col == 8) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).uid_end_connect;
            }
            if (col == 9) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).uid_start_connect;
            }
            if (col == 10) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).order;
            }
            if (col == 11) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).pattern;
            }
            if (col == 12) {
                return SingleVectorPanel.this.vars.foregroundVectors.get(row).getIntensity();
            }
            if (col == 13) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.x() - SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.x();
            }
            if (col == 14) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.y() - SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.y();
            }
            if (col == 15) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.z() - SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.z();
            }
            if (col == 16) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).factor;
            }
            if (col == 17) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).r;
            }
            if (col == 18) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).g;
            }
            if (col == 19) {
                return SingleVectorPanel.this.vars.foregroundVectors.get((int)row).b;
            }
            return "-";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return false;
            }
            if (col == 7) {
                return false;
            }
            if (col == 13) {
                return false;
            }
            if (col == 14) {
                return false;
            }
            return col != 15;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Integer.class;
            }
            if (col == 1) {
                return Double.class;
            }
            if (col == 2) {
                return Double.class;
            }
            if (col == 3) {
                return Double.class;
            }
            if (col == 4) {
                return Double.class;
            }
            if (col == 5) {
                return Double.class;
            }
            if (col == 6) {
                return Double.class;
            }
            if (col == 7) {
                return Boolean.class;
            }
            if (col == 8) {
                return Integer.class;
            }
            if (col == 9) {
                return Integer.class;
            }
            if (col == 10) {
                return Integer.class;
            }
            if (col == 11) {
                return Integer.class;
            }
            if (col == 12) {
                return Integer.class;
            }
            if (col == 13) {
                return Double.class;
            }
            if (col == 14) {
                return Double.class;
            }
            if (col == 15) {
                return Double.class;
            }
            if (col == 16) {
                return Integer.class;
            }
            if (col == 17) {
                return Integer.class;
            }
            if (col == 18) {
                return Integer.class;
            }
            if (col == 19) {
                return Integer.class;
            }
            return Object.class;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            SingleVectorPanel.this.fireVectorPreChange();
            if (col == 1) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.x((Double)aValue);
            }
            if (col == 2) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.y((Double)aValue);
            }
            if (col == 3) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).start.z((Double)aValue);
            }
            if (col == 4) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.x((Double)aValue);
            }
            if (col == 5) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.y((Double)aValue);
            }
            if (col == 6) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).end.z((Double)aValue);
            }
            if (col == 8) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).uid_end_connect = (Integer)aValue;
                SingleVectorPanel.this.fixRelativeByUID(row, (Integer)aValue);
            }
            if (col == 9) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).uid_start_connect = (Integer)aValue;
                SingleVectorPanel.this.fixRelativeByUID(row, (Integer)aValue);
            }
            if (col == 10) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).order = (Integer)aValue;
            }
            if (col == 11) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).pattern = (Integer)aValue;
            }
            if (col == 12) {
                SingleVectorPanel.this.vars.foregroundVectors.get(row).setIntensity((Integer)aValue);
            }
            if (col == 13) {
                // empty if block
            }
            if (col == 14) {
                // empty if block
            }
            if (col == 15) {
                // empty if block
            }
            if (col == 16) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).factor = (Integer)aValue;
            }
            if (col == 17) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).r = (Integer)aValue;
            }
            if (col == 18) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).g = (Integer)aValue;
            }
            if (col == 19) {
                SingleVectorPanel.this.vars.foregroundVectors.get((int)row).b = (Integer)aValue;
            }
            SingleVectorPanel.this.fixRelatives();
            SingleVectorPanel.this.sharedRepaint();
            SingleVectorPanel.this.fireVectorPostChange();
        }

        @Override
        public String getColumnName(int col) {
            return this.NAMES[col];
        }
    }

    public class SharedVars {
        ArrayList<SingleVectorPanel> siblings = new ArrayList();
        Vector<MouseMovedListener> mMovedListener = new Vector();
        Vector<MousePressedListener> mPressedListener = new Vector();
        Vector<MouseReleasedListener> mReleasedListener = new Vector();
        Vector<VectorChangedListener> mVectorListener = new Vector();
        boolean shareRepaintEnabled = true;
        int gridWidth = 10;
        boolean displayGrid = true;
        boolean continueMode = false;
        public boolean allwaysInt = false;
        Vertex continueStart = new Vertex();
        Vertex hightLightVPoint = null;
        ArrayList<Vertex> selectedVertexOrder = new ArrayList();
        GFXVector hightLightVector = null;
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        public int workingMode = 0;
        int POINT_HIGHLIGHT_RANGE = 10;
        int POINT_HIGHLIGHT_RADIUS = 5;
        int POINT_SELECTED_RADIUS = 7;
        int VECTOR_HIGHLIGHT_RANGE = 10;
        int VECTOR_HIGHLIGHT_RADIUS = 3;
        int VECTOR_SELECTED_RADIUS = 5;
        Color crossColor = VectorColors.VECCI_CROSS_COLOR;
        boolean isScale = false;
        boolean crossDrawn = true;
        boolean noMouseReaction = false;
        boolean drawArrows = false;
        boolean drawPositions = false;
        boolean drawMoves = false;
        boolean realyBigEnd = true;
        double scale = 1.0;
        GFXVectorList foregroundVectors = new GFXVectorList();
        GFXVectorList backgroundVectors = new GFXVectorList();
        int vectorWidth = 1;
        boolean shiftPressed = false;
        boolean ctrlPressed = false;
        boolean pressed = false;
        boolean selecting = true;
        boolean dragging = false;
        boolean displayDragSelection = true;
        boolean drawByteFrame = true;
        MyTableModel dataModel = new MyTableModel();

        SharedVars(SingleVectorPanel svp) {
            this.siblings.add(svp);
        }
    }
}

