/*
 * Decompiled with CFR 0.152.
 */
package de.malban.graphics;

import de.malban.util.XMLSupport;
import java.util.ArrayList;

public class Vertex
implements Comparable {
    private static int UID = 0;
    public int uid = ++UID;
    public int load_uid = 0;
    public static int ARRAY_X = 0;
    public static int ARRAY_Y = 1;
    public static int ARRAY_Z = 2;
    public static int ARRAY_W = 3;
    public double[] coords = new double[4];
    boolean[] usage = new boolean[4];
    public boolean selected = false;
    public boolean highlight = false;
    public ArrayList<String> face = new ArrayList();

    public void resetSelection() {
        this.selected = false;
        this.highlight = false;
    }

    public void resetDisplay() {
        this.selected = false;
        this.highlight = false;
    }

    public boolean equals(Vertex p) {
        if (this.coords[ARRAY_X] != p.coords[ARRAY_X]) {
            return false;
        }
        if (this.coords[ARRAY_Y] != p.coords[ARRAY_Y]) {
            return false;
        }
        if (this.coords[ARRAY_Z] != p.coords[ARRAY_Z]) {
            return false;
        }
        if (this.coords[ARRAY_W] != p.coords[ARRAY_W]) {
            return false;
        }
        if (this.usage[ARRAY_X] != p.usage[ARRAY_X]) {
            return false;
        }
        if (this.usage[ARRAY_Y] != p.usage[ARRAY_Y]) {
            return false;
        }
        if (this.usage[ARRAY_Z] != p.usage[ARRAY_Z]) {
            return false;
        }
        return this.usage[ARRAY_W] == p.usage[ARRAY_W];
    }

    public Vertex() {
        this.coords[Vertex.ARRAY_X] = 0.0;
        this.coords[Vertex.ARRAY_Y] = 0.0;
        this.coords[Vertex.ARRAY_Z] = 0.0;
        this.coords[Vertex.ARRAY_W] = 1.0;
        this.usage[Vertex.ARRAY_X] = true;
        this.usage[Vertex.ARRAY_Y] = true;
        this.usage[Vertex.ARRAY_Z] = true;
        this.usage[Vertex.ARRAY_W] = true;
    }

    public Vertex(Vertex p) {
        this.set(p);
    }

    public Vertex(double _x, double _y, double _z) {
        this.coords[Vertex.ARRAY_X] = _x;
        this.coords[Vertex.ARRAY_Y] = _y;
        this.coords[Vertex.ARRAY_Z] = _z;
        this.coords[Vertex.ARRAY_W] = 1.0;
        this.usage[Vertex.ARRAY_X] = true;
        this.usage[Vertex.ARRAY_Y] = true;
        this.usage[Vertex.ARRAY_Z] = true;
        this.usage[Vertex.ARRAY_W] = true;
    }

    public final void set(Vertex p) {
        double[] c = new double[4];
        boolean[] u = new boolean[4];
        if (p == null) {
            return;
        }
        c[Vertex.ARRAY_X] = p.coords[ARRAY_X];
        c[Vertex.ARRAY_Y] = p.coords[ARRAY_Y];
        c[Vertex.ARRAY_Z] = p.coords[ARRAY_Z];
        c[Vertex.ARRAY_W] = p.coords[ARRAY_W];
        u[Vertex.ARRAY_X] = p.usage[ARRAY_X];
        u[Vertex.ARRAY_Y] = p.usage[ARRAY_Y];
        u[Vertex.ARRAY_Z] = p.usage[ARRAY_Z];
        u[Vertex.ARRAY_W] = p.usage[ARRAY_W];
        this.selected = p.selected;
        this.highlight = p.highlight;
        this.coords = c;
        this.usage = u;
        ArrayList<String> faceNew = new ArrayList<String>();
        for (String f : p.face) {
            faceNew.add(f);
        }
        this.face = faceNew;
    }

    public String toString() {
        return "x: " + this.coords[ARRAY_X] + ", y:" + this.coords[ARRAY_Y] + ", z:" + this.coords[ARRAY_Z];
    }

    public double[] coord() {
        return this.coords;
    }

    public boolean x_use() {
        return this.usage[ARRAY_X];
    }

    public boolean y_use() {
        return this.usage[ARRAY_Y];
    }

    public boolean z_use() {
        return this.usage[ARRAY_Z];
    }

    public boolean w_use() {
        return this.usage[ARRAY_W];
    }

    public double x() {
        return this.coords[ARRAY_X];
    }

    public double y() {
        return this.coords[ARRAY_Y];
    }

    public double z() {
        return this.coords[ARRAY_Z];
    }

    public double w() {
        return this.coords[ARRAY_W];
    }

    public void x(double x) {
        this.coords[Vertex.ARRAY_X] = x;
    }

    public void y(double y) {
        this.coords[Vertex.ARRAY_Y] = y;
    }

    public void z(double z) {
        this.coords[Vertex.ARRAY_Z] = z;
    }

    public void w(double w) {
        this.coords[Vertex.ARRAY_W] = w;
    }

    public boolean toXML(StringBuilder s, String tag) {
        s.append("<").append(tag).append(">\n");
        boolean ok = true;
        ok &= XMLSupport.addElement(s, "x", this.coords[ARRAY_X]);
        ok &= XMLSupport.addElement(s, "y", this.coords[ARRAY_Y]);
        ok &= XMLSupport.addElement(s, "z", this.coords[ARRAY_Z]);
        ok &= XMLSupport.addElement(s, "w", this.coords[ARRAY_W]);
        ok &= XMLSupport.addElement(s, "use_x", this.usage[ARRAY_X]);
        ok &= XMLSupport.addElement(s, "use_y", this.usage[ARRAY_Y]);
        ok &= XMLSupport.addElement(s, "use_z", this.usage[ARRAY_Z]);
        ok &= XMLSupport.addElement(s, "use_w", this.usage[ARRAY_W]);
        ok &= XMLSupport.addElement(s, "id", this.uid);
        for (String f : this.face) {
            ok &= XMLSupport.addElement(s, "face", f);
        }
        s.append("</").append(tag).append(">\n");
        return ok;
    }

    public boolean fromXML(StringBuilder xml, XMLSupport xmlSupport) {
        int errorCode = 0;
        this.x(xmlSupport.getDoubleElement("x", xml));
        errorCode |= xmlSupport.errorCode;
        this.y(xmlSupport.getDoubleElement("y", xml));
        errorCode |= xmlSupport.errorCode;
        this.z(xmlSupport.getDoubleElement("z", xml));
        errorCode |= xmlSupport.errorCode;
        this.w(xmlSupport.getDoubleElement("w", xml));
        errorCode |= xmlSupport.errorCode;
        this.usage[Vertex.ARRAY_X] = xmlSupport.getBooleanElement("use_x", xml);
        errorCode |= xmlSupport.errorCode;
        this.usage[Vertex.ARRAY_Y] = xmlSupport.getBooleanElement("use_y", xml);
        errorCode |= xmlSupport.errorCode;
        this.usage[Vertex.ARRAY_Z] = xmlSupport.getBooleanElement("use_z", xml);
        errorCode |= xmlSupport.errorCode;
        this.usage[Vertex.ARRAY_W] = xmlSupport.getBooleanElement("use_w", xml);
        errorCode |= xmlSupport.errorCode;
        this.load_uid = xmlSupport.getIntElement("id", xml);
        this.face = new ArrayList();
        while (true) {
            String faceInt = xmlSupport.getStringElement("face", xml, false);
            if (xmlSupport.errorCode != 0) break;
            this.face.add(faceInt);
        }
        return errorCode == 0;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public String buildCompareId() {
        String id = this.toString();
        for (String s : this.face) {
            id = id + s;
        }
        return id + this.load_uid;
    }
}

