/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gtest;

import de.malban.gtest.CvHLines;
import de.malban.gtest.HPGL;
import de.malban.gtest.Obj3D;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class HLines
extends Frame {
    private MenuItem open;
    private MenuItem exportHPGL;
    private MenuItem exit;
    private MenuItem eyeUp;
    private MenuItem eyeDown;
    private MenuItem eyeLeft;
    private MenuItem eyeRight;
    private MenuItem incrDist;
    private MenuItem decrDist;
    private CvHLines cv = new CvHLines();
    private String sDir;

    public static void main(String[] args) {
        new HLines(args.length > 0 ? args[0] : null);
    }

    public HLines(String argFileName) {
        super("Hidden-lines algorithm");
        Obj3D obj;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MenuBar mBar = new MenuBar();
        this.setMenuBar(mBar);
        Menu mF = new Menu("File");
        Menu mV = new Menu("View");
        mBar.add(mF);
        mBar.add(mV);
        this.open = new MenuItem("Open", new MenuShortcut(79));
        this.exportHPGL = new MenuItem("Export HP-GL");
        this.exit = new MenuItem("Exit", new MenuShortcut(81));
        this.eyeDown = new MenuItem("Viewpoint Down", new MenuShortcut(40));
        this.eyeUp = new MenuItem("Viewpoint Up", new MenuShortcut(38));
        this.eyeLeft = new MenuItem("Viewpoint to Left", new MenuShortcut(37));
        this.eyeRight = new MenuItem("Viewpoint to Right", new MenuShortcut(39));
        this.incrDist = new MenuItem("Increase viewing distance", new MenuShortcut(155));
        this.decrDist = new MenuItem("Decrease viewing distance", new MenuShortcut(127));
        mF.add(this.open);
        mF.add(this.exportHPGL);
        mF.add(this.exit);
        mV.add(this.eyeDown);
        mV.add(this.eyeUp);
        mV.add(this.eyeLeft);
        mV.add(this.eyeRight);
        mV.add(this.incrDist);
        mV.add(this.decrDist);
        MenuCommands mListener = new MenuCommands();
        this.open.addActionListener(mListener);
        this.exportHPGL.addActionListener(mListener);
        this.exit.addActionListener(mListener);
        this.eyeDown.addActionListener(mListener);
        this.eyeUp.addActionListener(mListener);
        this.eyeLeft.addActionListener(mListener);
        this.eyeRight.addActionListener(mListener);
        this.incrDist.addActionListener(mListener);
        this.decrDist.addActionListener(mListener);
        this.add("Center", this.cv);
        Dimension dim = this.getToolkit().getScreenSize();
        this.setSize(dim.width / 2, dim.height / 2);
        this.setLocation(dim.width / 4, dim.height / 4);
        if (argFileName != null && (obj = new Obj3D()).read(argFileName)) {
            this.cv.setObj(obj);
            this.cv.repaint();
        }
        this.show();
    }

    void vp(float dTheta, float dPhi, float fRho) {
        Obj3D obj = this.cv.getObj();
        if (obj == null || !obj.vp(this.cv, dTheta, dPhi, fRho)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class MenuCommands
    implements ActionListener {
        MenuCommands() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() instanceof MenuItem) {
                MenuItem mi = (MenuItem)ae.getSource();
                if (mi == HLines.this.open) {
                    FileDialog fDia = new FileDialog((Frame)HLines.this, "Open", 0);
                    fDia.setDirectory(HLines.this.sDir);
                    fDia.setFile("*.dat");
                    fDia.show();
                    String sDir1 = fDia.getDirectory();
                    String sFile = fDia.getFile();
                    String fName = sDir1 + sFile;
                    Obj3D obj = new Obj3D();
                    if (obj.read(fName)) {
                        HLines.this.sDir = sDir1;
                        HLines.this.cv.setObj(obj);
                        HLines.this.cv.repaint();
                    }
                } else if (mi == HLines.this.exportHPGL) {
                    Obj3D obj = HLines.this.cv.getObj();
                    if (obj != null) {
                        HLines.this.cv.setHPGL(new HPGL(obj));
                        HLines.this.cv.repaint();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (mi == HLines.this.exit) {
                    System.exit(0);
                } else if (mi == HLines.this.eyeDown) {
                    HLines.this.vp(0.0f, 0.1f, 1.0f);
                } else if (mi == HLines.this.eyeUp) {
                    HLines.this.vp(0.0f, -0.1f, 1.0f);
                } else if (mi == HLines.this.eyeLeft) {
                    HLines.this.vp(-0.1f, 0.0f, 1.0f);
                } else if (mi == HLines.this.eyeRight) {
                    HLines.this.vp(0.1f, 0.0f, 1.0f);
                } else if (mi == HLines.this.incrDist) {
                    HLines.this.vp(0.0f, 0.0f, 2.0f);
                } else if (mi == HLines.this.decrDist) {
                    HLines.this.vp(0.0f, 0.0f, 0.5f);
                }
            }
        }
    }
}

