/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gtest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class Input {
    private File f;
    private BufferedInputStream fis;
    private int buf;
    private boolean ok = true;

    Input(String fileName) {
        try {
            File f = new File(fileName);
            this.fis = new BufferedInputStream(new FileInputStream(f));
            this.buf = this.fis.read();
        }
        catch (IOException ioe) {
            this.ok = false;
        }
    }

    void close() {
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (IOException ioe) {
                this.ok = false;
            }
        }
    }

    int readInt() {
        boolean neg = false;
        while (Character.isWhitespace((char)this.buf)) {
            this.nextChar();
        }
        if (this.buf == 45) {
            neg = true;
            this.nextChar();
        }
        if (!Character.isDigit((char)this.buf)) {
            this.ok = false;
            return 0;
        }
        int x = this.buf - 48;
        while (this.nextChar() && Character.isDigit((char)this.buf)) {
            x = 10 * x + (this.buf - 48);
        }
        return neg ? -x : x;
    }

    float readFloat() {
        int nDec = -1;
        boolean neg = false;
        while (Character.isWhitespace((char)this.buf)) {
            this.nextChar();
        }
        if (this.buf == 45) {
            neg = true;
            this.nextChar();
        }
        if (this.buf == 46) {
            nDec = 0;
            this.nextChar();
        }
        if (!Character.isDigit((char)this.buf)) {
            this.ok = false;
            return 0.0f;
        }
        float x = this.buf - 48;
        while (this.nextChar() && (Character.isDigit((char)this.buf) || nDec == -1 && this.buf == 46)) {
            if (this.buf == 46) {
                nDec = 0;
                continue;
            }
            x = 10.0f * x + (float)(this.buf - 48);
            if (nDec < 0) continue;
            ++nDec;
        }
        while (nDec > 0) {
            x = (float)((double)x * 0.1);
            --nDec;
        }
        if (this.buf == 101 || this.buf == 69) {
            this.nextChar();
            if (!this.fails()) {
                int exp;
                for (exp = this.readInt(); exp < 0; ++exp) {
                    x = (float)((double)x * 0.1);
                }
                while (exp > 0) {
                    x *= 10.0f;
                    --exp;
                }
            }
        }
        return neg ? -x : x;
    }

    char readChar() {
        char ch = (char)this.buf;
        this.nextChar();
        return ch;
    }

    boolean eof() {
        return !this.ok && this.buf < 0;
    }

    boolean fails() {
        return !this.ok;
    }

    void clear() {
        this.ok = true;
    }

    private boolean nextChar() {
        if (this.buf < 0) {
            this.ok = false;
        } else {
            try {
                this.buf = this.fis.read();
            }
            catch (IOException ioe) {
                this.ok = false;
            }
        }
        return this.ok;
    }
}

