/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gtest;

import de.malban.gtest.Input;
import de.malban.gtest.Point2D;
import de.malban.gtest.Point3D;
import de.malban.gtest.Polygon3D;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Vector;

class Obj3D {
    private float rho;
    private float d;
    private float theta = 0.3f;
    private float phi = 1.3f;
    private float rhoMin;
    private float rhoMax;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private float zMin;
    private float zMax;
    private float v11;
    private float v12;
    private float v13;
    private float v21;
    private float v22;
    private float v23;
    private float v32;
    private float v33;
    private float v43;
    private float xe;
    private float ye;
    private float ze;
    private float objSize;
    private Point2D imgCenter;
    private double sunZ;
    private double sunY = this.sunZ = 1.0 / Math.sqrt(3.0);
    private double sunX = -this.sunZ;
    private double inprodMin = 1.0E30;
    private double inprodMax = -1.0E30;
    private double inprodRange;
    private Vector w = new Vector();
    private Point3D[] e;
    private Point2D[] vScr;
    private Vector polyList = new Vector();
    private String fName = "";

    Obj3D() {
    }

    boolean read(String fName) {
        Input inp = new Input(fName);
        if (inp.fails()) {
            return this.failing();
        }
        this.fName = fName;
        this.zMin = 1.0E30f;
        this.yMin = 1.0E30f;
        this.xMin = 1.0E30f;
        this.zMax = -1.0E30f;
        this.yMax = -1.0E30f;
        this.xMax = -1.0E30f;
        return this.readObject(inp);
    }

    Vector getPolyList() {
        return this.polyList;
    }

    String getFName() {
        return this.fName;
    }

    Point3D[] getE() {
        return this.e;
    }

    Point2D[] getVScr() {
        return this.vScr;
    }

    Point2D getImgCenter() {
        return this.imgCenter;
    }

    float getRho() {
        return this.rho;
    }

    float getD() {
        return this.d;
    }

    private boolean failing() {
        Toolkit.getDefaultToolkit().beep();
        return false;
    }

    private boolean readObject(Input inp) {
        char ch;
        while (true) {
            int i = inp.readInt();
            if (inp.fails()) break;
            if (i < 0) {
                System.out.println("Negative vertex number in first part of input file");
                return this.failing();
            }
            this.w.ensureCapacity(i + 1);
            float x = inp.readFloat();
            float y = inp.readFloat();
            float z = inp.readFloat();
            this.addVertex(i, x, y, z);
        }
        inp.clear();
        this.shiftToOrigin();
        int count = 0;
        do {
            ch = inp.readChar();
            ++count;
        } while (!inp.eof() && ch != '\n');
        if (count < 6 || count > 8) {
            System.out.println("Invalid input file");
            return this.failing();
        }
        while (true) {
            Vector<Integer> vnrs = new Vector<Integer>();
            while (true) {
                int i = inp.readInt();
                if (inp.fails()) break;
                int absi = Math.abs(i);
                if (i == 0 || absi >= this.w.size() || this.w.elementAt(absi) == null) {
                    System.out.println("Invalid vertex number: " + absi + " must be defined, nonzero and less than " + this.w.size());
                    return this.failing();
                }
                vnrs.addElement(new Integer(i));
            }
            inp.clear();
            ch = inp.readChar();
            if (ch != '.' && ch != '#') break;
            if (vnrs.size() < 2) continue;
            this.polyList.addElement(new Polygon3D(vnrs));
        }
        inp.close();
        return true;
    }

    private void addVertex(int i, float x, float y, float z) {
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        if (z < this.zMin) {
            this.zMin = z;
        }
        if (z > this.zMax) {
            this.zMax = z;
        }
        if (i >= this.w.size()) {
            this.w.setSize(i + 1);
        }
        this.w.setElementAt(new Point3D(x, y, z), i);
    }

    private void shiftToOrigin() {
        float xwC = 0.5f * (this.xMin + this.xMax);
        float ywC = 0.5f * (this.yMin + this.yMax);
        float zwC = 0.5f * (this.zMin + this.zMax);
        int n = this.w.size();
        for (int i = 1; i < n; ++i) {
            if (this.w.elementAt(i) == null) continue;
            ((Point3D)this.w.elementAt((int)i)).x -= xwC;
            ((Point3D)this.w.elementAt((int)i)).y -= ywC;
            ((Point3D)this.w.elementAt((int)i)).z -= zwC;
        }
        float dx = this.xMax - this.xMin;
        float dy = this.yMax - this.yMin;
        float dz = this.zMax - this.zMin;
        this.rhoMin = 0.6f * (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.rhoMax = 1000.0f * this.rhoMin;
        this.rho = 3.0f * this.rhoMin;
    }

    private void initPersp() {
        float costh = (float)Math.cos(this.theta);
        float sinth = (float)Math.sin(this.theta);
        float cosph = (float)Math.cos(this.phi);
        float sinph = (float)Math.sin(this.phi);
        this.v11 = -sinth;
        this.v12 = -cosph * costh;
        this.v13 = sinph * costh;
        this.v21 = costh;
        this.v22 = -cosph * sinth;
        this.v23 = sinph * sinth;
        this.v32 = sinph;
        this.v33 = cosph;
        this.v43 = -this.rho;
    }

    float eyeAndScreen(Dimension dim) {
        this.initPersp();
        int n = this.w.size();
        this.e = new Point3D[n];
        this.vScr = new Point2D[n];
        float xScrMin = 1.0E30f;
        float xScrMax = -1.0E30f;
        float yScrMin = 1.0E30f;
        float yScrMax = -1.0E30f;
        for (int i = 1; i < n; ++i) {
            Point3D P2 = (Point3D)this.w.elementAt(i);
            if (P2 == null) {
                this.e[i] = null;
                this.vScr[i] = null;
                continue;
            }
            float x = this.v11 * P2.x + this.v21 * P2.y;
            float y = this.v12 * P2.x + this.v22 * P2.y + this.v32 * P2.z;
            float z = this.v13 * P2.x + this.v23 * P2.y + this.v33 * P2.z + this.v43;
            Point3D Pe = this.e[i] = new Point3D(x, y, z);
            float xScr = -Pe.x / Pe.z;
            float yScr = -Pe.y / Pe.z;
            this.vScr[i] = new Point2D(xScr, yScr);
            if (xScr < xScrMin) {
                xScrMin = xScr;
            }
            if (xScr > xScrMax) {
                xScrMax = xScr;
            }
            if (yScr < yScrMin) {
                yScrMin = yScr;
            }
            if (!(yScr > yScrMax)) continue;
            yScrMax = yScr;
        }
        float rangeX = xScrMax - xScrMin;
        float rangeY = yScrMax - yScrMin;
        this.d = 0.95f * Math.min((float)dim.width / rangeX, (float)dim.height / rangeY);
        this.imgCenter = new Point2D(this.d * (xScrMin + xScrMax) / 2.0f, this.d * (yScrMin + yScrMax) / 2.0f);
        for (int i = 1; i < n; ++i) {
            if (this.vScr[i] == null) continue;
            this.vScr[i].x *= this.d;
            this.vScr[i].y *= this.d;
        }
        return this.d * Math.max(rangeX, rangeY);
    }

    void planeCoeff() {
        int nFaces = this.polyList.size();
        for (int j = 0; j < nFaces; ++j) {
            Polygon3D pol = (Polygon3D)this.polyList.elementAt(j);
            int[] nrs = pol.getNrs();
            if (nrs.length < 3) continue;
            int iA = Math.abs(nrs[0]);
            int iB = Math.abs(nrs[1]);
            int iC = Math.abs(nrs[2]);
            Point3D A = this.e[iA];
            Point3D B = this.e[iB];
            Point3D C = this.e[iC];
            double u1 = B.x - A.x;
            double u2 = B.y - A.y;
            double u3 = B.z - A.z;
            double v1 = C.x - A.x;
            double v2 = C.y - A.y;
            double v3 = C.z - A.z;
            double a = u2 * v3 - u3 * v2;
            double b = u3 * v1 - u1 * v3;
            double c = u1 * v2 - u2 * v1;
            double len = Math.sqrt(a * a + b * b + c * c);
            double h = (a /= len) * (double)A.x + (b /= len) * (double)A.y + (c /= len) * (double)A.z;
            pol.setAbch(a, b, c, h);
            Point2D A1 = this.vScr[iA];
            Point2D B1 = this.vScr[iB];
            Point2D C1 = this.vScr[iC];
            u1 = B1.x - A1.x;
            u2 = B1.y - A1.y;
            v1 = C1.x - A1.x;
            v2 = C1.y - A1.y;
            if (u1 * v2 - u2 * v1 <= 0.0) continue;
            double inprod = a * this.sunX + b * this.sunY + c * this.sunZ;
            if (inprod < this.inprodMin) {
                this.inprodMin = inprod;
            }
            if (!(inprod > this.inprodMax)) continue;
            this.inprodMax = inprod;
        }
        this.inprodRange = this.inprodMax - this.inprodMin;
    }

    boolean vp(Canvas cv, float dTheta, float dPhi, float fRho) {
        this.theta += dTheta;
        this.phi += dPhi;
        float rhoNew = fRho * this.rho;
        if (!(rhoNew >= this.rhoMin) || !(rhoNew <= this.rhoMax)) {
            return false;
        }
        this.rho = rhoNew;
        cv.repaint();
        return true;
    }

    int colorCode(double a, double b, double c) {
        double inprod = a * this.sunX + b * this.sunY + c * this.sunZ;
        return (int)Math.round((inprod - this.inprodMin) / this.inprodRange * 255.0);
    }
}

