/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui;

import java.awt.Graphics;
import java.awt.Image;

public class BitMapFontViewer {
    public static final byte ABSOLUTE_LINE_BREAK = -2;
    public static final byte ARTIFICAL_LINE_BREAK = -3;
    private final Image image;
    private final short[] xPositions;
    private final byte[] usedCharactersWidths;
    private final int fontHeight;
    private int verticalPadding;
    private final int spaceIndex;
    private int height;
    private int width;
    private int numberOfLines;
    private short[] lineWidths;
    private final int[] indeces;
    private final byte[] actualCharacterWidths;
    private int orientation;

    public BitMapFontViewer(Image image, int[] indeces, short[] xPositions, byte[] characterWidths, int fontHeight, int spaceIndex, int verticalPadding) {
        this.image = image;
        this.indeces = indeces;
        this.actualCharacterWidths = characterWidths;
        this.spaceIndex = spaceIndex;
        this.lineWidths = new short[20];
        this.verticalPadding = verticalPadding;
        this.xPositions = new short[indeces.length];
        this.usedCharactersWidths = new byte[indeces.length];
        int currentLineWidth = 0;
        int maxLineWidth = 0;
        int linesIndex = 0;
        for (int i = 0; i < indeces.length; ++i) {
            byte characterWidth;
            int index = indeces[i];
            if (index == -1) continue;
            if (index == -2) {
                if (currentLineWidth > maxLineWidth) {
                    maxLineWidth = currentLineWidth;
                }
                this.lineWidths[linesIndex] = currentLineWidth;
                currentLineWidth = 0;
                this.usedCharactersWidths[i] = -2;
                if ((linesIndex = (int)((short)(linesIndex + 1))) < this.lineWidths.length) continue;
                this.lineWidths = this.increaseShortArraySize(this.lineWidths, (byte)10);
                continue;
            }
            this.xPositions[i] = xPositions[index];
            this.usedCharactersWidths[i] = characterWidth = characterWidths[index];
            currentLineWidth = (short)(currentLineWidth + characterWidth);
        }
        this.lineWidths[linesIndex] = currentLineWidth;
        if (currentLineWidth > maxLineWidth) {
            maxLineWidth = currentLineWidth;
        }
        this.numberOfLines = linesIndex + 1;
        this.height = this.numberOfLines * (fontHeight + verticalPadding) - verticalPadding;
        this.width = maxLineWidth;
        this.fontHeight = fontHeight;
    }

    public void paint(int x, int y, Graphics g) {
        int clipX = g.getClipBounds().x;
        int clipY = g.getClipBounds().y;
        int clipWidth = g.getClipBounds().width;
        int clipHeight = g.getClipBounds().height;
        int clipXEnd = clipX + clipWidth;
        int startX = x;
        boolean isLayoutRight = false;
        boolean isLayoutCenter = false;
        if (isLayoutCenter) {
            x = startX - this.lineWidths[0] / 2;
        } else if (isLayoutRight) {
            x = startX - this.lineWidths[0];
        }
        int lineIndex = 0;
        for (int i = 0; i < this.xPositions.length; ++i) {
            byte characterWidth = this.usedCharactersWidths[i];
            if (characterWidth == 0) continue;
            if (characterWidth < 0) {
                x = isLayoutCenter ? startX - this.lineWidths[lineIndex] / 2 : (isLayoutRight ? startX - this.lineWidths[++lineIndex] : startX);
                y += this.fontHeight + this.verticalPadding;
                continue;
            }
            if (x >= clipXEnd) continue;
            g.clipRect(x, y, characterWidth, this.fontHeight);
            int imageX = x - this.xPositions[i];
            g.drawImage(this.image, imageX, y, null);
            x += characterWidth;
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void layout(int firstLineWidth, int lineWidth, int paddingVertical, int orientationSetting) {
        this.orientation = orientationSetting;
        this.verticalPadding = paddingVertical;
        int lineIndex = 0;
        int currentLineWidth = 0;
        int maxLineWidth = 0;
        int lastSpaceIndex = -1;
        int lastSpaceWidth = 0;
        int lineStartIndex = 0;
        for (int i = 0; i < this.usedCharactersWidths.length; ++i) {
            byte characterWidth = this.usedCharactersWidths[i];
            if (characterWidth == -3) {
                this.usedCharactersWidths[i] = characterWidth = this.actualCharacterWidths[this.indeces[i]];
            } else if (characterWidth == -2) {
                this.lineWidths[lineIndex] = currentLineWidth;
                if (currentLineWidth > maxLineWidth) {
                    maxLineWidth = currentLineWidth;
                }
                lineStartIndex = i + 1;
                if (++lineIndex >= this.lineWidths.length) {
                    this.lineWidths = this.increaseShortArraySize(this.lineWidths, (byte)10);
                }
                currentLineWidth = 0;
                continue;
            }
            int index = this.indeces[i];
            if (index == this.spaceIndex) {
                lastSpaceIndex = i;
                lastSpaceWidth = currentLineWidth;
            }
            if ((currentLineWidth = (int)((short)(currentLineWidth + characterWidth))) > firstLineWidth && lastSpaceIndex > lineStartIndex) {
                this.usedCharactersWidths[lastSpaceIndex] = -3;
                lineStartIndex = lastSpaceIndex + 1;
                this.lineWidths[lineIndex] = (short)lastSpaceWidth;
                if (lastSpaceWidth > maxLineWidth) {
                    maxLineWidth = (short)lastSpaceWidth;
                }
                currentLineWidth = (short)(currentLineWidth - (lastSpaceWidth + this.actualCharacterWidths[this.spaceIndex]));
                if (++lineIndex >= this.lineWidths.length) {
                    this.lineWidths = this.increaseShortArraySize(this.lineWidths, (byte)10);
                }
            }
            firstLineWidth = lineWidth;
        }
        this.lineWidths[lineIndex] = currentLineWidth;
        if (currentLineWidth > maxLineWidth) {
            maxLineWidth = currentLineWidth;
        }
        this.numberOfLines = lineIndex + 1;
        this.width = maxLineWidth;
        this.height = this.numberOfLines * (this.fontHeight + paddingVertical) - paddingVertical;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    private short[] increaseShortArraySize(short[] src, byte growFactor) {
        short[] dest = new short[src.length + growFactor];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public byte[] getUsedCharactersWidths() {
        byte[] ret = new byte[this.usedCharactersWidths.length];
        System.arraycopy(this.usedCharactersWidths, 0, ret, 0, ret.length);
        return ret;
    }
}

