/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui;

import de.malban.util.UtilityString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JLabel;

public class FadingTextLabel
extends JLabel
implements Runnable {
    public static final int DEFAULT_STEP = 30;
    static int counter = 0;
    int thiscCounter = counter++;
    Thread animator = null;
    boolean doRun = false;
    int index = 0;
    int animDelay = 25;
    String oldText = "";
    int fheight = 0;
    Color orgTextColor = null;
    Color orgBackColor = null;
    Vector<Color> fColors = new Vector();
    Vector<Color> bColors = new Vector();
    Vector<String> words;
    Vector<String> lines;
    int steps = 30;
    boolean fadeIn = true;
    int startStep = 0;
    int stopStep = this.steps;

    public FadingTextLabel(String name) {
        this(name, 30);
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinit() {
        Vector<String> vector = this.lines;
        synchronized (vector) {
            this.doRun = false;
            this.animator = null;
            this.words = null;
            this.lines = null;
        }
    }

    public FadingTextLabel(String name, int count) {
        this.setText(name);
    }

    @Override
    public void setText(String t) {
        this.setText(t, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String t, int maxWidth) {
        super.setText(t);
        this.oldText = this.getText();
        this.words = new Vector();
        String text = this.getText();
        text = UtilityString.replace(text, "<BR>", "<br>");
        text = UtilityString.replace(text, "<html>", "");
        text = UtilityString.replace(text, "</html>", "");
        text = UtilityString.replace(text, "\n", "<br>");
        text = UtilityString.replace(text, "\\n", "<br>");
        text = UtilityString.replace(text, "<br>", " <br> ");
        String[] word = text.split(" ");
        for (int i = 0; i < word.length; ++i) {
            String string = word[i].trim();
            if (string.length() == 0) continue;
            this.words.addElement(string);
        }
        int size = maxWidth;
        Font f = this.getFont();
        boolean lineCount = false;
        String line = "";
        int lineWidth = 0;
        int currentMaxWidth = 0;
        if (f == null) {
            return;
        }
        if (this.getFontMetrics(f) == null) {
            return;
        }
        int spaceWidth = this.getFontMetrics(f).stringWidth(" ");
        this.fheight = this.getFontMetrics(f).getHeight();
        Vector<String> vector = this.lines = new Vector();
        synchronized (vector) {
            for (int i = 0; i < this.words.size(); ++i) {
                String w = this.words.elementAt(i).trim();
                int width = this.getFontMetrics(f).stringWidth(w);
                if (w.indexOf("<br>") != -1) {
                    this.lines.addElement(line);
                    if (lineWidth > currentMaxWidth) {
                        currentMaxWidth = lineWidth;
                    }
                    lineWidth = 0;
                    line = "";
                    continue;
                }
                if (lineWidth == 0) {
                    lineWidth = width;
                    line = line + w;
                    continue;
                }
                if (size != 0 && lineWidth + width + spaceWidth > size) {
                    this.lines.addElement(line);
                    if (lineWidth > currentMaxWidth) {
                        currentMaxWidth = lineWidth;
                    }
                    lineWidth = 0;
                    line = "";
                    --i;
                    continue;
                }
                lineWidth += width + spaceWidth;
                line = line + " " + w;
            }
            if (lineWidth > currentMaxWidth) {
                currentMaxWidth = lineWidth;
            }
            this.lines.addElement(line);
        }
        int height = this.lines.size() * this.fheight + 20;
        int width = currentMaxWidth + 20;
        this.setPreferredSize(new Dimension(width, height));
    }

    private void buildColors() {
        if (this.orgTextColor == null) {
            this.orgTextColor = this.getForeground();
            this.orgBackColor = this.getBackground();
            this.fColors.clear();
            int inc = 255 / (this.steps - 2);
            Color c = new Color(this.orgTextColor.getRed(), this.orgTextColor.getGreen(), this.orgTextColor.getBlue(), 255);
            this.fColors.addElement(c);
            c = new Color(this.orgBackColor.getRed(), this.orgBackColor.getGreen(), this.orgBackColor.getBlue(), 255);
            this.bColors.addElement(c);
            for (int i = 0; i < this.steps - 2; ++i) {
                c = new Color(this.orgTextColor.getRed(), this.orgTextColor.getGreen(), this.orgTextColor.getBlue(), 255 - (i + 1) * inc);
                this.fColors.addElement(c);
                c = new Color(this.orgBackColor.getRed(), this.orgBackColor.getGreen(), this.orgBackColor.getBlue(), 255 - (i + 1) * inc);
                this.bColors.addElement(c);
            }
            c = new Color(this.orgTextColor.getRed(), this.orgTextColor.getGreen(), this.orgTextColor.getBlue(), 0);
            this.fColors.addElement(c);
            c = new Color(this.orgBackColor.getRed(), this.orgBackColor.getGreen(), this.orgBackColor.getBlue(), 0);
            this.bColors.addElement(c);
        }
    }

    public void fadeOut() {
        this.buildColors();
        this.fadeOut(0, this.fColors.size());
    }

    private void fadeOut(int fromStep, int toStep) {
        while (this.animator != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (this.fColors.size() == 0) {
            return;
        }
        if (this.fColors.size() == 1) {
            this.setForeground(this.fColors.elementAt(0));
            this.setBackground(this.bColors.elementAt(0));
            return;
        }
        this.startStep = this.stopStep;
        if (toStep > this.fColors.size() - 1) {
            toStep = this.fColors.size() - 1;
        }
        this.startStep = 0;
        this.stopStep = toStep;
        this.animator = new Thread(this);
        this.doRun = true;
        this.fadeIn = false;
        this.index = fromStep;
        this.animator.start();
    }

    public void fadeIn() {
        this.buildColors();
        this.fadeIn(this.fColors.size(), 0);
        this.setForeground(this.fColors.elementAt(this.fColors.size() - 1));
        this.setBackground(this.bColors.elementAt(this.bColors.size() - 1));
        this.setVisible(true);
    }

    private void fadeIn(int fromStep, int toStep) {
        if (this.animator != null) {
            return;
        }
        if (this.fColors.size() == 0) {
            return;
        }
        if (this.fColors.size() == 1) {
            this.setForeground(this.fColors.elementAt(0));
            this.setBackground(this.bColors.elementAt(0));
            return;
        }
        if (toStep < 0) {
            toStep = 0;
        }
        this.startStep = fromStep;
        this.stopStep = toStep;
        this.animator = new Thread(this);
        this.doRun = true;
        this.fadeIn = true;
        this.index = fromStep;
        this.animator.start();
    }

    public void setDelay(int d) {
        this.animDelay = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.doRun) {
            try {
                Thread.sleep(this.animDelay);
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.doRun) {
                FadingTextLabel fadingTextLabel = this;
                synchronized (fadingTextLabel) {
                    if (!this.fadeIn) {
                        ++this.index;
                        if (this.index >= this.stopStep) {
                            this.doRun = false;
                            this.animator = null;
                            this.setVisible(false);
                        }
                    } else {
                        --this.index;
                        if (this.index <= this.stopStep) {
                            this.doRun = false;
                            this.animator = null;
                        }
                    }
                    if (this.doRun) {
                        this.setForeground(this.fColors.elementAt(this.index));
                        this.setBackground(this.bColors.elementAt(this.index));
                        this.setText(this.getText());
                    }
                }
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (this.index < 0 || this.index >= this.steps) {
            return;
        }
        g.setColor(this.bColors.elementAt(this.index));
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(new Color(0, 0, 0, this.bColors.elementAt(this.index).getAlpha()));
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(this.getForeground());
        if (this.lines != null) {
            Vector<String> vector = this.lines;
            synchronized (vector) {
                for (int i = 0; i < this.lines.size(); ++i) {
                    String line = this.lines.elementAt(i);
                    g.drawString(line, 10, 10 + this.fheight * (i + 1));
                }
            }
        }
    }
}

