/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui;

import de.malban.vide.VideConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class HotKey
implements Serializable {
    public String name = "";
    public String defaultKitName = "";
    public String where = "";
    public int event = 0;
    public int mask = 0;
    public boolean onRelease = false;
    transient Action action = null;
    transient JTextComponent editor = null;
    transient JPanel panel = null;
    public static transient HashMap<String, HotKey> allMappings = new HashMap();
    public static transient ArrayList<HotKey> hotkeyList = new ArrayList();

    public String getKeyString() {
        return this.getKeyStroke().toString();
    }

    public static void addMap(int e, int m, String n, boolean or) {
        HotKey hk = new HotKey(e, m, n, null, (JTextComponent)null, or);
        hotkeyList.add(hk);
        allMappings.put(n, hk);
    }

    public static void addMap(int e, int m, String n, String w) {
        HotKey oldVal = allMappings.get(n);
        if (oldVal != null) {
            hotkeyList.remove(oldVal);
        }
        HotKey hk = new HotKey(e, m, n, null, (JTextComponent)null);
        hk.where = w;
        hotkeyList.add(hk);
        allMappings.put(n, hk);
    }

    public HotKey(String n, Action a, JTextComponent ed) {
        HotKey hk = allMappings.get(n);
        if (hk == null) {
            return;
        }
        this.event = hk.event;
        this.mask = hk.mask;
        this.name = hk.name;
        this.onRelease = hk.onRelease;
        this.action = a;
        this.editor = ed;
        this.addKeysToEditor();
    }

    public HotKey(String n, String defaultName, JTextComponent ed) {
        HotKey hk = allMappings.get(n);
        if (hk == null) {
            return;
        }
        this.event = hk.event;
        this.mask = hk.mask;
        this.name = hk.name;
        this.onRelease = hk.onRelease;
        this.editor = ed;
        this.defaultKitName = defaultName;
        this.addKeysToEditor();
    }

    public HotKey(String n, Action a, JPanel p) {
        HotKey hk = allMappings.get(n);
        if (hk == null) {
            return;
        }
        this.event = hk.event;
        this.mask = hk.mask;
        this.name = hk.name;
        this.onRelease = hk.onRelease;
        this.action = a;
        this.panel = p;
        this.addKeysToPanel();
    }

    private HotKey(int e, int m, String n, Action a, JTextComponent ed) {
        this(e, m, n, a, ed, false);
    }

    private HotKey(int e, int m, String n, Action a, JTextComponent ed, boolean or) {
        this.event = e;
        this.mask = m;
        this.name = n;
        this.action = a;
        this.editor = ed;
        this.onRelease = or;
        this.addKeysToEditor();
    }

    private HotKey(int e, int m, String n, Action a, JPanel p) {
        this(e, m, n, a, p, false);
    }

    private HotKey(int e, int m, String n, Action a, JPanel p, boolean or) {
        this.event = e;
        this.mask = m;
        this.name = n;
        this.action = a;
        this.panel = p;
        this.addKeysToPanel();
    }

    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(this.event, this.mask, this.onRelease);
    }

    private void addKeysToEditor() {
        if (!VideConfig.hotKeysEnabled) {
            return;
        }
        if (this.editor == null) {
            return;
        }
        this.editor.getInputMap().put(this.getKeyStroke(), this.name);
        if (this.action != null) {
            this.editor.getActionMap().put(this.name, this.action);
        } else if (this.defaultKitName.length() != 0) {
            this.editor.getActionMap().put(this.name, this.editor.getActionMap().get(this.defaultKitName));
        }
    }

    private void addKeysToPanel() {
        if (!VideConfig.hotKeysEnabled) {
            return;
        }
        if (this.panel == null) {
            return;
        }
        this.panel.getInputMap(2).put(this.getKeyStroke(), this.name);
        if (this.action != null) {
            this.panel.getActionMap().put(this.name, this.action);
        }
    }

    public static void addMacDefaults(JTextComponent t) {
        t.getActionMap().put("copy-to-clipboardMac", t.getActionMap().get("copy-to-clipboard"));
        t.getInputMap().put(KeyStroke.getKeyStroke(67, 256, false), "copy-to-clipboardMac");
        t.getActionMap().put("paste-from-clipboardMac", t.getActionMap().get("paste-from-clipboard"));
        t.getInputMap().put(KeyStroke.getKeyStroke(86, 256, false), "paste-from-clipboardMac");
        t.getActionMap().put("cut-to-clipboardMac", t.getActionMap().get("cut-to-clipboard"));
        t.getInputMap().put(KeyStroke.getKeyStroke(88, 256, false), "cut-to-clipboardMac");
        t.getActionMap().put("select-allMac", t.getActionMap().get("select-all"));
        t.getInputMap().put(KeyStroke.getKeyStroke(65, 256, false), "select-allMac");
    }

    static {
        HotKey.addMap(67, 256, "copy-to-clipboard", "Editor");
        HotKey.addMap(86, 256, "paste-from-clipboard", "Editor");
        HotKey.addMap(88, 256, "cut-to-clipboard", "Editor");
        HotKey.addMap(65, 256, "select-all", "Editor");
        HotKey.addMap(9, 64, "unindent", "Editor");
        HotKey.addMap(9, 0, "indent", "Editor");
        HotKey.addMap(90, 256, "UndoMac", "Editor");
        HotKey.addMap(89, 256, "RedoMac", "Editor");
        HotKey.addMap(90, 128, "UndoWin", "Editor");
        HotKey.addMap(89, 128, "RedoWin", "Editor");
        HotKey.addMap(70, 256, "SearchMac", "Editor");
        HotKey.addMap(70, 128, "SearchWin", "Editor");
        HotKey.addMap(116, 0, "Run", "Editor");
        HotKey.addMap(117, 0, "Debug", "Editor");
        HotKey.addMap(112, 0, "QuickHelp", "Editor");
        HotKey.addMap(82, 256, "RecolorMac", "Editor");
        HotKey.addMap(82, 128, "RecolorWin", "Editor");
        HotKey.addMap(74, 256, "JumpMac", "Editor");
        HotKey.addMap(74, 128, "JumpWin", "Editor");
        HotKey.addMap(37, 256, "FirstCharInLine", "Editor");
        HotKey.addMap(39, 256, "LastCharInLine", "Editor");
        HotKey.addMap(38, 256, "FileStart", "Editor");
        HotKey.addMap(40, 256, "FileEnd", "Editor");
        HotKey.addMap(38, 128, "PreviousBookmark", "Editor");
        HotKey.addMap(40, 128, "NextBookmark", "Editor");
        HotKey.addMap(49, 256, "GoBookmark1Mac", "Editor");
        HotKey.addMap(49, 128, "GoBookmark1Win", "Editor");
        HotKey.addMap(49, 320, "SetBookmark1Mac", "Editor");
        HotKey.addMap(49, 192, "SetBookmark1Win", "Editor");
        HotKey.addMap(50, 256, "GoBookmark2Mac", "Editor");
        HotKey.addMap(50, 128, "GoBookmark2Win", "Editor");
        HotKey.addMap(50, 320, "SetBookmark2Mac", "Editor");
        HotKey.addMap(50, 192, "SetBookmark2Win", "Editor");
        HotKey.addMap(51, 256, "GoBookmark3Mac", "Editor");
        HotKey.addMap(51, 128, "GoBookmark3Win", "Editor");
        HotKey.addMap(51, 320, "SetBookmark3Mac", "Editor");
        HotKey.addMap(51, 192, "SetBookmark3Win", "Editor");
        HotKey.addMap(52, 256, "GoBookmark4Mac", "Editor");
        HotKey.addMap(52, 128, "GoBookmark4Win", "Editor");
        HotKey.addMap(52, 320, "SetBookmark4Mac", "Editor");
        HotKey.addMap(52, 192, "SetBookmark4Win", "Editor");
        HotKey.addMap(53, 256, "GoBookmark5Mac", "Editor");
        HotKey.addMap(53, 128, "GoBookmark5Win", "Editor");
        HotKey.addMap(53, 320, "SetBookmark5Mac", "Editor");
        HotKey.addMap(53, 192, "SetBookmark5Win", "Editor");
        HotKey.addMap(54, 256, "GoBookmark6Mac", "Editor");
        HotKey.addMap(54, 128, "GoBookmark6Win", "Editor");
        HotKey.addMap(54, 320, "SetBookmark6Mac", "Editor");
        HotKey.addMap(54, 192, "SetBookmark6Win", "Editor");
        HotKey.addMap(55, 256, "GoBookmark7Mac", "Editor");
        HotKey.addMap(55, 128, "GoBookmark7Win", "Editor");
        HotKey.addMap(55, 320, "SetBookmark7Mac", "Editor");
        HotKey.addMap(55, 192, "SetBookmark7Win", "Editor");
        HotKey.addMap(56, 256, "GoBookmark8Mac", "Editor");
        HotKey.addMap(56, 128, "GoBookmark8Win", "Editor");
        HotKey.addMap(56, 320, "SetBookmark8Mac", "Editor");
        HotKey.addMap(56, 192, "SetBookmark8Win", "Editor");
        HotKey.addMap(57, 256, "GoBookmark9Mac", "Editor");
        HotKey.addMap(57, 128, "GoBookmark9Win", "Editor");
        HotKey.addMap(57, 320, "SetBookmark9Mac", "Editor");
        HotKey.addMap(57, 192, "SetBookmark9Win", "Editor");
        HotKey.addMap(48, 256, "GoBookmark0Mac", "Editor");
        HotKey.addMap(48, 128, "GoBookmark0Win", "Editor");
        HotKey.addMap(48, 320, "SetBookmark0Mac", "Editor");
        HotKey.addMap(48, 192, "SetBookmark0Win", "Editor");
        HotKey.addMap(65, 0, "Button1_1_pressed", false);
        HotKey.addMap(65, 0, "Button1_1_released", true);
        HotKey.addMap(83, 0, "Button1_2_pressed", false);
        HotKey.addMap(83, 0, "Button1_2_released", true);
        HotKey.addMap(68, 0, "Button1_3_pressed", false);
        HotKey.addMap(68, 0, "Button1_3_released", true);
        HotKey.addMap(70, 0, "Button1_4_pressed", false);
        HotKey.addMap(70, 0, "Button1_4_released", true);
        HotKey.addMap(37, 0, "Joy1_Left_pressed", false);
        HotKey.addMap(37, 0, "Joy1_Left_released", true);
        HotKey.addMap(39, 0, "Joy1_Right_pressed", false);
        HotKey.addMap(39, 0, "Joy1_Right_released", true);
        HotKey.addMap(38, 0, "Joy1_Up_pressed", false);
        HotKey.addMap(38, 0, "Joy1_Up_released", true);
        HotKey.addMap(40, 0, "Joy1_Down_pressed", false);
        HotKey.addMap(40, 0, "Joy1_Down_released", true);
        HotKey.addMap(67, 0, "SpinnerButton_1_pressed", false);
        HotKey.addMap(86, 0, "SpinnerButton_2_pressed", true);
        HotKey.addMap(67, 0, "SpinnerButton_1_released", false);
        HotKey.addMap(86, 0, "SpinnerButton_2_released", true);
        HotKey.addMap(89, 0, "Spinner_Left_pressed", false);
        HotKey.addMap(89, 0, "Spinner_Left_released", true);
        HotKey.addMap(88, 0, "Spinner_Right_pressed", false);
        HotKey.addMap(88, 0, "Spinner_Right_released", true);
        HotKey.addMap(81, 0, "Button2_1_pressed", false);
        HotKey.addMap(81, 0, "Button2_1_released", true);
        HotKey.addMap(87, 0, "Button2_2_pressed", false);
        HotKey.addMap(87, 0, "Button2_2_released", true);
        HotKey.addMap(69, 0, "Button2_3_pressed", false);
        HotKey.addMap(69, 0, "Button2_3_released", true);
        HotKey.addMap(82, 0, "Button2_4_pressed", false);
        HotKey.addMap(82, 0, "Button2_4_released", true);
        HotKey.addMap(74, 0, "Joy2_Left_pressed", false);
        HotKey.addMap(74, 0, "Joy2_Left_released", true);
        HotKey.addMap(76, 0, "Joy2_Right_pressed", false);
        HotKey.addMap(76, 0, "Joy2_Right_released", true);
        HotKey.addMap(73, 0, "Joy2_Up_pressed", false);
        HotKey.addMap(73, 0, "Joy2_Up_released", true);
        HotKey.addMap(77, 0, "Joy2_Down_pressed", false);
        HotKey.addMap(77, 0, "Joy2_Down_released", true);
        HotKey.addMap(80, 0, "Pause/Toggle", "Vecxi");
        HotKey.addMap(79, 0, "Overlay/Toggle", "Vecxi");
        HotKey.addMap(49, 0, "VecX QuickSave", "Vecxi");
        HotKey.addMap(50, 0, "VecX QuickLoad", "Vecxi");
        HotKey.addMap(66, 0, "RingbufferToggle", "Vecxi");
        HotKey.addMap(80, 64, "Panel/Toggle", "Vecxi");
        HotKey.addMap(70, 64, "FullScreen/Toggle", "Vecxi");
        HotKey.addMap(81, 64, "Quit vecxi", "Vecxi");
        HotKey.addMap(77, 0, "Mode change", "Vecci");
        HotKey.addMap(127, 0, "Delete selected", "Vecci");
        HotKey.addMap(90, 256, "UndoMac", "Vecci");
        HotKey.addMap(90, 320, "RedoMac", "Vecci");
        HotKey.addMap(90, 128, "UndoWin", "Vecci");
        HotKey.addMap(90, 192, "RedoWin", "Vecci");
        HotKey.addMap(67, 256, "CopyMac", "Vecci");
        HotKey.addMap(86, 256, "PasteMac", "Vecci");
        HotKey.addMap(67, 128, "CopyWin", "Vecci");
        HotKey.addMap(86, 128, "PasteWin", "Vecci");
        HotKey.addMap(65, 256, "SelectAllMac", "Vecci");
        HotKey.addMap(65, 128, "SelectAllWin", "Vecci");
        HotKey.addMap(88, 256, "CutMac", "Vecci");
        HotKey.addMap(88, 128, "CutWin", "Vecci");
        HotKey.addMap(77, 0, "Mode change(Window)", "SingleVecci");
        HotKey.addMap(127, 0, "Delete selected(Window)", "SingleVecci");
        HotKey.addMap(90, 256, "UndoMac(Window)", "SingleVecci");
        HotKey.addMap(90, 320, "RedoMac(Window)", "SingleVecci");
        HotKey.addMap(90, 128, "UndoWin(Window)", "SingleVecci");
        HotKey.addMap(90, 192, "RedoWin(Window)", "SingleVecci");
        HotKey.addMap(67, 256, "CopyMac(Window)", "SingleVecci");
        HotKey.addMap(86, 256, "PasteMac(Window)", "SingleVecci");
        HotKey.addMap(67, 128, "CopyWin(Window)", "SingleVecci");
        HotKey.addMap(86, 128, "PasteWin(Window)", "SingleVecci");
        HotKey.addMap(65, 256, "SelectAllMac(Window)", "SingleVecci");
        HotKey.addMap(65, 128, "SelectAllWin(Window)", "SingleVecci");
        HotKey.addMap(88, 256, "CutMac(Window)", "SingleVecci");
        HotKey.addMap(88, 128, "CutWin(Window)", "SingleVecci");
        HotKey.addMap(226, 0, "AnimLeftKP(Window)", "SingleVecci");
        HotKey.addMap(227, 0, "AnimRightKP(Window)", "SingleVecci");
        HotKey.addMap(37, 0, "AnimLeft(Window)", "SingleVecci");
        HotKey.addMap(39, 0, "AnimRight(Window)", "SingleVecci");
        HotKey.addMap(78, 0, "dif next", "DIS_compare");
        HotKey.addMap(80, 0, "dif previous", "DIS_compare");
        HotKey.addMap(114, 0, "Search next", "Editor");
        HotKey.addMap(114, 64, "Search previous", "Editor");
        HotKey.addMap(83, 256, "SaveMac", "Editor");
        HotKey.addMap(83, 128, "SaveWin", "Editor");
    }
}

