/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui;

import de.malban.gui.ImageCache;
import de.malban.gui.image.HSBAdjustFilter;
import de.malban.gui.image.OpacityFilter;
import de.malban.gui.image.RGBAdjustFilter;
import de.malban.util.UtilityImage;
import de.malban.util.UtilityString;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;

public class ImageCacheItem {
    public static int DERIVAT_NO = 0;
    public static int DERIVAT_SCALE = 1;
    public static int DERIVAT_SUB = 2;
    public static int DERIVAT_OPAQUE = 3;
    public static int DERIVAT_ROTATE = 4;
    public static int DERIVAT_RESIZE = 5;
    public static int DERIVAT_VMIRROR = 6;
    public static int DERIVAT_HMIRROR = 7;
    public static int DERIVAT_RGB = 8;
    public static int DERIVAT_HSB = 9;
    ArrayList<Integer> derivateUIDs = new ArrayList();
    private static int counter = 0;
    private int UID = counter++;
    private String key = "";
    private BufferedImage bimage;
    private int usageCount = 0;
    private int derivatFrom = -1;
    private boolean cacheable = true;
    private int derivatType = DERIVAT_NO;
    private int scaleWidth = 0;
    private int scaleHeight = 0;
    private boolean vMirror = false;
    private boolean hMirror = false;
    private boolean keepSize = false;
    private int opacity = 0;
    private int subX = 0;
    private int subY = 0;
    private int subWidth = 0;
    private int subHeight = 0;
    private int resizeWidth = 0;
    private int resizeHeight = 0;
    private float rFactor = 0.0f;
    private float gFactor = 0.0f;
    private float bFactor = 0.0f;
    private float h_Factor = 0.0f;
    private float s_Factor = 0.0f;
    private float b_Factor = 0.0f;
    private double angle = 0.0;
    private String sourcePath = "";

    public boolean isAlpha() {
        if (this.bimage == null) {
            return false;
        }
        return this.bimage.getColorModel().hasAlpha();
    }

    private ImageCacheItem() {
    }

    public String getKey() {
        if (this.key.length() == 0) {
            return "" + this.UID;
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getUID() {
        return this.UID;
    }

    public BufferedImage getBufferedImage() {
        return this.bimage;
    }

    public void setBufferedImage(BufferedImage bi) {
        this.bimage = bi;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public int getDerivatFrom() {
        return this.derivatFrom;
    }

    public int getDerivatType() {
        return this.derivatType;
    }

    public int getScaleHeight() {
        return this.scaleHeight;
    }

    public int getScaleWidth() {
        return this.scaleWidth;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public int decUsageCount() {
        --this.usageCount;
        return this.usageCount;
    }

    public int incUsageCount() {
        ++this.usageCount;
        return this.usageCount;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public static ImageCacheItem buildItem(String path) {
        ImageCacheItem item = new ImageCacheItem();
        item.sourcePath = UtilityString.cleanFileString(path);
        File inFile = new File(item.sourcePath);
        if (!inFile.exists()) {
            return null;
        }
        BufferedImage image = UtilityImage.loadImage(path);
        if (image == null) {
            return null;
        }
        item.bimage = UtilityImage.toBufferedImage(image);
        item.scaleHeight = item.bimage.getHeight(null);
        item.scaleWidth = item.bimage.getWidth(null);
        return item;
    }

    public static ImageCacheItem buildItem(BufferedImage bimage) {
        if (bimage == null) {
            return null;
        }
        ImageCacheItem item = new ImageCacheItem();
        item.bimage = bimage;
        item.scaleHeight = item.bimage.getHeight(null);
        item.scaleWidth = item.bimage.getWidth(null);
        return item;
    }

    protected ImageCacheItem getDerivatScale(int scaleWidth, int scaleHeight) {
        if (this.bimage.getHeight(null) == scaleHeight && this.bimage.getWidth(null) == scaleWidth) {
            return this;
        }
        String nkey = this.getKey() + "_" + DERIVAT_SCALE + "_" + scaleWidth + "x" + scaleHeight;
        ImageCacheItem item = ImageCache.getImageCache().getImageCacheByKey(nkey);
        if (item != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.key = nkey;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.scaleHeight = scaleWidth;
        item.scaleWidth = scaleHeight;
        item.derivatFrom = this.UID;
        item.bimage = UtilityImage.toBufferedImage(UtilityImage.imageScale(this.bimage, scaleWidth, scaleHeight));
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    protected ImageCacheItem getDerivatOpaque(int o) {
        String nkey = this.getKey() + "_" + DERIVAT_OPAQUE + "_" + o;
        ImageCacheItem item = ImageCache.getImageCache().getImageCacheByKey(nkey);
        if (item != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.key = nkey;
        item.opacity = o;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.derivatFrom = this.UID;
        OpacityFilter filter = new OpacityFilter(o);
        item.bimage = filter.filter(this.bimage, null);
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    protected ImageCacheItem getDerivatSubImage(int x, int y, int w, int h) {
        String nkey = this.getKey() + "_" + DERIVAT_SUB + "_" + x + "," + y + "," + w + "," + h;
        ImageCacheItem item = ImageCache.getImageCache().getImageCacheByKey(nkey);
        if (item != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.key = nkey;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.subX = x;
        item.subY = y;
        item.subWidth = w;
        item.subHeight = h;
        item.derivatFrom = this.UID;
        item.bimage = this.bimage.getSubimage(x, y, w, h);
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    protected ImageCacheItem getDerivatRotate(double a) {
        return this.getDerivatRotate(a, false);
    }

    protected ImageCacheItem getDerivatRotate(double a, boolean ks) {
        BufferedImage orgImg;
        int bigSize;
        int w;
        String nkey = this.getKey() + "_" + DERIVAT_ROTATE + "_" + a + "_" + ks;
        ImageCacheItem item = ImageCache.getImageCache().getImageCacheByKey(nkey);
        if (item != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.keepSize = ks;
        item.key = nkey;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.angle = a;
        item.derivatFrom = this.UID;
        int h = this.bimage.getHeight();
        int size = h > (w = this.bimage.getWidth()) ? h : w;
        int sizeW = size = (bigSize = (int)(Math.sqrt(2.0 * (double)(size * size)) + 0.999));
        int sizeH = size;
        if (ks) {
            sizeW = w;
            sizeH = h;
        }
        int type = 2;
        if (!ks) {
            orgImg = new BufferedImage(sizeW, sizeH, type);
            Graphics2D go = orgImg.createGraphics();
            go.drawImage(this.bimage, (sizeW - w) / 2, (sizeH - h) / 2, this.bimage.getWidth(), this.bimage.getHeight(), null);
        } else {
            orgImg = new BufferedImage(w, h, type);
            Graphics2D go = orgImg.createGraphics();
            go.drawImage(this.bimage, 0, 0, this.bimage.getWidth(), this.bimage.getHeight(), null);
        }
        BufferedImage dimg = new BufferedImage(sizeW, sizeH, type);
        Graphics2D g = dimg.createGraphics();
        double sw = sizeW;
        double sh = sizeH;
        g.rotate(Math.toRadians(item.angle), sw / 2.0, sh / 2.0);
        g.drawImage(orgImg, null, 0, 0);
        item.bimage = dimg;
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    protected ImageCacheItem getDerivatMirror(boolean isVerticalMirror) {
        ImageCacheItem item;
        String nkey = this.getKey() + "_" + DERIVAT_HMIRROR;
        if (isVerticalMirror) {
            nkey = this.getKey() + "_" + DERIVAT_VMIRROR;
        }
        if ((item = ImageCache.getImageCache().getImageCacheByKey(nkey)) != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.key = nkey;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.vMirror = isVerticalMirror;
        item.hMirror = !isVerticalMirror;
        item.derivatFrom = this.UID;
        int w = this.bimage.getWidth();
        int h = this.bimage.getHeight();
        if (!isVerticalMirror) {
            BufferedImage dimg = new BufferedImage(w, h, this.bimage.getType());
            Graphics2D g = dimg.createGraphics();
            g.drawImage(this.bimage, 0, 0, w, h, w, 0, 0, h, null);
            g.dispose();
            item.bimage = dimg;
        } else {
            BufferedImage dimg = new BufferedImage(w, h, this.bimage.getType());
            Graphics2D g = dimg.createGraphics();
            g.drawImage(this.bimage, 0, 0, w, h, 0, h, w, 0, null);
            g.dispose();
            item.bimage = dimg;
        }
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    public ImageCacheItem getDerivatCanvasResize(int w, int h) {
        String nkey = this.getKey() + "_" + DERIVAT_RESIZE + "_" + w + "," + h;
        ImageCacheItem item = ImageCache.getImageCache().getImageCacheByKey(nkey);
        if (item != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.key = nkey;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.resizeHeight = h;
        item.resizeWidth = w;
        item.derivatFrom = this.UID;
        int oldW = this.bimage.getWidth();
        int oldH = this.bimage.getHeight();
        int offX = (w - oldW) / 2;
        int offY = (h - oldH) / 2;
        int type = 2;
        BufferedImage dimg = new BufferedImage(w, h, type);
        Graphics2D g = dimg.createGraphics();
        g.drawImage(this.bimage, null, offX, offY);
        item.bimage = dimg;
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    public ImageCacheItem getDerivatRGB(float r, float g, float b) {
        String nkey = this.getKey() + "_" + DERIVAT_RGB + "_" + r + "," + g + "," + b;
        ImageCacheItem item = ImageCache.getImageCache().getImageCacheByKey(nkey);
        if (item != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.key = nkey;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.rFactor = r;
        item.gFactor = g;
        item.bFactor = b;
        item.derivatFrom = this.UID;
        RGBAdjustFilter filter = new RGBAdjustFilter(r, g, b);
        item.bimage = filter.filter(this.bimage, null);
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    public ImageCacheItem getDerivatHSB(float h, float s, float b) {
        String nkey = this.getKey() + "_" + DERIVAT_HSB + "_" + h + "," + s + "," + b;
        ImageCacheItem item = ImageCache.getImageCache().getImageCacheByKey(nkey);
        if (item != null) {
            return item;
        }
        item = new ImageCacheItem();
        item.key = nkey;
        item.sourcePath = UtilityString.cleanFileString(this.sourcePath);
        item.h_Factor = h;
        item.s_Factor = s;
        item.b_Factor = b;
        item.derivatFrom = this.UID;
        HSBAdjustFilter filter = new HSBAdjustFilter(h, s, b);
        item.bimage = filter.filter(this.bimage, null);
        this.derivateUIDs.add(item.UID);
        ImageCache.getImageCache().addItem(item);
        return item;
    }

    public void invalidateDerivates() {
        for (int i = 0; i < this.derivateUIDs.size(); ++i) {
            ImageCacheItem item = ImageCache.getImageCache().getImageCacheByUID(this.derivateUIDs.get(i));
            ImageCache.getImageCache().removeItem(item);
        }
        this.derivateUIDs.clear();
    }
}

