/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui;

import de.malban.gui.TriggerCallback;
import java.util.Vector;

public class TimingTriggerer {
    public static final int DEFAULT_RESOLUTION = 200;
    private static final TimingTriggerer timer = new TimingTriggerer();
    private long resolution = 200L;
    private volatile boolean stop = true;
    private volatile boolean running = false;
    private final Vector<Trigger> mTriggers = new Vector();
    private final boolean autoResolutionEnabled = true;
    int minRes = 100000;

    public static TimingTriggerer getTimer() {
        return timer;
    }

    public static TimingTriggerer getPrivatTimer() {
        return new TimingTriggerer();
    }

    private TimingTriggerer() {
    }

    public void deinit() {
        this.stop = true;
    }

    private void start() {
        new Thread("Timer thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimingTriggerer.this.running = true;
                while (!TimingTriggerer.this.stop) {
                    try {
                        1.sleep(TimingTriggerer.this.resolution);
                        if (TimingTriggerer.this.stop) continue;
                        Vector<Trigger> removed = new Vector<Trigger>();
                        TimingTriggerer.this.minRes = 100000;
                        Vector vector = TimingTriggerer.this.mTriggers;
                        synchronized (vector) {
                            for (int i = TimingTriggerer.this.mTriggers.size() - 1; i >= 0; --i) {
                                Trigger trigger = (Trigger)TimingTriggerer.this.mTriggers.elementAt(i);
                                trigger.timing = (int)((long)trigger.timing - TimingTriggerer.this.resolution);
                                if (trigger.timing <= 0) {
                                    TimingTriggerer.this.mTriggers.removeElement(trigger);
                                    removed.add(trigger);
                                    continue;
                                }
                                if (TimingTriggerer.this.minRes <= trigger.timing) continue;
                                TimingTriggerer.this.minRes = trigger.timing;
                            }
                        }
                        for (int i = removed.size() - 1; i >= 0; --i) {
                            Trigger trigger = (Trigger)removed.elementAt(i);
                            trigger.trigger.doIt(trigger.state, trigger.o);
                        }
                        if (TimingTriggerer.this.mTriggers.isEmpty()) {
                            TimingTriggerer.this.stop = true;
                            TimingTriggerer.this.setResolution(200);
                            continue;
                        }
                        TimingTriggerer.this.setResolution(TimingTriggerer.this.minRes);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                TimingTriggerer.this.running = false;
                TimingTriggerer.this.mTriggers.clear();
            }
        }.start();
    }

    public void setResolution(int res) {
        if (res == 0) {
            res = 5;
        }
        if (this.resolution < (long)res) {
            return;
        }
        this.resolution = res;
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrigger(TriggerCallback trigger) {
        Vector<Trigger> vector = this.mTriggers;
        synchronized (vector) {
            for (int i = this.mTriggers.size() - 1; i >= 0; --i) {
                Trigger trigger1 = this.mTriggers.elementAt(i);
                if (trigger1.trigger != trigger) continue;
                this.mTriggers.removeElement(trigger1);
            }
            if (this.mTriggers.isEmpty()) {
                this.stop = true;
            }
        }
    }

    public void addTrigger(TriggerCallback trigger, int timing, int state, Object o) {
        if ((long)timing < this.resolution) {
            this.setResolution(timing);
        }
        Trigger t = new Trigger();
        t.trigger = trigger;
        t.timing = timing;
        if (this.minRes > timing) {
            this.minRes = timing;
        }
        t.state = state;
        t.o = o;
        this.mTriggers.addElement(t);
        if (this.stop) {
            this.stop = false;
            if (!this.running) {
                this.start();
            }
        }
    }

    class Trigger {
        TriggerCallback trigger;
        int timing;
        int state;
        Object o;

        Trigger() {
        }
    }
}

