/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.bitmapfont;

import de.malban.gui.ImageCache;
import de.malban.gui.Scaler;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class BitmapFont {
    int kerningPercent = 0;
    int mediumWidth = 0;
    int height = 0;
    boolean specialKerning = false;
    HashMap<String, BCharacterImage> abc = new HashMap();

    public void setKerningPercent(int k) {
        this.kerningPercent = k;
        this.mediumWidth = 0;
        Set<Map.Entry<String, BCharacterImage>> entries = this.abc.entrySet();
        for (Map.Entry<String, BCharacterImage> entry : entries) {
            BCharacterImage value = entry.getValue();
            this.mediumWidth += value.image.getWidth();
        }
        this.mediumWidth /= this.abc.size();
    }

    public BitmapFont getDerivat(int newHeight) {
        BitmapFont newFont = new BitmapFont();
        float scale = (float)newHeight / (float)this.height;
        Set<Map.Entry<String, BCharacterImage>> entries = this.abc.entrySet();
        for (Map.Entry<String, BCharacterImage> entry : entries) {
            BCharacterImage value = entry.getValue();
            int newWidth = Scaler.scaleFloatToInt(value.image.getWidth(), scale);
            BufferedImage newImage = ImageCache.getImageCache().getDerivatScale(value.image, newWidth, newHeight);
            int newKerning = -1;
            if (value.kerning != -1) {
                newKerning = Scaler.scaleFloatToInt(value.kerning, scale);
            }
            int newBaseline = 0;
            if (value.basline != -1) {
                newBaseline = Scaler.scaleFloatToInt(value.basline, scale);
            }
            newFont.addChar(value.letter, newImage, newBaseline, newKerning);
        }
        newFont.setKerningPercent(this.kerningPercent);
        newFont.setSpecialKerning(this.specialKerning);
        return newFont;
    }

    public void addChar(String letter, BufferedImage image, int baseline) {
        this.height = image.getHeight();
        this.abc.put(letter, new BCharacterImage(letter, image, baseline));
    }

    public void addChar(String letter, BufferedImage image, int baseline, int kerning) {
        this.height = image.getHeight();
        this.abc.put(letter, new BCharacterImage(letter, image, baseline, kerning));
    }

    public void setSpecialKerning(boolean b) {
        this.specialKerning = b;
    }

    private int getLetterWidth(BCharacterImage li, String letter, String word, int posInWord) {
        int k;
        int width = li.image.getWidth();
        if (posInWord == word.length() - 1) {
            return width;
        }
        if (li.kerning != -1) {
            return width - li.kerning;
        }
        if (this.specialKerning) {
            if (letter.equals("f")) {
                k = width * 35 / 100;
                width -= k;
            } else {
                int k2;
                String nextChar = "";
                if (word.length() >= posInWord + 2) {
                    nextChar = word.substring(posInWord + 1, posInWord + 2);
                }
                if (nextChar.equals("b")) {
                    k2 = this.mediumWidth * 10 / 100;
                    width -= k2;
                }
                if (nextChar.equals("h")) {
                    k2 = this.mediumWidth * 10 / 100;
                    width -= k2;
                }
                if (nextChar.equals("l")) {
                    k2 = this.mediumWidth * 10 / 100;
                    width -= k2;
                }
                if (nextChar.equals("t")) {
                    k2 = this.mediumWidth * 10 / 100;
                    width -= k2;
                }
                if (nextChar.equals("u")) {
                    k2 = this.mediumWidth * 7 / 100;
                    width -= k2;
                }
                if (nextChar.equals("n")) {
                    k2 = this.mediumWidth * 7 / 100;
                    width -= k2;
                }
                if (nextChar.equals("m")) {
                    k2 = this.mediumWidth * 7 / 100;
                    width -= k2;
                }
            }
        }
        if (this.kerningPercent > 0) {
            k = this.mediumWidth * this.kerningPercent / 100;
            if (this.specialKerning) {
                if (letter.equals("l")) {
                    k = this.mediumWidth / 2 * this.kerningPercent / 100;
                }
                if (letter.equals("i")) {
                    k = this.mediumWidth / 2 * this.kerningPercent / 100;
                }
            }
            width -= k;
        }
        return width;
    }

    public BufferedImage drawText(String text, int maxWidth) {
        String[] words = text.split(" ");
        int textMaxHeight = 0;
        int textMaxWidth = 0;
        int wordPosX = 0;
        int wordPosY = 0;
        int textMaxUsedWidth = 0;
        Vector<BufferedImage> lineImages = new Vector<BufferedImage>();
        Vector<BufferedImage> wordImages = new Vector<BufferedImage>();
        BCharacterImage SPACE = this.abc.get(" ");
        int spaceWidth = 10;
        if (SPACE != null) {
            spaceWidth = SPACE.image.getWidth();
        }
        int lineWidthPos = 0;
        boolean firstWord = true;
        for (int w = 0; w < words.length; ++w) {
            BufferedImage wordImage;
            String word = words[w];
            BCharacterImage wordCImage = this.abc.get(word);
            int wordBaseline = 0;
            if (wordCImage != null) {
                wordImage = wordCImage.image;
                wordBaseline = wordCImage.basline;
                if (textMaxHeight < wordCImage.image.getHeight()) {
                    textMaxHeight = wordCImage.image.getHeight();
                }
            } else {
                int wordMaxHeight = 0;
                int wordWidth = 0;
                for (int c = 0; c < word.length(); ++c) {
                    String letter = word.substring(c, c + 1);
                    BCharacterImage letterImage = this.abc.get(letter);
                    if (letterImage == null) {
                        letterImage = this.abc.get(letter.toUpperCase());
                    }
                    if (letterImage == null) {
                        letterImage = this.abc.get(letter.toLowerCase());
                    }
                    if (letterImage == null) continue;
                    wordWidth += this.getLetterWidth(letterImage, letter, word, c);
                    if (wordMaxHeight >= letterImage.image.getHeight()) continue;
                    wordMaxHeight = letterImage.image.getHeight();
                }
                if (textMaxHeight < wordMaxHeight) {
                    textMaxHeight = wordMaxHeight;
                }
                wordImage = new BufferedImage(wordWidth, wordMaxHeight, 2);
                Graphics2D g = wordImage.createGraphics();
                wordPosX = 0;
                for (int c = 0; c < word.length(); ++c) {
                    String letter = word.substring(c, c + 1);
                    BCharacterImage letterImage = this.abc.get(letter);
                    if (letterImage == null) {
                        letterImage = this.abc.get(letter.toUpperCase());
                    }
                    if (letterImage == null) {
                        letterImage = this.abc.get(letter.toLowerCase());
                    }
                    if (letterImage == null) continue;
                    g.drawImage((Image)letterImage.image, wordPosX, 0, null);
                    wordPosX += this.getLetterWidth(letterImage, letter, word, c);
                }
            }
            boolean newLine = false;
            if (lineWidthPos + spaceWidth + wordPosX > maxWidth) {
                firstWord = true;
                lineWidthPos = 0;
                int lineWidth = wordPosX;
                if (textMaxWidth < lineWidth) {
                    textMaxWidth = lineWidth;
                }
                BufferedImage lineImage = new BufferedImage(lineWidth, textMaxHeight, 2);
                Graphics2D g = lineImage.createGraphics();
                int lineX = 0;
                for (int l = 0; l < wordImages.size(); ++l) {
                    g.drawImage((Image)wordImages.elementAt(l), lineX, 0, null);
                    lineX += ((BufferedImage)wordImages.elementAt(l)).getWidth();
                }
                lineImages.addElement(lineImage);
                wordPosX = 0;
                wordPosY += textMaxHeight;
                wordImages.clear();
                newLine = true;
            }
            if (!firstWord) {
                lineWidthPos += spaceWidth;
                if (SPACE != null) {
                    wordImages.addElement(SPACE.image);
                }
            }
            wordImages.addElement(wordImage);
            lineWidthPos += wordImage.getWidth();
            firstWord = false;
        }
        if (wordImages.size() > 0) {
            int lineWidth = lineWidthPos;
            if (textMaxWidth < lineWidth) {
                textMaxWidth = lineWidth;
            }
            if (textMaxUsedWidth < textMaxWidth) {
                textMaxUsedWidth = textMaxWidth;
            }
            if (textMaxWidth < lineWidth) {
                textMaxWidth = textMaxUsedWidth;
            }
            BufferedImage lineImage = new BufferedImage(textMaxWidth, textMaxHeight, 2);
            Graphics2D g = lineImage.createGraphics();
            int lineX = 0;
            for (int l = 0; l < wordImages.size(); ++l) {
                g.drawImage((Image)wordImages.elementAt(l), lineX, 0, null);
                lineX += ((BufferedImage)wordImages.elementAt(l)).getWidth();
            }
            lineImages.addElement(lineImage);
            wordPosY += textMaxHeight;
        }
        BufferedImage allTextImage = new BufferedImage(textMaxWidth, textMaxHeight * lineImages.size(), 2);
        Graphics2D g = allTextImage.createGraphics();
        int lineY = 0;
        for (int l = 0; l < lineImages.size(); ++l) {
            g.drawImage((Image)lineImages.elementAt(l), 0, lineY, null);
            lineY += textMaxHeight;
        }
        return allTextImage;
    }

    class BCharacterImage {
        int basline = 0;
        int kerning = -1;
        String letter;
        BufferedImage image;

        BCharacterImage(String l, BufferedImage i, int b) {
            this.basline = b;
            this.letter = l;
            this.image = i;
        }

        BCharacterImage(String l, BufferedImage i, int b, int k) {
            this.basline = b;
            this.letter = l;
            this.image = i;
            this.kerning = k;
        }
    }
}

