/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.config.Configuration;
import de.malban.config.theme.Theme;
import de.malban.gui.components.CSAInternalFrame;
import de.malban.gui.components.CSAView;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class CSAMacMenuInternalFrame
extends CSAInternalFrame {
    CSAView mParent = null;
    JComponent mPanel;
    protected JDesktopPane m_desktop;
    protected boolean m_undecorated;

    public CSAMacMenuInternalFrame() {
        this.setRootPaneCheckingEnabled(false);
        this.initComponents();
        Theme t = Configuration.getConfiguration().getCurrentTheme();
        this.setFrameIcon(new ImageIcon(t.getImage("BlueIconSmall.png")));
    }

    @Override
    public void setParent(CSAView p) {
        this.mParent = p;
    }

    private void initComponents() {
        this.setClosable(true);
        this.setResizable(true);
        this.setPreferredSize(new Dimension(800, 600));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                CSAMacMenuInternalFrame.this.formInternalFrameClosed(evt);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.pack();
    }

    private void formInternalFrameClosed(InternalFrameEvent evt) {
        if (this.mParent != null) {
            this.mParent.removeInternalFrame(this);
        }
    }

    public void addPanel(JComponent panel) {
        this.mPanel = panel;
        this.add((Component)panel, "Center");
    }

    @Override
    public JPanel getPanel() {
        return (JPanel)this.mPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        JDesktopPane desktop = this.getDesktopPane();
        if (desktop != null && desktop.isShowing()) {
            Dimension size = desktop.getSize();
            Border border = this.getBorder();
            if (border != null) {
                Insets margin = border.getBorderInsets(this);
                size.height -= margin.top;
            }
            prefSize.width = Math.min(size.width, prefSize.width);
            prefSize.height = Math.min(size.height, prefSize.height);
        }
        return prefSize;
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                try {
                    this.setIcon(false);
                    this.setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    Logger.global.throwing(this.getClass().getName(), "setState", e);
                }
                break;
            }
            case 1: {
                try {
                    this.setIcon(true);
                }
                catch (PropertyVetoException e) {
                    Logger.global.throwing(this.getClass().getName(), "setState", e);
                }
                break;
            }
            case 6: {
                try {
                    this.setMaximum(true);
                    break;
                }
                catch (PropertyVetoException e) {
                    Logger.global.throwing(this.getClass().getName(), "setState", e);
                }
            }
        }
    }

    public int getState() {
        if (this.isMaximum()) {
            return 6;
        }
        if (this.isIcon()) {
            return 1;
        }
        return 0;
    }

    public void setLocationRelativeTo(Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof JInternalFrame) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof JInternalFrame)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (root == null) {
            JDesktopPane desktop = this.getDesktopPane();
            Dimension paneSize = this.getSize();
            Dimension screenSize = desktop.getSize();
            int locationX = 0;
            int locationY = 0;
            if (screenSize.width > paneSize.width) {
                locationX = (screenSize.width - paneSize.width) / 2;
            }
            if (screenSize.width > paneSize.width) {
                locationY = (screenSize.height - paneSize.height) / 2;
            }
            this.setLocation(locationX, locationY);
        } else {
            Dimension invokerSize = c.getSize();
            if (root instanceof Applet) {
                Point invokerScreenLocation = c.getLocationOnScreen();
            } else {
                Point invokerScreenLocation = new Point(0, 0);
                for (Component tc = c; tc != null; tc = tc.getParent()) {
                    Point tcl = tc.getLocation();
                    invokerScreenLocation.x += tcl.x;
                    invokerScreenLocation.y += tcl.y;
                    if (tc == root) break;
                }
                Rectangle dialogBounds = this.getBounds();
                int dx = invokerScreenLocation.x + (invokerSize.width - dialogBounds.width >> 1);
                int dy = invokerScreenLocation.y + (invokerSize.height - dialogBounds.height >> 1);
                Dimension ss = this.getToolkit().getScreenSize();
                if (dy + dialogBounds.height > ss.height) {
                    dy = ss.height - dialogBounds.height;
                    int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - dialogBounds.width;
                }
                if (dx + dialogBounds.width > ss.width) {
                    dx = ss.width - dialogBounds.width;
                }
                if (dx < 0) {
                    dx = 0;
                }
                if (dy < 0) {
                    dy = 0;
                }
                this.setLocation(dx, dy);
            }
        }
    }

    public boolean isUndecorated() {
        return this.m_undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        if (this.m_undecorated != undecorated) {
            this.m_undecorated = undecorated;
            BasicInternalFrameUI ui = (BasicInternalFrameUI)this.getUI();
            if (undecorated) {
                this.putClientProperty("titlePane", ui.getNorthPane());
                this.putClientProperty("border", this.getBorder());
                ui.setNorthPane(null);
                this.setBorder(null);
            } else {
                ui.setNorthPane((JComponent)this.getClientProperty("titlePane"));
                this.setBorder((Border)this.getClientProperty("border"));
                this.putClientProperty("titlePane", null);
                this.putClientProperty("border", null);
            }
        }
        this.setResizable(!undecorated);
    }
}

