/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.gui.components.ImageSequencer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;

public class FadingImageLabel
extends JLabel
implements Runnable {
    public static final int DEFAULT_STEP = 30;
    static int counter = 0;
    int thiscCounter = counter++;
    Vector<Icon> icons = new Vector();
    Thread animator = null;
    boolean doRun = false;
    int index = 0;
    int animDelay = 25;
    boolean fadeIn = true;
    int startStep = 0;
    int stopStep = this.icons.size();

    public FadingImageLabel(String name) {
        this(name, 30);
    }

    public void deinit() {
        this.doRun = false;
        this.animator = null;
        this.icons = null;
    }

    public FadingImageLabel(String name, int count) {
        this.icons = ImageSequencer.createFromImageFading(name, count).getAsIcons();
        this.setSize(this.icons.elementAt(0).getIconWidth(), this.icons.elementAt(0).getIconHeight());
        this.setIcon(this.icons.elementAt(this.icons.size() - 1));
    }

    public void fadeOut() {
        this.fadeOut(0, this.icons.size());
    }

    public void fadeOut(int fromStep, int toStep) {
        if (this.animator != null) {
            return;
        }
        if (this.icons.isEmpty()) {
            return;
        }
        if (this.icons.size() == 1) {
            this.setIcon(this.icons.elementAt(0));
            return;
        }
        this.startStep = this.stopStep;
        if (toStep > this.icons.size() - 1) {
            toStep = this.icons.size() - 1;
        }
        this.startStep = 0;
        this.stopStep = toStep;
        this.animator = new Thread(this);
        this.doRun = true;
        this.fadeIn = false;
        this.index = fromStep;
        this.animator.start();
    }

    public void fadeIn() {
        this.fadeIn(this.icons.size(), 0);
    }

    public void fadeIn(int fromStep, int toStep) {
        if (this.animator != null) {
            return;
        }
        if (this.icons.isEmpty()) {
            return;
        }
        if (this.icons.size() == 1) {
            this.setIcon(this.icons.elementAt(0));
            return;
        }
        if (toStep < 0) {
            toStep = 0;
        }
        this.startStep = fromStep;
        this.stopStep = toStep;
        this.animator = new Thread(this);
        this.doRun = true;
        this.fadeIn = true;
        this.index = fromStep;
        this.animator.start();
    }

    public void setDelay(int d) {
        this.animDelay = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.doRun) {
            try {
                Thread.sleep(this.animDelay);
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.doRun) {
                FadingImageLabel fadingImageLabel = this;
                synchronized (fadingImageLabel) {
                    if (!this.fadeIn) {
                        ++this.index;
                        if (this.index >= this.stopStep) {
                            this.doRun = false;
                            this.animator = null;
                            this.setVisible(false);
                        }
                    } else {
                        --this.index;
                        if (this.index <= this.stopStep) {
                            this.doRun = false;
                            this.animator = null;
                        }
                    }
                    if (this.doRun) {
                        try {
                            this.setIcon(this.icons.elementAt(this.index));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            this.repaint();
        }
    }
}

